rule win_marap_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.marap."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.marap"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e9???????? 8386e41d000002 e9???????? 8386e41d000003 }
            // n = 4, score = 100
            //   e9????????           |                     
            //   8386e41d000002       | add                 dword ptr [esi + 0x1de4], 2
            //   e9????????           |                     
            //   8386e41d000003       | add                 dword ptr [esi + 0x1de4], 3

        $sequence_1 = { 7409 8386e41d000008 eb2f 84c0 7908 018ee41d0000 }
            // n = 6, score = 100
            //   7409                 | je                  0xb
            //   8386e41d000008       | add                 dword ptr [esi + 0x1de4], 8
            //   eb2f                 | jmp                 0x31
            //   84c0                 | test                al, al
            //   7908                 | jns                 0xa
            //   018ee41d0000         | add                 dword ptr [esi + 0x1de4], ecx

        $sequence_2 = { ff15???????? 8bf0 89b59cfbffff 83feff 7472 }
            // n = 5, score = 100
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   89b59cfbffff         | mov                 dword ptr [ebp - 0x464], esi
            //   83feff               | cmp                 esi, -1
            //   7472                 | je                  0x74

        $sequence_3 = { ff15???????? 85c0 7425 8b480c 8b11 8b02 }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7425                 | je                  0x27
            //   8b480c               | mov                 ecx, dword ptr [eax + 0xc]
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   8b02                 | mov                 eax, dword ptr [edx]

        $sequence_4 = { 81fb00040000 737e 8bc7 8bd7 668b08 }
            // n = 5, score = 100
            //   81fb00040000         | cmp                 ebx, 0x400
            //   737e                 | jae                 0x80
            //   8bc7                 | mov                 eax, edi
            //   8bd7                 | mov                 edx, edi
            //   668b08               | mov                 cx, word ptr [eax]

        $sequence_5 = { 0fbe84c1f8cb0010 6a07 c1f804 59 }
            // n = 4, score = 100
            //   0fbe84c1f8cb0010     | movsx               eax, byte ptr [ecx + eax*8 + 0x1000cbf8]
            //   6a07                 | push                7
            //   c1f804               | sar                 eax, 4
            //   59                   | pop                 ecx

        $sequence_6 = { 83c40c 8d7bfe 668b4702 83c702 6685c0 75f4 }
            // n = 6, score = 100
            //   83c40c               | add                 esp, 0xc
            //   8d7bfe               | lea                 edi, [ebx - 2]
            //   668b4702             | mov                 ax, word ptr [edi + 2]
            //   83c702               | add                 edi, 2
            //   6685c0               | test                ax, ax
            //   75f4                 | jne                 0xfffffff6

        $sequence_7 = { 8d1c8580320110 8b03 83e71f c1e706 8a4c3824 }
            // n = 5, score = 100
            //   8d1c8580320110       | lea                 ebx, [eax*4 + 0x10013280]
            //   8b03                 | mov                 eax, dword ptr [ebx]
            //   83e71f               | and                 edi, 0x1f
            //   c1e706               | shl                 edi, 6
            //   8a4c3824             | mov                 cl, byte ptr [eax + edi + 0x24]

        $sequence_8 = { 8d4310 8d8954f40010 5a 668b31 }
            // n = 4, score = 100
            //   8d4310               | lea                 eax, [ebx + 0x10]
            //   8d8954f40010         | lea                 ecx, [ecx + 0x1000f454]
            //   5a                   | pop                 edx
            //   668b31               | mov                 si, word ptr [ecx]

        $sequence_9 = { 80f901 0f8487000000 6683fa06 7519 84c0 }
            // n = 5, score = 100
            //   80f901               | cmp                 cl, 1
            //   0f8487000000         | je                  0x8d
            //   6683fa06             | cmp                 dx, 6
            //   7519                 | jne                 0x1b
            //   84c0                 | test                al, al

    condition:
        7 of them and filesize < 188416
}