rule win_matrix_ransom_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.matrix_ransom"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d95f0feffff 8bc6 ff55f8 8d95f0feffff 8bcf 8b45fc e8???????? }
            // n = 7, score = 100
            //   8d95f0feffff         | lea                 edx, [ebp - 0x110]
            //   8bc6                 | mov                 eax, esi
            //   ff55f8               | call                dword ptr [ebp - 8]
            //   8d95f0feffff         | lea                 edx, [ebp - 0x110]
            //   8bcf                 | mov                 ecx, edi
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   e8????????           |                     

        $sequence_1 = { 8d4c2410 8b03 33d2 8b38 ff5724 3d57000780 7507 }
            // n = 7, score = 100
            //   8d4c2410             | lea                 ecx, [esp + 0x10]
            //   8b03                 | mov                 eax, dword ptr [ebx]
            //   33d2                 | xor                 edx, edx
            //   8b38                 | mov                 edi, dword ptr [eax]
            //   ff5724               | call                dword ptr [edi + 0x24]
            //   3d57000780           | cmp                 eax, 0x80070057
            //   7507                 | jne                 9

        $sequence_2 = { e9???????? c645de01 eb04 c645de01 33c0 5a }
            // n = 6, score = 100
            //   e9????????           |                     
            //   c645de01             | mov                 byte ptr [ebp - 0x22], 1
            //   eb04                 | jmp                 6
            //   c645de01             | mov                 byte ptr [ebp - 0x22], 1
            //   33c0                 | xor                 eax, eax
            //   5a                   | pop                 edx

        $sequence_3 = { 7c30 8b7500 85f6 7420 b21f b8???????? 8530 }
            // n = 7, score = 100
            //   7c30                 | jl                  0x32
            //   8b7500               | mov                 esi, dword ptr [ebp]
            //   85f6                 | test                esi, esi
            //   7420                 | je                  0x22
            //   b21f                 | mov                 dl, 0x1f
            //   b8????????           |                     
            //   8530                 | test                dword ptr [eax], esi

        $sequence_4 = { 8bd3 85d2 7905 e8???????? 8d45fc e8???????? }
            // n = 6, score = 100
            //   8bd3                 | mov                 edx, ebx
            //   85d2                 | test                edx, edx
            //   7905                 | jns                 7
            //   e8????????           |                     
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   e8????????           |                     

        $sequence_5 = { 0f8528ffffff 8b431c 83b8b801000000 0f94c0 8bd8 33c0 }
            // n = 6, score = 100
            //   0f8528ffffff         | jne                 0xffffff2e
            //   8b431c               | mov                 eax, dword ptr [ebx + 0x1c]
            //   83b8b801000000       | cmp                 dword ptr [eax + 0x1b8], 0
            //   0f94c0               | sete                al
            //   8bd8                 | mov                 ebx, eax
            //   33c0                 | xor                 eax, eax

        $sequence_6 = { 837de800 0f8485010000 8b45e8 8945e0 80bb8800000000 740f 8b45f0 }
            // n = 7, score = 100
            //   837de800             | cmp                 dword ptr [ebp - 0x18], 0
            //   0f8485010000         | je                  0x18b
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax
            //   80bb8800000000       | cmp                 byte ptr [ebx + 0x88], 0
            //   740f                 | je                  0x11
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]

        $sequence_7 = { 83c030 e8???????? 8bf0 8bc3 83e804 740c 83e804 }
            // n = 7, score = 100
            //   83c030               | add                 eax, 0x30
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   8bc3                 | mov                 eax, ebx
            //   83e804               | sub                 eax, 4
            //   740c                 | je                  0xe
            //   83e804               | sub                 eax, 4

        $sequence_8 = { ff530c 81bd0cf0ffffd1cd9549 7529 81bd70f5ffffd1cd9549 751d c645de00 8b45e8 }
            // n = 7, score = 100
            //   ff530c               | call                dword ptr [ebx + 0xc]
            //   81bd0cf0ffffd1cd9549     | cmp    dword ptr [ebp - 0xff4], 0x4995cdd1
            //   7529                 | jne                 0x2b
            //   81bd70f5ffffd1cd9549     | cmp    dword ptr [ebp - 0xa90], 0x4995cdd1
            //   751d                 | jne                 0x1f
            //   c645de00             | mov                 byte ptr [ebp - 0x22], 0
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]

        $sequence_9 = { e8???????? 8d45fc 33c9 ba14000000 e8???????? bb01000000 8d45fc }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   33c9                 | xor                 ecx, ecx
            //   ba14000000           | mov                 edx, 0x14
            //   e8????????           |                     
            //   bb01000000           | mov                 ebx, 1
            //   8d45fc               | lea                 eax, [ebp - 4]

    condition:
        7 of them and filesize < 2211840
}