rule win_maze_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.maze."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.maze"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8945f0 c745f000000000 8b45f0 83c410 5e 5f 5b }
            // n = 7, score = 2400
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   c745f000000000       | mov                 dword ptr [ebp - 0x10], 0
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   83c410               | add                 esp, 0x10
            //   5e                   | pop                 esi
            //   5f                   | pop                 edi
            //   5b                   | pop                 ebx

        $sequence_1 = { 83ec10 8b4510 8b4d0c 8b5508 837d0800 8945ec 894de8 }
            // n = 7, score = 2400
            //   83ec10               | sub                 esp, 0x10
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   837d0800             | cmp                 dword ptr [ebp + 8], 0
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   894de8               | mov                 dword ptr [ebp - 0x18], ecx

        $sequence_2 = { 53 57 56 83ec10 8b4510 8b4d0c }
            // n = 6, score = 2400
            //   53                   | push                ebx
            //   57                   | push                edi
            //   56                   | push                esi
            //   83ec10               | sub                 esp, 0x10
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]

        $sequence_3 = { 8945ec 894de8 8955e4 7509 }
            // n = 4, score = 2400
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   894de8               | mov                 dword ptr [ebp - 0x18], ecx
            //   8955e4               | mov                 dword ptr [ebp - 0x1c], edx
            //   7509                 | jne                 0xb

        $sequence_4 = { 8955e4 7509 c745f000000000 eb17 60 8b7d08 }
            // n = 6, score = 2400
            //   8955e4               | mov                 dword ptr [ebp - 0x1c], edx
            //   7509                 | jne                 0xb
            //   c745f000000000       | mov                 dword ptr [ebp - 0x10], 0
            //   eb17                 | jmp                 0x19
            //   60                   | pushal              
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]

        $sequence_5 = { 60 8b7d08 8b4d10 8b450c f3aa 61 8945f0 }
            // n = 7, score = 2400
            //   60                   | pushal              
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   f3aa                 | rep stosb           byte ptr es:[edi], al
            //   61                   | popal               
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax

        $sequence_6 = { 89c8 0fa4d10b c1f815 034c2418 130424 81e2ffff1f00 }
            // n = 6, score = 2300
            //   89c8                 | mov                 eax, ecx
            //   0fa4d10b             | shld                ecx, edx, 0xb
            //   c1f815               | sar                 eax, 0x15
            //   034c2418             | add                 ecx, dword ptr [esp + 0x18]
            //   130424               | adc                 eax, dword ptr [esp]
            //   81e2ffff1f00         | and                 edx, 0x1fffff

        $sequence_7 = { 89c8 0fa4f00e 0fa4ce17 31c6 }
            // n = 4, score = 2300
            //   89c8                 | mov                 eax, ecx
            //   0fa4f00e             | shld                eax, esi, 0xe
            //   0fa4ce17             | shld                esi, ecx, 0x17
            //   31c6                 | xor                 esi, eax

        $sequence_8 = { 41 41 41 41 41 41 41 }
            // n = 7, score = 1600
            //   41                   | inc                 ecx
            //   41                   | inc                 ecx
            //   41                   | inc                 ecx
            //   41                   | inc                 ecx
            //   41                   | inc                 ecx
            //   41                   | inc                 ecx
            //   41                   | inc                 ecx

        $sequence_9 = { 6afe ff35???????? ff35???????? 64a100000000 50 }
            // n = 5, score = 1400
            //   6afe                 | push                -2
            //   ff35????????         |                     
            //   ff35????????         |                     
            //   64a100000000         | mov                 eax, dword ptr fs:[0]
            //   50                   | push                eax

        $sequence_10 = { c745cc30114100 a1???????? 8d4dc8 33c1 }
            // n = 4, score = 100
            //   c745cc30114100       | mov                 dword ptr [ebp - 0x34], 0x411130
            //   a1????????           |                     
            //   8d4dc8               | lea                 ecx, [ebp - 0x38]
            //   33c1                 | xor                 eax, ecx

        $sequence_11 = { 8b840a40100000 c1e00a b904000000 6bd100 8b4d08 8b941140100000 }
            // n = 6, score = 100
            //   8b840a40100000       | mov                 eax, dword ptr [edx + ecx + 0x1040]
            //   c1e00a               | shl                 eax, 0xa
            //   b904000000           | mov                 ecx, 4
            //   6bd100               | imul                edx, ecx, 0
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8b941140100000       | mov                 edx, dword ptr [ecx + edx + 0x1040]

        $sequence_12 = { 8d15c0654000 e8???????? 58 5a 5f 8b4dfc 33cd }
            // n = 7, score = 100
            //   8d15c0654000         | lea                 edx, [0x4065c0]
            //   e8????????           |                     
            //   58                   | pop                 eax
            //   5a                   | pop                 edx
            //   5f                   | pop                 edi
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   33cd                 | xor                 ecx, ebp

        $sequence_13 = { 89559c ba04000000 c1e203 8b4508 8a8c1000100000 }
            // n = 5, score = 100
            //   89559c               | mov                 dword ptr [ebp - 0x64], edx
            //   ba04000000           | mov                 edx, 4
            //   c1e203               | shl                 edx, 3
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8a8c1000100000       | mov                 cl, byte ptr [eax + edx + 0x1000]

        $sequence_14 = { 8b4d08 8b940140100000 c1ea10 889506feffff 0fb68507feffff 0fb68d06feffff 8b5508 }
            // n = 7, score = 100
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8b940140100000       | mov                 edx, dword ptr [ecx + eax + 0x1040]
            //   c1ea10               | shr                 edx, 0x10
            //   889506feffff         | mov                 byte ptr [ebp - 0x1fa], dl
            //   0fb68507feffff       | movzx               eax, byte ptr [ebp - 0x1f9]
            //   0fb68d06feffff       | movzx               ecx, byte ptr [ebp - 0x1fa]
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]

        $sequence_15 = { 8b0c88 8b4508 038c9000040000 898d80feffff 8b4dfc 8b5508 8b848a0c080000 }
            // n = 7, score = 100
            //   8b0c88               | mov                 ecx, dword ptr [eax + ecx*4]
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   038c9000040000       | add                 ecx, dword ptr [eax + edx*4 + 0x400]
            //   898d80feffff         | mov                 dword ptr [ebp - 0x180], ecx
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   8b848a0c080000       | mov                 eax, dword ptr [edx + ecx*4 + 0x80c]

        $sequence_16 = { 8b4d08 8b54813c c1e209 8b45fc 8b4d08 8b44813c }
            // n = 6, score = 100
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8b54813c             | mov                 edx, dword ptr [ecx + eax*4 + 0x3c]
            //   c1e209               | shl                 edx, 9
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8b44813c             | mov                 eax, dword ptr [ecx + eax*4 + 0x3c]

        $sequence_17 = { 0bca 898dd0fdffff 8b85d8fdffff 3385d4fdffff 0385d0fdffff 8b4dfc }
            // n = 6, score = 100
            //   0bca                 | or                  ecx, edx
            //   898dd0fdffff         | mov                 dword ptr [ebp - 0x230], ecx
            //   8b85d8fdffff         | mov                 eax, dword ptr [ebp - 0x228]
            //   3385d4fdffff         | xor                 eax, dword ptr [ebp - 0x22c]
            //   0385d0fdffff         | add                 eax, dword ptr [ebp - 0x230]
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]

    condition:
        7 of them and filesize < 2318336
}