rule win_micrass_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.micrass."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.micrass"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83bd20faffff14 7324 8b85f0fcffff 038520faffff }
            // n = 4, score = 100
            //   83bd20faffff14       | cmp                 dword ptr [ebp - 0x5e0], 0x14
            //   7324                 | jae                 0x26
            //   8b85f0fcffff         | mov                 eax, dword ptr [ebp - 0x310]
            //   038520faffff         | add                 eax, dword ptr [ebp - 0x5e0]

        $sequence_1 = { 8bec 837d0800 7e1f 56 b9???????? 8bf2 2bc8 }
            // n = 7, score = 100
            //   8bec                 | mov                 ebp, esp
            //   837d0800             | cmp                 dword ptr [ebp + 8], 0
            //   7e1f                 | jle                 0x21
            //   56                   | push                esi
            //   b9????????           |                     
            //   8bf2                 | mov                 esi, edx
            //   2bc8                 | sub                 ecx, eax

        $sequence_2 = { 0fb6c0 eb12 8b45e0 8a807c194000 08443b1d 0fb64601 }
            // n = 6, score = 100
            //   0fb6c0               | movzx               eax, al
            //   eb12                 | jmp                 0x14
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]
            //   8a807c194000         | mov                 al, byte ptr [eax + 0x40197c]
            //   08443b1d             | or                  byte ptr [ebx + edi + 0x1d], al
            //   0fb64601             | movzx               eax, byte ptr [esi + 1]

        $sequence_3 = { 2b34bda0dd4000 c1fe06 8bc7 c1e005 }
            // n = 4, score = 100
            //   2b34bda0dd4000       | sub                 esi, dword ptr [edi*4 + 0x40dda0]
            //   c1fe06               | sar                 esi, 6
            //   8bc7                 | mov                 eax, edi
            //   c1e005               | shl                 eax, 5

        $sequence_4 = { 83c40c 8d85e8fbffff 8985f0fcffff 83a520faffff00 }
            // n = 4, score = 100
            //   83c40c               | add                 esp, 0xc
            //   8d85e8fbffff         | lea                 eax, [ebp - 0x418]
            //   8985f0fcffff         | mov                 dword ptr [ebp - 0x310], eax
            //   83a520faffff00       | and                 dword ptr [ebp - 0x5e0], 0

        $sequence_5 = { 56 50 e8???????? 8b85e44fffff 83c40c }
            // n = 5, score = 100
            //   56                   | push                esi
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b85e44fffff         | mov                 eax, dword ptr [ebp - 0xb01c]
            //   83c40c               | add                 esp, 0xc

        $sequence_6 = { 6a05 59 be???????? 8dbd0cfdffff }
            // n = 4, score = 100
            //   6a05                 | push                5
            //   59                   | pop                 ecx
            //   be????????           |                     
            //   8dbd0cfdffff         | lea                 edi, [ebp - 0x2f4]

        $sequence_7 = { ff15???????? 6804010000 57 53 e8???????? 83c40c }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   6804010000           | push                0x104
            //   57                   | push                edi
            //   53                   | push                ebx
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_8 = { 8945ec 6bc0f8 894df4 2955f4 014508 }
            // n = 5, score = 100
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   6bc0f8               | imul                eax, eax, -8
            //   894df4               | mov                 dword ptr [ebp - 0xc], ecx
            //   2955f4               | sub                 dword ptr [ebp - 0xc], edx
            //   014508               | add                 dword ptr [ebp + 8], eax

        $sequence_9 = { 8bcb e8???????? 59 837e4400 57 bf???????? }
            // n = 6, score = 100
            //   8bcb                 | mov                 ecx, ebx
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   837e4400             | cmp                 dword ptr [esi + 0x44], 0
            //   57                   | push                edi
            //   bf????????           |                     

    condition:
        7 of them and filesize < 163840
}