rule win_mimic_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.mimic."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mimic"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83fa08 7231 8b8db4f5ffff 8d145502000000 8bc1 81fa00100000 7210 }
            // n = 7, score = 100
            //   83fa08               | cmp                 edx, 8
            //   7231                 | jb                  0x33
            //   8b8db4f5ffff         | mov                 ecx, dword ptr [ebp - 0xa4c]
            //   8d145502000000       | lea                 edx, [edx*2 + 2]
            //   8bc1                 | mov                 eax, ecx
            //   81fa00100000         | cmp                 edx, 0x1000
            //   7210                 | jb                  0x12

        $sequence_1 = { c60100 e8???????? 8a955bfeffff 8d8d30feffff e8???????? 83c418 89854cfeffff }
            // n = 7, score = 100
            //   c60100               | mov                 byte ptr [ecx], 0
            //   e8????????           |                     
            //   8a955bfeffff         | mov                 dl, byte ptr [ebp - 0x1a5]
            //   8d8d30feffff         | lea                 ecx, [ebp - 0x1d0]
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   89854cfeffff         | mov                 dword ptr [ebp - 0x1b4], eax

        $sequence_2 = { 8d442424 50 6a28 ff15???????? 50 ff15???????? 85c0 }
            // n = 7, score = 100
            //   8d442424             | lea                 eax, [esp + 0x24]
            //   50                   | push                eax
            //   6a28                 | push                0x28
            //   ff15????????         |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_3 = { e8???????? 8d4dcc 8b30 8d8548feffff 50 e8???????? 57 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8d4dcc               | lea                 ecx, [ebp - 0x34]
            //   8b30                 | mov                 esi, dword ptr [eax]
            //   8d8548feffff         | lea                 eax, [ebp - 0x1b8]
            //   50                   | push                eax
            //   e8????????           |                     
            //   57                   | push                edi

        $sequence_4 = { 68???????? 57 894590 ff15???????? 68???????? 57 89458c }
            // n = 7, score = 100
            //   68????????           |                     
            //   57                   | push                edi
            //   894590               | mov                 dword ptr [ebp - 0x70], eax
            //   ff15????????         |                     
            //   68????????           |                     
            //   57                   | push                edi
            //   89458c               | mov                 dword ptr [ebp - 0x74], eax

        $sequence_5 = { 0f872a040000 52 51 e8???????? 83c408 57 }
            // n = 6, score = 100
            //   0f872a040000         | ja                  0x430
            //   52                   | push                edx
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   57                   | push                edi

        $sequence_6 = { e8???????? 8945e4 c745fc00000000 c7461000000000 c746140f000000 c60600 c745ec08000000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   c7461000000000       | mov                 dword ptr [esi + 0x10], 0
            //   c746140f000000       | mov                 dword ptr [esi + 0x14], 0xf
            //   c60600               | mov                 byte ptr [esi], 0
            //   c745ec08000000       | mov                 dword ptr [ebp - 0x14], 8

        $sequence_7 = { 8d4dd4 e9???????? 8d4dec e9???????? 6a1c 8b857cfdffff 50 }
            // n = 7, score = 100
            //   8d4dd4               | lea                 ecx, [ebp - 0x2c]
            //   e9????????           |                     
            //   8d4dec               | lea                 ecx, [ebp - 0x14]
            //   e9????????           |                     
            //   6a1c                 | push                0x1c
            //   8b857cfdffff         | mov                 eax, dword ptr [ebp - 0x284]
            //   50                   | push                eax

        $sequence_8 = { c745d00f000000 c645bc00 e8???????? c645fc04 8d4dbc 6a0e 68???????? }
            // n = 7, score = 100
            //   c745d00f000000       | mov                 dword ptr [ebp - 0x30], 0xf
            //   c645bc00             | mov                 byte ptr [ebp - 0x44], 0
            //   e8????????           |                     
            //   c645fc04             | mov                 byte ptr [ebp - 4], 4
            //   8d4dbc               | lea                 ecx, [ebp - 0x44]
            //   6a0e                 | push                0xe
            //   68????????           |                     

        $sequence_9 = { c785e0fefffff3dd6046 50 68060000c8 56 c785e4feffff8ee976e5 c785e8feffff8c74063e ff15???????? }
            // n = 7, score = 100
            //   c785e0fefffff3dd6046     | mov    dword ptr [ebp - 0x120], 0x4660ddf3
            //   50                   | push                eax
            //   68060000c8           | push                0xc8000006
            //   56                   | push                esi
            //   c785e4feffff8ee976e5     | mov    dword ptr [ebp - 0x11c], 0xe576e98e
            //   c785e8feffff8c74063e     | mov    dword ptr [ebp - 0x118], 0x3e06748c
            //   ff15????????         |                     

    condition:
        7 of them and filesize < 4204544
}