rule win_misfox_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.misfox."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.misfox"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 51 ba00020000 c744244800080000 8d4c2434 89442444 e8???????? 83c404 }
            // n = 7, score = 300
            //   51                   | inc                 ecx
            //   ba00020000           | add                 ecx, 0x12c0
            //   c744244800080000     | inc                 ecx
            //   8d4c2434             | lea                 ecx, [eax + eax*4]
            //   89442444             | mov                 eax, 0x66666667
            //   e8????????           |                     
            //   83c404               | imul                edx, ecx, 0x99

        $sequence_1 = { 8d7f04 f77d08 8b45f8 46 0fb61402 03d1 0355fc }
            // n = 7, score = 300
            //   8d7f04               | dec                 eax
            //   f77d08               | sar                 ebx, 5
            //   8b45f8               | dec                 esp
            //   46                   | lea                 esi, [0xe312]
            //   0fb61402             | inc                 ebp
            //   03d1                 | lea                 ecx, [esi + 0x1b]
            //   0355fc               | inc                 ebp

        $sequence_2 = { 884dab 83f80b 0f877b020000 ff2485b4d30010 8d41cf 3c08 }
            // n = 6, score = 300
            //   884dab               | dec                 eax
            //   83f80b               | lea                 eax, [ebp + 0xd0]
            //   0f877b020000         | dec                 eax
            //   ff2485b4d30010       | mov                 dword ptr [esp + 0x20], eax
            //   8d41cf               | inc                 ebp
            //   3c08                 | xor                 ecx, ecx

        $sequence_3 = { 6a02 6a00 6a00 6800000040 8d84243c010000 }
            // n = 5, score = 300
            //   6a02                 | mov                 byte ptr [ebp - 0x55], cl
            //   6a00                 | cmp                 eax, 0xb
            //   6a00                 | ja                  0x284
            //   6800000040           | jmp                 dword ptr [eax*4 + 0x1000d3b4]
            //   8d84243c010000       | lea                 eax, [ecx - 0x31]

        $sequence_4 = { 56 ff15???????? 8d4c2410 e8???????? 56 ff15???????? }
            // n = 6, score = 300
            //   56                   | cmp                 al, 8
            //   ff15????????         |                     
            //   8d4c2410             | push                edi
            //   e8????????           |                     
            //   56                   | xor                 eax, eax
            //   ff15????????         |                     

        $sequence_5 = { 57 33c0 8d7b08 8bf7 8906 }
            // n = 5, score = 300
            //   57                   | jae                 0x7f
            //   33c0                 | dec                 eax
            //   8d7b08               | mov                 eax, edi
            //   8bf7                 | dec                 eax
            //   8906                 | mov                 ebx, edi

        $sequence_6 = { 8b048550870110 f644010440 7409 803a1a 7504 }
            // n = 5, score = 300
            //   8b048550870110       | lea                 edi, [ebx + 8]
            //   f644010440           | mov                 esi, edi
            //   7409                 | mov                 dword ptr [esi], eax
            //   803a1a               | lea                 edi, [edi + 4]
            //   7504                 | idiv                dword ptr [ebp + 8]

        $sequence_7 = { 6a25 40 50 8d45d0 50 ff15???????? 8d45c0 }
            // n = 7, score = 300
            //   6a25                 | xor                 eax, eax
            //   40                   | dec                 eax
            //   50                   | mov                 edx, esi
            //   8d45d0               | dec                 eax
            //   50                   | mov                 ecx, 0x80000001
            //   ff15????????         |                     
            //   8d45c0               | lea                 eax, [edx + edx*2]

        $sequence_8 = { e8???????? 488d053cf90000 488d15b56c0100 488d4c2420 4889442420 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   488d053cf90000       | dec                 eax
            //   488d15b56c0100       | lea                 eax, [0xf93c]
            //   488d4c2420           | dec                 eax
            //   4889442420           | lea                 edx, [0x16cb5]

        $sequence_9 = { 3b3d???????? 737d 488bc7 488bdf 48c1fb05 4c8d3512e30000 }
            // n = 6, score = 100
            //   3b3d????????         |                     
            //   737d                 | push                ebp
            //   488bc7               | dec                 eax
            //   488bdf               | mov                 ebp, esp
            //   48c1fb05             | mov                 eax, 0xe5ac81fb
            //   4c8d3512e30000       | inc                 ecx

        $sequence_10 = { 458d4e1b 4533c0 488bd6 48c7c101000080 }
            // n = 4, score = 100
            //   458d4e1b             | imul                ecx
            //   4533c0               | inc                 ecx
            //   488bd6               | add                 edx, ecx
            //   48c7c101000080       | sar                 edx, 0xf

        $sequence_11 = { 8b7520 eb04 8b742460 488d85d0000000 4889442420 4533c9 }
            // n = 6, score = 100
            //   8b7520               | and                 dword ptr [ecx + 0xc8], 0xfffffffd
            //   eb04                 | mov                 ebx, 0x22
            //   8b742460             | dec                 eax
            //   488d85d0000000       | mov                 dword ptr [esp + 0x10], edi
            //   4889442420           | dec                 esp
            //   4533c9               | mov                 dword ptr [esp + 0x20], esi

        $sequence_12 = { e8???????? bb22000000 e9???????? 48897c2410 4c89742420 55 488bec }
            // n = 7, score = 100
            //   e8????????           |                     
            //   bb22000000           | dec                 esp
            //   e9????????           |                     
            //   48897c2410           | mov                 dword ptr [esp], ebx
            //   4c89742420           | sbb                 eax, eax
            //   55                   | inc                 ecx
            //   488bec               | and                 eax, esp

        $sequence_13 = { b8fb81ace5 41f7e9 4103d1 c1fa0f 8bc2 c1e81f }
            // n = 6, score = 100
            //   b8fb81ace5           | dec                 eax
            //   41f7e9               | inc                 esp
            //   4103d1               | cmp                 byte ptr [ebp - 8], dh
            //   c1fa0f               | je                  0xd
            //   8bc2                 | dec                 eax
            //   c1e81f               | mov                 ecx, dword ptr [ebp - 0x10]

        $sequence_14 = { 8b04b1 488d0cb1 418942fc 448901 4181f900010000 7cc3 4c891c24 }
            // n = 7, score = 100
            //   8b04b1               | dec                 eax
            //   488d0cb1             | lea                 ecx, [esp + 0x20]
            //   418942fc             | dec                 eax
            //   448901               | mov                 dword ptr [esp + 0x20], eax
            //   4181f900010000       | mov                 eax, dword ptr [ecx + esi*4]
            //   7cc3                 | dec                 eax
            //   4c891c24             | lea                 ecx, [ecx + esi*4]

        $sequence_15 = { 1bc0 4123c4 ffc8 443875f8 740b 488b4df0 83a1c8000000fd }
            // n = 7, score = 100
            //   1bc0                 | inc                 ecx
            //   4123c4               | mov                 dword ptr [edx - 4], eax
            //   ffc8                 | inc                 esp
            //   443875f8             | mov                 dword ptr [ecx], eax
            //   740b                 | inc                 ecx
            //   488b4df0             | cmp                 ecx, 0x100
            //   83a1c8000000fd       | jl                  0xffffffc5

    condition:
        7 of them and filesize < 266240
}