rule win_miuref_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.miuref."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.miuref"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7408 3bf9 7404 3bf8 7510 }
            // n = 5, score = 200
            //   7408                 | je                  0xa
            //   3bf9                 | cmp                 edi, ecx
            //   7404                 | je                  6
            //   3bf8                 | cmp                 edi, eax
            //   7510                 | jne                 0x12

        $sequence_1 = { ff36 e8???????? 53 8945e0 e8???????? 59 }
            // n = 6, score = 200
            //   ff36                 | push                dword ptr [esi]
            //   e8????????           |                     
            //   53                   | push                ebx
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax
            //   e8????????           |                     
            //   59                   | pop                 ecx

        $sequence_2 = { 895df0 895df4 895de8 e8???????? 59 6a15 83ec10 }
            // n = 7, score = 200
            //   895df0               | mov                 dword ptr [ebp - 0x10], ebx
            //   895df4               | mov                 dword ptr [ebp - 0xc], ebx
            //   895de8               | mov                 dword ptr [ebp - 0x18], ebx
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   6a15                 | push                0x15
            //   83ec10               | sub                 esp, 0x10

        $sequence_3 = { 53 ff75f4 e8???????? 59 59 3945f8 0f86e7feffff }
            // n = 7, score = 200
            //   53                   | push                ebx
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   3945f8               | cmp                 dword ptr [ebp - 8], eax
            //   0f86e7feffff         | jbe                 0xfffffeed

        $sequence_4 = { 83c40c 68000000f0 6a01 56 8945f4 }
            // n = 5, score = 200
            //   83c40c               | add                 esp, 0xc
            //   68000000f0           | push                0xf0000000
            //   6a01                 | push                1
            //   56                   | push                esi
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax

        $sequence_5 = { 894dd4 8b4804 53 2bca 68???????? 51 52 }
            // n = 7, score = 200
            //   894dd4               | mov                 dword ptr [ebp - 0x2c], ecx
            //   8b4804               | mov                 ecx, dword ptr [eax + 4]
            //   53                   | push                ebx
            //   2bca                 | sub                 ecx, edx
            //   68????????           |                     
            //   51                   | push                ecx
            //   52                   | push                edx

        $sequence_6 = { a1???????? c780140100006d455c02 a1???????? c78018010000a58f63dc }
            // n = 4, score = 200
            //   a1????????           |                     
            //   c780140100006d455c02     | mov    dword ptr [eax + 0x114], 0x25c456d
            //   a1????????           |                     
            //   c78018010000a58f63dc     | mov    dword ptr [eax + 0x118], 0xdc638fa5

        $sequence_7 = { 5f 53 e8???????? a1???????? 59 5b c9 }
            // n = 7, score = 200
            //   5f                   | pop                 edi
            //   53                   | push                ebx
            //   e8????????           |                     
            //   a1????????           |                     
            //   59                   | pop                 ecx
            //   5b                   | pop                 ebx
            //   c9                   | leave               

        $sequence_8 = { 50 56 ff750c 57 ff15???????? 57 ff15???????? }
            // n = 7, score = 200
            //   50                   | push                eax
            //   56                   | push                esi
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   57                   | push                edi
            //   ff15????????         |                     
            //   57                   | push                edi
            //   ff15????????         |                     

        $sequence_9 = { 59 85c0 7512 3bdd 7e03 4b eb03 }
            // n = 7, score = 200
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax
            //   7512                 | jne                 0x14
            //   3bdd                 | cmp                 ebx, ebp
            //   7e03                 | jle                 5
            //   4b                   | dec                 ebx
            //   eb03                 | jmp                 5

    condition:
        7 of them and filesize < 180224
}