rule win_mmon_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.mmon."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mmon"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4710 3bc8 770d 83c8ff }
            // n = 4, score = 100
            //   8b4710               | mov                 eax, dword ptr [edi + 0x10]
            //   3bc8                 | cmp                 ecx, eax
            //   770d                 | ja                  0xf
            //   83c8ff               | or                  eax, 0xffffffff

        $sequence_1 = { 8d48f3 83f906 0f878b000000 8d70ff 33db 33ff 83feff }
            // n = 7, score = 100
            //   8d48f3               | lea                 ecx, [eax - 0xd]
            //   83f906               | cmp                 ecx, 6
            //   0f878b000000         | ja                  0x91
            //   8d70ff               | lea                 esi, [eax - 1]
            //   33db                 | xor                 ebx, ebx
            //   33ff                 | xor                 edi, edi
            //   83feff               | cmp                 esi, -1

        $sequence_2 = { 51 6800040000 50 6a00 6800130000 ff15???????? 8b45b4 }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   6800040000           | push                0x400
            //   50                   | push                eax
            //   6a00                 | push                0
            //   6800130000           | push                0x1300
            //   ff15????????         |                     
            //   8b45b4               | mov                 eax, dword ptr [ebp - 0x4c]

        $sequence_3 = { 68???????? 56 897dfc 89bd4cffffff 898d50ffffff }
            // n = 5, score = 100
            //   68????????           |                     
            //   56                   | push                esi
            //   897dfc               | mov                 dword ptr [ebp - 4], edi
            //   89bd4cffffff         | mov                 dword ptr [ebp - 0xb4], edi
            //   898d50ffffff         | mov                 dword ptr [ebp - 0xb0], ecx

        $sequence_4 = { 68???????? c684247810000001 e8???????? 83c40c 50 }
            // n = 5, score = 100
            //   68????????           |                     
            //   c684247810000001     | mov                 byte ptr [esp + 0x1078], 1
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   50                   | push                eax

        $sequence_5 = { c1f905 8b0c8d606a4200 c1e006 0fbe440104 83e040 5d c3 }
            // n = 7, score = 100
            //   c1f905               | sar                 ecx, 5
            //   8b0c8d606a4200       | mov                 ecx, dword ptr [ecx*4 + 0x426a60]
            //   c1e006               | shl                 eax, 6
            //   0fbe440104           | movsx               eax, byte ptr [ecx + eax + 4]
            //   83e040               | and                 eax, 0x40
            //   5d                   | pop                 ebp
            //   c3                   | ret                 

        $sequence_6 = { 7303 8d4594 8b8d54ffffff 6a20 51 }
            // n = 5, score = 100
            //   7303                 | jae                 5
            //   8d4594               | lea                 eax, [ebp - 0x6c]
            //   8b8d54ffffff         | mov                 ecx, dword ptr [ebp - 0xac]
            //   6a20                 | push                0x20
            //   51                   | push                ecx

        $sequence_7 = { 8b4710 3bc8 770d 83c8ff 8bf7 e8???????? }
            // n = 6, score = 100
            //   8b4710               | mov                 eax, dword ptr [edi + 0x10]
            //   3bc8                 | cmp                 ecx, eax
            //   770d                 | ja                  0xf
            //   83c8ff               | or                  eax, 0xffffffff
            //   8bf7                 | mov                 esi, edi
            //   e8????????           |                     

        $sequence_8 = { 8d4fe2 83e81e 898d54ffffff 898548ffffff bb08000000 0fb707 83f830 }
            // n = 7, score = 100
            //   8d4fe2               | lea                 ecx, [edi - 0x1e]
            //   83e81e               | sub                 eax, 0x1e
            //   898d54ffffff         | mov                 dword ptr [ebp - 0xac], ecx
            //   898548ffffff         | mov                 dword ptr [ebp - 0xb8], eax
            //   bb08000000           | mov                 ebx, 8
            //   0fb707               | movzx               eax, word ptr [edi]
            //   83f830               | cmp                 eax, 0x30

        $sequence_9 = { 8b0d???????? 8bd6 2bd0 52 51 50 53 }
            // n = 7, score = 100
            //   8b0d????????         |                     
            //   8bd6                 | mov                 edx, esi
            //   2bd0                 | sub                 edx, eax
            //   52                   | push                edx
            //   51                   | push                ecx
            //   50                   | push                eax
            //   53                   | push                ebx

    condition:
        7 of them and filesize < 356352
}