rule win_mole_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.mole."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mole"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 52 ff15???????? 8d85dcfdffff 50 e8???????? 83c404 0fb6c8 }
            // n = 7, score = 100
            //   52                   | push                edx
            //   ff15????????         |                     
            //   8d85dcfdffff         | lea                 eax, [ebp - 0x224]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   0fb6c8               | movzx               ecx, al

        $sequence_1 = { 6a75 8b95c8eeffff 52 e8???????? 83c410 8d85cceeffff }
            // n = 6, score = 100
            //   6a75                 | push                0x75
            //   8b95c8eeffff         | mov                 edx, dword ptr [ebp - 0x1138]
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   8d85cceeffff         | lea                 eax, [ebp - 0x1134]

        $sequence_2 = { 81bdf0fdffff2e6b9338 7735 81bdf0fdffff2e6b9338 0f843a3f0000 81bdf0fdffffa3a57438 0f8444340000 }
            // n = 6, score = 100
            //   81bdf0fdffff2e6b9338     | cmp    dword ptr [ebp - 0x210], 0x38936b2e
            //   7735                 | ja                  0x37
            //   81bdf0fdffff2e6b9338     | cmp    dword ptr [ebp - 0x210], 0x38936b2e
            //   0f843a3f0000         | je                  0x3f40
            //   81bdf0fdffffa3a57438     | cmp    dword ptr [ebp - 0x210], 0x3874a5a3
            //   0f8444340000         | je                  0x344a

        $sequence_3 = { 0f84002c0000 e9???????? 81bdf0fdffff5261f1ea 0f84b9210000 81bdf0fdffff4769f2ea 0f849d140000 }
            // n = 6, score = 100
            //   0f84002c0000         | je                  0x2c06
            //   e9????????           |                     
            //   81bdf0fdffff5261f1ea     | cmp    dword ptr [ebp - 0x210], 0xeaf16152
            //   0f84b9210000         | je                  0x21bf
            //   81bdf0fdffff4769f2ea     | cmp    dword ptr [ebp - 0x210], 0xeaf26947
            //   0f849d140000         | je                  0x14a3

        $sequence_4 = { 81bdf0fdffffd4a90b00 0f846b800000 e9???????? 81bdf0fdffff4daa0b00 0f845e730000 81bdf0fdffff4eaa0b00 }
            // n = 6, score = 100
            //   81bdf0fdffffd4a90b00     | cmp    dword ptr [ebp - 0x210], 0xba9d4
            //   0f846b800000         | je                  0x8071
            //   e9????????           |                     
            //   81bdf0fdffff4daa0b00     | cmp    dword ptr [ebp - 0x210], 0xbaa4d
            //   0f845e730000         | je                  0x7364
            //   81bdf0fdffff4eaa0b00     | cmp    dword ptr [ebp - 0x210], 0xbaa4e

        $sequence_5 = { 8d85ace4ffff 50 6a05 68???????? 8b8dc4e4ffff 51 ff15???????? }
            // n = 7, score = 100
            //   8d85ace4ffff         | lea                 eax, [ebp - 0x1b54]
            //   50                   | push                eax
            //   6a05                 | push                5
            //   68????????           |                     
            //   8b8dc4e4ffff         | mov                 ecx, dword ptr [ebp - 0x1b3c]
            //   51                   | push                ecx
            //   ff15????????         |                     

        $sequence_6 = { e9???????? 81bdf0fdffff46e1d405 7776 81bdf0fdffff46e1d405 0f847b490000 81bdf0fdffffc9e0d405 7735 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   81bdf0fdffff46e1d405     | cmp    dword ptr [ebp - 0x210], 0x5d4e146
            //   7776                 | ja                  0x78
            //   81bdf0fdffff46e1d405     | cmp    dword ptr [ebp - 0x210], 0x5d4e146
            //   0f847b490000         | je                  0x4981
            //   81bdf0fdffffc9e0d405     | cmp    dword ptr [ebp - 0x210], 0x5d4e0c9
            //   7735                 | ja                  0x37

        $sequence_7 = { ebd3 8bc6 c1f805 83e61f 8b048578f64100 c1e606 80643004fd }
            // n = 7, score = 100
            //   ebd3                 | jmp                 0xffffffd5
            //   8bc6                 | mov                 eax, esi
            //   c1f805               | sar                 eax, 5
            //   83e61f               | and                 esi, 0x1f
            //   8b048578f64100       | mov                 eax, dword ptr [eax*4 + 0x41f678]
            //   c1e606               | shl                 esi, 6
            //   80643004fd           | and                 byte ptr [eax + esi + 4], 0xfd

        $sequence_8 = { c7465c907a4100 83660800 33ff 47 897e14 897e70 6a43 }
            // n = 7, score = 100
            //   c7465c907a4100       | mov                 dword ptr [esi + 0x5c], 0x417a90
            //   83660800             | and                 dword ptr [esi + 8], 0
            //   33ff                 | xor                 edi, edi
            //   47                   | inc                 edi
            //   897e14               | mov                 dword ptr [esi + 0x14], edi
            //   897e70               | mov                 dword ptr [esi + 0x70], edi
            //   6a43                 | push                0x43

        $sequence_9 = { ff15???????? 85c0 7507 33c0 e9???????? 8d55fc }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7507                 | jne                 9
            //   33c0                 | xor                 eax, eax
            //   e9????????           |                     
            //   8d55fc               | lea                 edx, [ebp - 4]

    condition:
        7 of them and filesize < 297984
}