rule win_mongall_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.mongall."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mongall"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85ff 7e2a 6a20 4e e8???????? 59 }
            // n = 6, score = 100
            //   85ff                 | test                edi, edi
            //   7e2a                 | jle                 0x2c
            //   6a20                 | push                0x20
            //   4e                   | dec                 esi
            //   e8????????           |                     
            //   59                   | pop                 ecx

        $sequence_1 = { 5e 0fb6c3 5b c9 c3 8bff }
            // n = 6, score = 100
            //   5e                   | pop                 esi
            //   0fb6c3               | movzx               eax, bl
            //   5b                   | pop                 ebx
            //   c9                   | leave               
            //   c3                   | ret                 
            //   8bff                 | mov                 edi, edi

        $sequence_2 = { c785d0fdffff01000000 8bbdc8fdffff 2bbde0fdffff 2bbdd0fdffff a80c }
            // n = 5, score = 100
            //   c785d0fdffff01000000     | mov    dword ptr [ebp - 0x230], 1
            //   8bbdc8fdffff         | mov                 edi, dword ptr [ebp - 0x238]
            //   2bbde0fdffff         | sub                 edi, dword ptr [ebp - 0x220]
            //   2bbdd0fdffff         | sub                 edi, dword ptr [ebp - 0x230]
            //   a80c                 | test                al, 0xc

        $sequence_3 = { 56 ff15???????? 8bd8 53 53 6a00 }
            // n = 6, score = 100
            //   56                   | push                esi
            //   ff15????????         |                     
            //   8bd8                 | mov                 ebx, eax
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   6a00                 | push                0

        $sequence_4 = { 2bc2 8bd0 8bc7 8d5801 8a08 }
            // n = 5, score = 100
            //   2bc2                 | sub                 eax, edx
            //   8bd0                 | mov                 edx, eax
            //   8bc7                 | mov                 eax, edi
            //   8d5801               | lea                 ebx, [eax + 1]
            //   8a08                 | mov                 cl, byte ptr [eax]

        $sequence_5 = { c70694000000 ff15???????? 8b4604 83f804 7519 68???????? 57 }
            // n = 7, score = 100
            //   c70694000000         | mov                 dword ptr [esi], 0x94
            //   ff15????????         |                     
            //   8b4604               | mov                 eax, dword ptr [esi + 4]
            //   83f804               | cmp                 eax, 4
            //   7519                 | jne                 0x1b
            //   68????????           |                     
            //   57                   | push                edi

        $sequence_6 = { 03c9 03c9 d3e7 33c0 8975f8 }
            // n = 5, score = 100
            //   03c9                 | add                 ecx, ecx
            //   03c9                 | add                 ecx, ecx
            //   d3e7                 | shl                 edi, cl
            //   33c0                 | xor                 eax, eax
            //   8975f8               | mov                 dword ptr [ebp - 8], esi

        $sequence_7 = { 57 8d3c40 33c9 b03d 33db 897dfc }
            // n = 6, score = 100
            //   57                   | push                edi
            //   8d3c40               | lea                 edi, [eax + eax*2]
            //   33c9                 | xor                 ecx, ecx
            //   b03d                 | mov                 al, 0x3d
            //   33db                 | xor                 ebx, ebx
            //   897dfc               | mov                 dword ptr [ebp - 4], edi

        $sequence_8 = { 6a00 ff15???????? 8bf0 ff15???????? 3db7000000 7524 }
            // n = 6, score = 100
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   ff15????????         |                     
            //   3db7000000           | cmp                 eax, 0xb7
            //   7524                 | jne                 0x26

        $sequence_9 = { 8975f8 ff15???????? 8b5d08 85db 740a 57 }
            // n = 6, score = 100
            //   8975f8               | mov                 dword ptr [ebp - 8], esi
            //   ff15????????         |                     
            //   8b5d08               | mov                 ebx, dword ptr [ebp + 8]
            //   85db                 | test                ebx, ebx
            //   740a                 | je                  0xc
            //   57                   | push                edi

    condition:
        7 of them and filesize < 199680
}