rule win_montysthree_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.montysthree."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.montysthree"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 8d4d94 e8???????? 8d4df8 e8???????? }
            // n = 5, score = 200
            //   e8????????           |                     
            //   8d4d94               | lea                 ecx, [ebp - 0x6c]
            //   e8????????           |                     
            //   8d4df8               | lea                 ecx, [ebp - 8]
            //   e8????????           |                     

        $sequence_1 = { 85c0 7426 ff7608 ff450c 43 ffd7 }
            // n = 6, score = 200
            //   85c0                 | test                eax, eax
            //   7426                 | je                  0x28
            //   ff7608               | push                dword ptr [esi + 8]
            //   ff450c               | inc                 dword ptr [ebp + 0xc]
            //   43                   | inc                 ebx
            //   ffd7                 | call                edi

        $sequence_2 = { 7407 50 e8???????? 59 8b7c240c 8b4708 }
            // n = 6, score = 200
            //   7407                 | je                  9
            //   50                   | push                eax
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   8b7c240c             | mov                 edi, dword ptr [esp + 0xc]
            //   8b4708               | mov                 eax, dword ptr [edi + 8]

        $sequence_3 = { ff15???????? 8945d8 3bc6 0f8482000000 8d8300080000 8945d4 56 }
            // n = 7, score = 200
            //   ff15????????         |                     
            //   8945d8               | mov                 dword ptr [ebp - 0x28], eax
            //   3bc6                 | cmp                 eax, esi
            //   0f8482000000         | je                  0x88
            //   8d8300080000         | lea                 eax, [ebx + 0x800]
            //   8945d4               | mov                 dword ptr [ebp - 0x2c], eax
            //   56                   | push                esi

        $sequence_4 = { e8???????? 50 e8???????? 8bf8 3bfe 59 59 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   3bfe                 | cmp                 edi, esi
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx

        $sequence_5 = { 50 8d45bc 50 8d45ec 50 8d4dcc }
            // n = 6, score = 200
            //   50                   | push                eax
            //   8d45bc               | lea                 eax, [ebp - 0x44]
            //   50                   | push                eax
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   50                   | push                eax
            //   8d4dcc               | lea                 ecx, [ebp - 0x34]

        $sequence_6 = { 56 57 68???????? e8???????? 59 8d4da8 e8???????? }
            // n = 7, score = 200
            //   56                   | push                esi
            //   57                   | push                edi
            //   68????????           |                     
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   8d4da8               | lea                 ecx, [ebp - 0x58]
            //   e8????????           |                     

        $sequence_7 = { ff750c ff75fc e8???????? 035dec 017dfc }
            // n = 5, score = 200
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   e8????????           |                     
            //   035dec               | add                 ebx, dword ptr [ebp - 0x14]
            //   017dfc               | add                 dword ptr [ebp - 4], edi

        $sequence_8 = { 8b35???????? ffd6 3db7000000 7441 ffd6 8bf0 }
            // n = 6, score = 200
            //   8b35????????         |                     
            //   ffd6                 | call                esi
            //   3db7000000           | cmp                 eax, 0xb7
            //   7441                 | je                  0x43
            //   ffd6                 | call                esi
            //   8bf0                 | mov                 esi, eax

        $sequence_9 = { 53 57 53 6aff 53 8d4de8 }
            // n = 6, score = 200
            //   53                   | push                ebx
            //   57                   | push                edi
            //   53                   | push                ebx
            //   6aff                 | push                -1
            //   53                   | push                ebx
            //   8d4de8               | lea                 ecx, [ebp - 0x18]

    condition:
        7 of them and filesize < 458752
}