rule win_mortalkombat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.mortalkombat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mortalkombat"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bec 83c4a4 c745d030000000 c745d403200000 }
            // n = 4, score = 100
            //   8bec                 | mov                 ebp, esp
            //   83c4a4               | add                 esp, -0x5c
            //   c745d030000000       | mov                 dword ptr [ebp - 0x30], 0x30
            //   c745d403200000       | mov                 dword ptr [ebp - 0x2c], 0x2003

        $sequence_1 = { 68???????? e8???????? 83c710 6a04 57 }
            // n = 5, score = 100
            //   68????????           |                     
            //   e8????????           |                     
            //   83c710               | add                 edi, 0x10
            //   6a04                 | push                4
            //   57                   | push                edi

        $sequence_2 = { e8???????? eb14 6a10 68???????? 68???????? }
            // n = 5, score = 100
            //   e8????????           |                     
            //   eb14                 | jmp                 0x16
            //   6a10                 | push                0x10
            //   68????????           |                     
            //   68????????           |                     

        $sequence_3 = { 0f85a6010000 833d????????00 7506 ff0d???????? 68???????? }
            // n = 5, score = 100
            //   0f85a6010000         | jne                 0x1ac
            //   833d????????00       |                     
            //   7506                 | jne                 8
            //   ff0d????????         |                     
            //   68????????           |                     

        $sequence_4 = { 0fca 890d???????? 8915???????? 8b4808 8b500c 0fc9 }
            // n = 6, score = 100
            //   0fca                 | bswap               edx
            //   890d????????         |                     
            //   8915????????         |                     
            //   8b4808               | mov                 ecx, dword ptr [eax + 8]
            //   8b500c               | mov                 edx, dword ptr [eax + 0xc]
            //   0fc9                 | bswap               ecx

        $sequence_5 = { 4c 006800 0200 0068b9 6640 00684d 214000 }
            // n = 7, score = 100
            //   4c                   | dec                 esp
            //   006800               | add                 byte ptr [eax], ch
            //   0200                 | add                 al, byte ptr [eax]
            //   0068b9               | add                 byte ptr [eax - 0x47], ch
            //   6640                 | inc                 ax
            //   00684d               | add                 byte ptr [eax + 0x4d], ch
            //   214000               | and                 dword ptr [eax], eax

        $sequence_6 = { 8d85e8feffff 50 68???????? e8???????? 85c0 0f8419030000 }
            // n = 6, score = 100
            //   8d85e8feffff         | lea                 eax, [ebp - 0x118]
            //   50                   | push                eax
            //   68????????           |                     
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f8419030000         | je                  0x31f

        $sequence_7 = { ff7508 68???????? e8???????? eb1d 68f5010000 }
            // n = 5, score = 100
            //   ff7508               | push                dword ptr [ebp + 8]
            //   68????????           |                     
            //   e8????????           |                     
            //   eb1d                 | jmp                 0x1f
            //   68f5010000           | push                0x1f5

        $sequence_8 = { 6a01 6800000080 68???????? e8???????? 8945fc }
            // n = 5, score = 100
            //   6a01                 | push                1
            //   6800000080           | push                0x80000000
            //   68????????           |                     
            //   e8????????           |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax

        $sequence_9 = { 6640 00684d 214000 e8???????? }
            // n = 4, score = 100
            //   6640                 | inc                 ax
            //   00684d               | add                 byte ptr [eax + 0x4d], ch
            //   214000               | and                 dword ptr [eax], eax
            //   e8????????           |                     

    condition:
        7 of them and filesize < 1224704
}