rule win_mpkbot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.mpkbot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mpkbot"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 895010 895014 894818 89481c 895020 895024 5d }
            // n = 7, score = 400
            //   895010               | mov                 dword ptr [eax + 0x10], edx
            //   895014               | mov                 dword ptr [eax + 0x14], edx
            //   894818               | mov                 dword ptr [eax + 0x18], ecx
            //   89481c               | mov                 dword ptr [eax + 0x1c], ecx
            //   895020               | mov                 dword ptr [eax + 0x20], edx
            //   895024               | mov                 dword ptr [eax + 0x24], edx
            //   5d                   | pop                 ebp

        $sequence_1 = { 50 683f000f00 6a00 ff750c ff7508 ff15???????? 85c0 }
            // n = 7, score = 400
            //   50                   | push                eax
            //   683f000f00           | push                0xf003f
            //   6a00                 | push                0
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_2 = { 68???????? ff15???????? 68???????? 50 ff15???????? ff750c a3???????? }
            // n = 7, score = 400
            //   68????????           |                     
            //   ff15????????         |                     
            //   68????????           |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   a3????????           |                     

        $sequence_3 = { ffd0 5d c3 68???????? ff15???????? 68???????? }
            // n = 6, score = 400
            //   ffd0                 | call                eax
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   68????????           |                     
            //   ff15????????         |                     
            //   68????????           |                     

        $sequence_4 = { 6689500e 33d2 c70028000000 895010 }
            // n = 4, score = 400
            //   6689500e             | mov                 word ptr [eax + 0xe], dx
            //   33d2                 | xor                 edx, edx
            //   c70028000000         | mov                 dword ptr [eax], 0x28
            //   895010               | mov                 dword ptr [eax + 0x10], edx

        $sequence_5 = { ff7508 ff75fc ff15???????? ff75fc 6a00 }
            // n = 5, score = 400
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   ff15????????         |                     
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   6a00                 | push                0

        $sequence_6 = { 6a18 5a 6689500e 33d2 }
            // n = 4, score = 400
            //   6a18                 | push                0x18
            //   5a                   | pop                 edx
            //   6689500e             | mov                 word ptr [eax + 0xe], dx
            //   33d2                 | xor                 edx, edx

        $sequence_7 = { 56 68???????? 68???????? ffd7 6a00 }
            // n = 5, score = 400
            //   56                   | push                esi
            //   68????????           |                     
            //   68????????           |                     
            //   ffd7                 | call                edi
            //   6a00                 | push                0

        $sequence_8 = { ff750c a3???????? ff7508 ffd0 5d }
            // n = 5, score = 400
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   a3????????           |                     
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ffd0                 | call                eax
            //   5d                   | pop                 ebp

        $sequence_9 = { 8bf0 0fb7450c 50 0fb74508 }
            // n = 4, score = 400
            //   8bf0                 | mov                 esi, eax
            //   0fb7450c             | movzx               eax, word ptr [ebp + 0xc]
            //   50                   | push                eax
            //   0fb74508             | movzx               eax, word ptr [ebp + 8]

    condition:
        7 of them and filesize < 139264
}