rule win_mrac_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.mrac."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mrac"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 2bca d1f9 eb03 83c9ff c745bc00000000 c745cc00000000 c745d007000000 }
            // n = 7, score = 200
            //   2bca                 | sub                 ecx, edx
            //   d1f9                 | sar                 ecx, 1
            //   eb03                 | jmp                 5
            //   83c9ff               | or                  ecx, 0xffffffff
            //   c745bc00000000       | mov                 dword ptr [ebp - 0x44], 0
            //   c745cc00000000       | mov                 dword ptr [ebp - 0x34], 0
            //   c745d007000000       | mov                 dword ptr [ebp - 0x30], 7

        $sequence_1 = { ba01000000 33c9 e8???????? c744243871000000 8bf0 8b4c2438 80f153 }
            // n = 7, score = 200
            //   ba01000000           | mov                 edx, 1
            //   33c9                 | xor                 ecx, ecx
            //   e8????????           |                     
            //   c744243871000000     | mov                 dword ptr [esp + 0x38], 0x71
            //   8bf0                 | mov                 esi, eax
            //   8b4c2438             | mov                 ecx, dword ptr [esp + 0x38]
            //   80f153               | xor                 cl, 0x53

        $sequence_2 = { 8b85e0feffff 85c0 0f849b010000 8b9dccfeffff 8b0f 48 8bd6 }
            // n = 7, score = 200
            //   8b85e0feffff         | mov                 eax, dword ptr [ebp - 0x120]
            //   85c0                 | test                eax, eax
            //   0f849b010000         | je                  0x1a1
            //   8b9dccfeffff         | mov                 ebx, dword ptr [ebp - 0x134]
            //   8b0f                 | mov                 ecx, dword ptr [edi]
            //   48                   | dec                 eax
            //   8bd6                 | mov                 edx, esi

        $sequence_3 = { 88842454030000 e8???????? 3474 8d8c2448030000 6a06 88842455030000 e8???????? }
            // n = 7, score = 200
            //   88842454030000       | mov                 byte ptr [esp + 0x354], al
            //   e8????????           |                     
            //   3474                 | xor                 al, 0x74
            //   8d8c2448030000       | lea                 ecx, [esp + 0x348]
            //   6a06                 | push                6
            //   88842455030000       | mov                 byte ptr [esp + 0x355], al
            //   e8????????           |                     

        $sequence_4 = { e8???????? 3451 8d8c24a00e0000 6a0b 888424b20e0000 e8???????? 344c }
            // n = 7, score = 200
            //   e8????????           |                     
            //   3451                 | xor                 al, 0x51
            //   8d8c24a00e0000       | lea                 ecx, [esp + 0xea0]
            //   6a0b                 | push                0xb
            //   888424b20e0000       | mov                 byte ptr [esp + 0xeb2], al
            //   e8????????           |                     
            //   344c                 | xor                 al, 0x4c

        $sequence_5 = { 6a6f 8884245d010000 e8???????? 0451 8d8c2450010000 6a6f }
            // n = 6, score = 200
            //   6a6f                 | push                0x6f
            //   8884245d010000       | mov                 byte ptr [esp + 0x15d], al
            //   e8????????           |                     
            //   0451                 | add                 al, 0x51
            //   8d8c2450010000       | lea                 ecx, [esp + 0x150]
            //   6a6f                 | push                0x6f

        $sequence_6 = { 3473 88842435140000 8b842420140000 0412 3465 88842436140000 8b842420140000 }
            // n = 7, score = 200
            //   3473                 | xor                 al, 0x73
            //   88842435140000       | mov                 byte ptr [esp + 0x1435], al
            //   8b842420140000       | mov                 eax, dword ptr [esp + 0x1420]
            //   0412                 | add                 al, 0x12
            //   3465                 | xor                 al, 0x65
            //   88842436140000       | mov                 byte ptr [esp + 0x1436], al
            //   8b842420140000       | mov                 eax, dword ptr [esp + 0x1420]

        $sequence_7 = { 8d8c2478100000 6a15 88842494100000 e8???????? 3454 8d8c2478100000 }
            // n = 6, score = 200
            //   8d8c2478100000       | lea                 ecx, [esp + 0x1078]
            //   6a15                 | push                0x15
            //   88842494100000       | mov                 byte ptr [esp + 0x1094], al
            //   e8????????           |                     
            //   3454                 | xor                 al, 0x54
            //   8d8c2478100000       | lea                 ecx, [esp + 0x1078]

        $sequence_8 = { c644242100 e8???????? 83c404 8d4c240c 51 57 ffd0 }
            // n = 7, score = 200
            //   c644242100           | mov                 byte ptr [esp + 0x21], 0
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8d4c240c             | lea                 ecx, [esp + 0xc]
            //   51                   | push                ecx
            //   57                   | push                edi
            //   ffd0                 | call                eax

        $sequence_9 = { 888424fa130000 e8???????? 0420 8d8c24f4130000 6a7d 888424fb130000 e8???????? }
            // n = 7, score = 200
            //   888424fa130000       | mov                 byte ptr [esp + 0x13fa], al
            //   e8????????           |                     
            //   0420                 | add                 al, 0x20
            //   8d8c24f4130000       | lea                 ecx, [esp + 0x13f4]
            //   6a7d                 | push                0x7d
            //   888424fb130000       | mov                 byte ptr [esp + 0x13fb], al
            //   e8????????           |                     

    condition:
        7 of them and filesize < 745472
}