rule win_mrdec_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.mrdec."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mrdec"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 8bf0 8945fc ff7508 56 e8???????? 56 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   ff7508               | push                dword ptr [ebp + 8]
            //   56                   | push                esi
            //   e8????????           |                     
            //   56                   | push                esi

        $sequence_1 = { e8???????? 85c0 7431 c745ec01000000 837d0c01 7509 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7431                 | je                  0x33
            //   c745ec01000000       | mov                 dword ptr [ebp - 0x14], 1
            //   837d0c01             | cmp                 dword ptr [ebp + 0xc], 1
            //   7509                 | jne                 0xb

        $sequence_2 = { e8???????? 83f8ff 7526 8b4508 8bc8 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   83f8ff               | cmp                 eax, -1
            //   7526                 | jne                 0x28
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8bc8                 | mov                 ecx, eax

        $sequence_3 = { e9???????? 8dbdd4fdffff 57 68???????? }
            // n = 4, score = 100
            //   e9????????           |                     
            //   8dbdd4fdffff         | lea                 edi, [ebp - 0x22c]
            //   57                   | push                edi
            //   68????????           |                     

        $sequence_4 = { e8???????? 56 e8???????? c64446fa00 57 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   56                   | push                esi
            //   e8????????           |                     
            //   c64446fa00           | mov                 byte ptr [esi + eax*2 - 6], 0
            //   57                   | push                edi

        $sequence_5 = { 33c0 0fa4d006 d7 aa c1c206 e2f3 4e }
            // n = 7, score = 100
            //   33c0                 | xor                 eax, eax
            //   0fa4d006             | shld                eax, edx, 6
            //   d7                   | xlatb               
            //   aa                   | stosb               byte ptr es:[edi], al
            //   c1c206               | rol                 edx, 6
            //   e2f3                 | loop                0xfffffff5
            //   4e                   | dec                 esi

        $sequence_6 = { 6aff ff75cc 6a00 6a03 e8???????? c605????????2e 8b7ddc }
            // n = 7, score = 100
            //   6aff                 | push                -1
            //   ff75cc               | push                dword ptr [ebp - 0x34]
            //   6a00                 | push                0
            //   6a03                 | push                3
            //   e8????????           |                     
            //   c605????????2e       |                     
            //   8b7ddc               | mov                 edi, dword ptr [ebp - 0x24]

        $sequence_7 = { 6830750000 e8???????? 833d????????00 0f8582000000 6888130000 }
            // n = 5, score = 100
            //   6830750000           | push                0x7530
            //   e8????????           |                     
            //   833d????????00       |                     
            //   0f8582000000         | jne                 0x88
            //   6888130000           | push                0x1388

        $sequence_8 = { 8bec 81c4e4feffff 60 8b4508 8bc8 0520800000 }
            // n = 6, score = 100
            //   8bec                 | mov                 ebp, esp
            //   81c4e4feffff         | add                 esp, 0xfffffee4
            //   60                   | pushal              
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8bc8                 | mov                 ecx, eax
            //   0520800000           | add                 eax, 0x8020

        $sequence_9 = { 6a00 6a02 e8???????? 0bc0 0f8530010000 c745f000400000 }
            // n = 6, score = 100
            //   6a00                 | push                0
            //   6a02                 | push                2
            //   e8????????           |                     
            //   0bc0                 | or                  eax, eax
            //   0f8530010000         | jne                 0x136
            //   c745f000400000       | mov                 dword ptr [ebp - 0x10], 0x4000

    condition:
        7 of them and filesize < 44864
}