rule win_mykings_spreader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2023-12-06"
        version = "1"
        description = "Detects win.mykings_spreader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mykings_spreader"
        malpedia_rule_date = "20231130"
        malpedia_hash = "fc8a0e9f343f6d6ded9e7df1a64dac0cc68d7351"
        malpedia_version = "20230808"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7519 51 55 8bce e8???????? 6a00 6a00 }
            // n = 7, score = 100
            //   7519                 | jne                 0x1b
            //   51                   | push                ecx
            //   55                   | push                ebp
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_1 = { 8b1e ff938c000000 8b0424 8b5014 85d2 7507 bf00000000 }
            // n = 7, score = 100
            //   8b1e                 | mov                 ebx, dword ptr [esi]
            //   ff938c000000         | call                dword ptr [ebx + 0x8c]
            //   8b0424               | mov                 eax, dword ptr [esp]
            //   8b5014               | mov                 edx, dword ptr [eax + 0x14]
            //   85d2                 | test                edx, edx
            //   7507                 | jne                 9
            //   bf00000000           | mov                 edi, 0

        $sequence_2 = { e8???????? 837e1800 7439 8b4620 c1e003 89c7 8b4618 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   837e1800             | cmp                 dword ptr [esi + 0x18], 0
            //   7439                 | je                  0x3b
            //   8b4620               | mov                 eax, dword ptr [esi + 0x20]
            //   c1e003               | shl                 eax, 3
            //   89c7                 | mov                 edi, eax
            //   8b4618               | mov                 eax, dword ptr [esi + 0x18]

        $sequence_3 = { 89c1 c745f401000000 3b4df4 723d ff4df4 8d7600 ff45f4 }
            // n = 7, score = 100
            //   89c1                 | mov                 ecx, eax
            //   c745f401000000       | mov                 dword ptr [ebp - 0xc], 1
            //   3b4df4               | cmp                 ecx, dword ptr [ebp - 0xc]
            //   723d                 | jb                  0x3f
            //   ff4df4               | dec                 dword ptr [ebp - 0xc]
            //   8d7600               | lea                 esi, [esi]
            //   ff45f4               | inc                 dword ptr [ebp - 0xc]

        $sequence_4 = { 68???????? 50 ff15???????? a3???????? 83c0fe 40 40 }
            // n = 7, score = 100
            //   68????????           |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   a3????????           |                     
            //   83c0fe               | add                 eax, -2
            //   40                   | inc                 eax
            //   40                   | inc                 eax

        $sequence_5 = { 8942fc 89d8 c1f81f 8b1424 8b7208 8b4a0c 29de }
            // n = 7, score = 100
            //   8942fc               | mov                 dword ptr [edx - 4], eax
            //   89d8                 | mov                 eax, ebx
            //   c1f81f               | sar                 eax, 0x1f
            //   8b1424               | mov                 edx, dword ptr [esp]
            //   8b7208               | mov                 esi, dword ptr [edx + 8]
            //   8b4a0c               | mov                 ecx, dword ptr [edx + 0xc]
            //   29de                 | sub                 esi, ebx

        $sequence_6 = { eb02 b300 e8???????? 8d45cc e8???????? c745cc00000000 58 }
            // n = 7, score = 100
            //   eb02                 | jmp                 4
            //   b300                 | mov                 bl, 0
            //   e8????????           |                     
            //   8d45cc               | lea                 eax, [ebp - 0x34]
            //   e8????????           |                     
            //   c745cc00000000       | mov                 dword ptr [ebp - 0x34], 0
            //   58                   | pop                 eax

        $sequence_7 = { 33d2 b9???????? 8bc2 8bf2 c1f805 83e61f 8b0485a02e4100 }
            // n = 7, score = 100
            //   33d2                 | xor                 edx, edx
            //   b9????????           |                     
            //   8bc2                 | mov                 eax, edx
            //   8bf2                 | mov                 esi, edx
            //   c1f805               | sar                 eax, 5
            //   83e61f               | and                 esi, 0x1f
            //   8b0485a02e4100       | mov                 eax, dword ptr [eax*4 + 0x412ea0]

        $sequence_8 = { 89d8 29f0 85c0 7e39 8b55f4 85d2 7505 }
            // n = 7, score = 100
            //   89d8                 | mov                 eax, ebx
            //   29f0                 | sub                 eax, esi
            //   85c0                 | test                eax, eax
            //   7e39                 | jle                 0x3b
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   85d2                 | test                edx, edx
            //   7505                 | jne                 7

        $sequence_9 = { 8b7508 8b36 8975c8 8b7d08 8b7f04 }
            // n = 5, score = 100
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   8b36                 | mov                 esi, dword ptr [esi]
            //   8975c8               | mov                 dword ptr [ebp - 0x38], esi
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   8b7f04               | mov                 edi, dword ptr [edi + 4]

    condition:
        7 of them and filesize < 1581056
}