rule win_naikon_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.naikon."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.naikon"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bc6 8088e130011008 40 3dff000000 }
            // n = 4, score = 200
            //   8bc6                 | mov                 eax, esi
            //   8088e130011008       | or                  byte ptr [eax + 0x100130e1], 8
            //   40                   | inc                 eax
            //   3dff000000           | cmp                 eax, 0xff

        $sequence_1 = { 3bc3 7c03 53 eb01 50 8b4dfc 8d043e }
            // n = 7, score = 200
            //   3bc3                 | cmp                 eax, ebx
            //   7c03                 | jl                  5
            //   53                   | push                ebx
            //   eb01                 | jmp                 3
            //   50                   | push                eax
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   8d043e               | lea                 eax, [esi + edi]

        $sequence_2 = { 8d450c 6a03 50 8bce e8???????? 8b06 }
            // n = 6, score = 200
            //   8d450c               | lea                 eax, [ebp + 0xc]
            //   6a03                 | push                3
            //   50                   | push                eax
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   8b06                 | mov                 eax, dword ptr [esi]

        $sequence_3 = { 8bf1 ff742410 e8???????? 85c0 753f 8d4e7c 8d4670 }
            // n = 7, score = 200
            //   8bf1                 | mov                 esi, ecx
            //   ff742410             | push                dword ptr [esp + 0x10]
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   753f                 | jne                 0x41
            //   8d4e7c               | lea                 ecx, [esi + 0x7c]
            //   8d4670               | lea                 eax, [esi + 0x70]

        $sequence_4 = { a1???????? 682c010000 b9???????? 50 8d9500f0ffff }
            // n = 5, score = 200
            //   a1????????           |                     
            //   682c010000           | push                0x12c
            //   b9????????           |                     
            //   50                   | push                eax
            //   8d9500f0ffff         | lea                 edx, [ebp - 0x1000]

        $sequence_5 = { 50 8d85f8feffff 50 ffd7 894508 8b85a8fcffff }
            // n = 6, score = 200
            //   50                   | push                eax
            //   8d85f8feffff         | lea                 eax, [ebp - 0x108]
            //   50                   | push                eax
            //   ffd7                 | call                edi
            //   894508               | mov                 dword ptr [ebp + 8], eax
            //   8b85a8fcffff         | mov                 eax, dword ptr [ebp - 0x358]

        $sequence_6 = { 8bce e8???????? 8b06 8b4e08 57 0fb60c01 }
            // n = 6, score = 200
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   8b4e08               | mov                 ecx, dword ptr [esi + 8]
            //   57                   | push                edi
            //   0fb60c01             | movzx               ecx, byte ptr [ecx + eax]

        $sequence_7 = { 8bd8 ffd7 5f 8bc3 }
            // n = 4, score = 200
            //   8bd8                 | mov                 ebx, eax
            //   ffd7                 | call                edi
            //   5f                   | pop                 edi
            //   8bc3                 | mov                 eax, ebx

        $sequence_8 = { 0fbec3 8a80e8d10010 83e00f eb02 33c0 0fbe84c108d20010 }
            // n = 6, score = 200
            //   0fbec3               | movsx               eax, bl
            //   8a80e8d10010         | mov                 al, byte ptr [eax + 0x1000d1e8]
            //   83e00f               | and                 eax, 0xf
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax
            //   0fbe84c108d20010     | movsx               eax, byte ptr [ecx + eax*8 + 0x1000d208]

        $sequence_9 = { 8b85a8fcffff 83e010 3c10 7503 6a01 5e }
            // n = 6, score = 200
            //   8b85a8fcffff         | mov                 eax, dword ptr [ebp - 0x358]
            //   83e010               | and                 eax, 0x10
            //   3c10                 | cmp                 al, 0x10
            //   7503                 | jne                 5
            //   6a01                 | push                1
            //   5e                   | pop                 esi

    condition:
        7 of them and filesize < 188416
}