rule win_narilam_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2023-12-06"
        version = "1"
        description = "Detects win.narilam."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.narilam"
        malpedia_rule_date = "20231130"
        malpedia_hash = "fc8a0e9f343f6d6ded9e7df1a64dac0cc68d7351"
        malpedia_version = "20230808"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? f645f801 7518 8d55f4 a1???????? e8???????? 8b45f4 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   f645f801             | test                byte ptr [ebp - 8], 1
            //   7518                 | jne                 0x1a
            //   8d55f4               | lea                 edx, [ebp - 0xc]
            //   a1????????           |                     
            //   e8????????           |                     
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]

        $sequence_1 = { 8d8550ffffff ba02000000 e8???????? 66c785dcfeffffe801 ba???????? 8d854cffffff e8???????? }
            // n = 7, score = 100
            //   8d8550ffffff         | lea                 eax, [ebp - 0xb0]
            //   ba02000000           | mov                 edx, 2
            //   e8????????           |                     
            //   66c785dcfeffffe801     | mov    word ptr [ebp - 0x124], 0x1e8
            //   ba????????           |                     
            //   8d854cffffff         | lea                 eax, [ebp - 0xb4]
            //   e8????????           |                     

        $sequence_2 = { e8???????? 8b55fc 8bc6 e8???????? 8bf8 e9???????? 8d5308 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   8bc6                 | mov                 eax, esi
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   e9????????           |                     
            //   8d5308               | lea                 edx, [ebx + 8]

        $sequence_3 = { eb83 e9???????? 66b86801 ebf5 66b86901 ebef 66b86a01 }
            // n = 7, score = 100
            //   eb83                 | jmp                 0xffffff85
            //   e9????????           |                     
            //   66b86801             | mov                 ax, 0x168
            //   ebf5                 | jmp                 0xfffffff7
            //   66b86901             | mov                 ax, 0x169
            //   ebef                 | jmp                 0xfffffff1
            //   66b86a01             | mov                 ax, 0x16a

        $sequence_4 = { e8???????? eb08 8b45fc e8???????? 33c0 5a 59 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   eb08                 | jmp                 0xa
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   5a                   | pop                 edx
            //   59                   | pop                 ecx

        $sequence_5 = { e8???????? c3 3a90e2020000 740b 8890e2020000 e8???????? c3 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   c3                   | ret                 
            //   3a90e2020000         | cmp                 dl, byte ptr [eax + 0x2e2]
            //   740b                 | je                  0xd
            //   8890e2020000         | mov                 byte ptr [eax + 0x2e2], dl
            //   e8????????           |                     
            //   c3                   | ret                 

        $sequence_6 = { e8???????? 8bc8 8bd3 8b831c020000 ff9318020000 33c0 8a45ff }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8bc8                 | mov                 ecx, eax
            //   8bd3                 | mov                 edx, ebx
            //   8b831c020000         | mov                 eax, dword ptr [ebx + 0x21c]
            //   ff9318020000         | call                dword ptr [ebx + 0x218]
            //   33c0                 | xor                 eax, eax
            //   8a45ff               | mov                 al, byte ptr [ebp - 1]

        $sequence_7 = { a5 a5 a5 8d4584 8d4dd4 ba04000000 e8???????? }
            // n = 7, score = 100
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]
            //   8d4584               | lea                 eax, [ebp - 0x7c]
            //   8d4dd4               | lea                 ecx, [ebp - 0x2c]
            //   ba04000000           | mov                 edx, 4
            //   e8????????           |                     

        $sequence_8 = { ff852cffffff 8d5588 8d45fc e8???????? ff8d2cffffff 8d4588 ba02000000 }
            // n = 7, score = 100
            //   ff852cffffff         | inc                 dword ptr [ebp - 0xd4]
            //   8d5588               | lea                 edx, [ebp - 0x78]
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   e8????????           |                     
            //   ff8d2cffffff         | dec                 dword ptr [ebp - 0xd4]
            //   8d4588               | lea                 eax, [ebp - 0x78]
            //   ba02000000           | mov                 edx, 2

        $sequence_9 = { 8d8580feffff e8???????? ff854cfeffff 8d9580feffff 8d45fc e8???????? ff8d4cfeffff }
            // n = 7, score = 100
            //   8d8580feffff         | lea                 eax, [ebp - 0x180]
            //   e8????????           |                     
            //   ff854cfeffff         | inc                 dword ptr [ebp - 0x1b4]
            //   8d9580feffff         | lea                 edx, [ebp - 0x180]
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   e8????????           |                     
            //   ff8d4cfeffff         | dec                 dword ptr [ebp - 0x1b4]

    condition:
        7 of them and filesize < 3325952
}