rule win_navrat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.navrat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.navrat"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d48d0 80f909 7707 0fbec0 83c004 c3 }
            // n = 6, score = 300
            //   8d48d0               | lea                 ecx, [eax - 0x30]
            //   80f909               | cmp                 cl, 9
            //   7707                 | ja                  9
            //   0fbec0               | movsx               eax, al
            //   83c004               | add                 eax, 4
            //   c3                   | ret                 

        $sequence_1 = { 85f6 7407 8b7608 83461c02 5f }
            // n = 5, score = 300
            //   85f6                 | test                esi, esi
            //   7407                 | je                  9
            //   8b7608               | mov                 esi, dword ptr [esi + 8]
            //   83461c02             | add                 dword ptr [esi + 0x1c], 2
            //   5f                   | pop                 edi

        $sequence_2 = { 56 68???????? 50 8d85f0feffff 8bf1 }
            // n = 5, score = 300
            //   56                   | push                esi
            //   68????????           |                     
            //   50                   | push                eax
            //   8d85f0feffff         | lea                 eax, [ebp - 0x110]
            //   8bf1                 | mov                 esi, ecx

        $sequence_3 = { 1bf6 f7de 56 68???????? }
            // n = 4, score = 300
            //   1bf6                 | sbb                 esi, esi
            //   f7de                 | neg                 esi
            //   56                   | push                esi
            //   68????????           |                     

        $sequence_4 = { c745d477617265 c745d85c4d6963 c745dc726f736f c745e066745c57 c745e4696e646f }
            // n = 5, score = 300
            //   c745d477617265       | mov                 dword ptr [ebp - 0x2c], 0x65726177
            //   c745d85c4d6963       | mov                 dword ptr [ebp - 0x28], 0x63694d5c
            //   c745dc726f736f       | mov                 dword ptr [ebp - 0x24], 0x6f736f72
            //   c745e066745c57       | mov                 dword ptr [ebp - 0x20], 0x575c7466
            //   c745e4696e646f       | mov                 dword ptr [ebp - 0x1c], 0x6f646e69

        $sequence_5 = { c647033d 85f6 7407 8b7608 }
            // n = 4, score = 300
            //   c647033d             | mov                 byte ptr [edi + 3], 0x3d
            //   85f6                 | test                esi, esi
            //   7407                 | je                  9
            //   8b7608               | mov                 esi, dword ptr [esi + 8]

        $sequence_6 = { c745dc726f736f c745e066745c57 c745e4696e646f c745e877735c43 c745ec75727265 c745f06e745665 }
            // n = 6, score = 300
            //   c745dc726f736f       | mov                 dword ptr [ebp - 0x24], 0x6f736f72
            //   c745e066745c57       | mov                 dword ptr [ebp - 0x20], 0x575c7466
            //   c745e4696e646f       | mov                 dword ptr [ebp - 0x1c], 0x6f646e69
            //   c745e877735c43       | mov                 dword ptr [ebp - 0x18], 0x435c7377
            //   c745ec75727265       | mov                 dword ptr [ebp - 0x14], 0x65727275
            //   c745f06e745665       | mov                 dword ptr [ebp - 0x10], 0x6556746e

        $sequence_7 = { 0fbec0 83c004 c3 3c2b 7503 }
            // n = 5, score = 300
            //   0fbec0               | movsx               eax, al
            //   83c004               | add                 eax, 4
            //   c3                   | ret                 
            //   3c2b                 | cmp                 al, 0x2b
            //   7503                 | jne                 5

        $sequence_8 = { 83e847 c3 8d48d0 80f909 7707 0fbec0 }
            // n = 6, score = 300
            //   83e847               | sub                 eax, 0x47
            //   c3                   | ret                 
            //   8d48d0               | lea                 ecx, [eax - 0x30]
            //   80f909               | cmp                 cl, 9
            //   7707                 | ja                  9
            //   0fbec0               | movsx               eax, al

        $sequence_9 = { 8d48bf 80f919 7707 0fbec0 83e841 c3 }
            // n = 6, score = 300
            //   8d48bf               | lea                 ecx, [eax - 0x41]
            //   80f919               | cmp                 cl, 0x19
            //   7707                 | ja                  9
            //   0fbec0               | movsx               eax, al
            //   83e841               | sub                 eax, 0x41
            //   c3                   | ret                 

    condition:
        7 of them and filesize < 352256
}