rule win_netc_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.netc"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { b868000000 48 89442440 e8???????? 85c0 7477 48 }
            // n = 7, score = 100
            //   b868000000           | mov                 eax, 0x68
            //   48                   | dec                 eax
            //   89442440             | mov                 dword ptr [esp + 0x40], eax
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7477                 | je                  0x79
            //   48                   | dec                 eax

        $sequence_1 = { e8???????? 83c040 50 68???????? e8???????? 68???????? 56 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c040               | add                 eax, 0x40
            //   50                   | push                eax
            //   68????????           |                     
            //   e8????????           |                     
            //   68????????           |                     
            //   56                   | push                esi

        $sequence_2 = { ff15???????? 8125????????ff3f0000 48 63eb be04000000 48 }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   8125????????ff3f0000     |     
            //   48                   | dec                 eax
            //   63eb                 | arpl                bx, bp
            //   be04000000           | mov                 esi, 4
            //   48                   | dec                 eax

        $sequence_3 = { 3bbc2414010000 7cd4 eb34 68???????? ffd3 68ff000000 8d442418 }
            // n = 7, score = 100
            //   3bbc2414010000       | cmp                 edi, dword ptr [esp + 0x114]
            //   7cd4                 | jl                  0xffffffd6
            //   eb34                 | jmp                 0x36
            //   68????????           |                     
            //   ffd3                 | call                ebx
            //   68ff000000           | push                0xff
            //   8d442418             | lea                 eax, [esp + 0x18]

        $sequence_4 = { 43 40 8955fc 85d2 74de 4b eb03 }
            // n = 7, score = 100
            //   43                   | inc                 ebx
            //   40                   | inc                 eax
            //   8955fc               | mov                 dword ptr [ebp - 4], edx
            //   85d2                 | test                edx, edx
            //   74de                 | je                  0xffffffe0
            //   4b                   | dec                 ebx
            //   eb03                 | jmp                 5

        $sequence_5 = { 42 83c00c 89542434 89442424 3b11 7282 eb04 }
            // n = 7, score = 100
            //   42                   | inc                 edx
            //   83c00c               | add                 eax, 0xc
            //   89542434             | mov                 dword ptr [esp + 0x34], edx
            //   89442424             | mov                 dword ptr [esp + 0x24], eax
            //   3b11                 | cmp                 edx, dword ptr [ecx]
            //   7282                 | jb                  0xffffff84
            //   eb04                 | jmp                 6

        $sequence_6 = { 57 68???????? e8???????? 83c040 50 e8???????? 8b442420 }
            // n = 7, score = 100
            //   57                   | push                edi
            //   68????????           |                     
            //   e8????????           |                     
            //   83c040               | add                 eax, 0x40
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b442420             | mov                 eax, dword ptr [esp + 0x20]

        $sequence_7 = { 83c002 6685c9 75f1 803d????????00 0f849f000000 8b2d???????? 6a00 }
            // n = 7, score = 100
            //   83c002               | add                 eax, 2
            //   6685c9               | test                cx, cx
            //   75f1                 | jne                 0xfffffff3
            //   803d????????00       |                     
            //   0f849f000000         | je                  0xa5
            //   8b2d????????         |                     
            //   6a00                 | push                0

        $sequence_8 = { 8a80f4ba4200 08443b1d 0fb64601 47 3bf8 76ea 8b7d08 }
            // n = 7, score = 100
            //   8a80f4ba4200         | mov                 al, byte ptr [eax + 0x42baf4]
            //   08443b1d             | or                  byte ptr [ebx + edi + 0x1d], al
            //   0fb64601             | movzx               eax, byte ptr [esi + 1]
            //   47                   | inc                 edi
            //   3bf8                 | cmp                 edi, eax
            //   76ea                 | jbe                 0xffffffec
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]

        $sequence_9 = { 48 83ec28 48 8d0dd1760000 ff15???????? 33c0 48 }
            // n = 7, score = 100
            //   48                   | dec                 eax
            //   83ec28               | sub                 esp, 0x28
            //   48                   | dec                 eax
            //   8d0dd1760000         | lea                 ecx, [0x76d1]
            //   ff15????????         |                     
            //   33c0                 | xor                 eax, eax
            //   48                   | dec                 eax

    condition:
        7 of them and filesize < 5047296
}