rule win_netrepser_keylogger_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.netrepser_keylogger."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.netrepser_keylogger"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c645f368 c645f472 c645f565 c645f661 c645f764 c645f849 }
            // n = 6, score = 200
            //   c645f368             | mov                 byte ptr [ebp - 0xd], 0x68
            //   c645f472             | mov                 byte ptr [ebp - 0xc], 0x72
            //   c645f565             | mov                 byte ptr [ebp - 0xb], 0x65
            //   c645f661             | mov                 byte ptr [ebp - 0xa], 0x61
            //   c645f764             | mov                 byte ptr [ebp - 9], 0x64
            //   c645f849             | mov                 byte ptr [ebp - 8], 0x49

        $sequence_1 = { c645d259 c645d350 c645d454 c645d533 c645d632 c645d72e }
            // n = 6, score = 200
            //   c645d259             | mov                 byte ptr [ebp - 0x2e], 0x59
            //   c645d350             | mov                 byte ptr [ebp - 0x2d], 0x50
            //   c645d454             | mov                 byte ptr [ebp - 0x2c], 0x54
            //   c645d533             | mov                 byte ptr [ebp - 0x2b], 0x33
            //   c645d632             | mov                 byte ptr [ebp - 0x2a], 0x32
            //   c645d72e             | mov                 byte ptr [ebp - 0x29], 0x2e

        $sequence_2 = { 52 8d85f0faffff 50 ff15???????? 50 8d8df0faffff 51 }
            // n = 7, score = 200
            //   52                   | push                edx
            //   8d85f0faffff         | lea                 eax, [ebp - 0x510]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   50                   | push                eax
            //   8d8df0faffff         | lea                 ecx, [ebp - 0x510]
            //   51                   | push                ecx

        $sequence_3 = { 83c404 8b95e4feffff 8955f8 e9???????? 33c0 }
            // n = 5, score = 200
            //   83c404               | add                 esp, 4
            //   8b95e4feffff         | mov                 edx, dword ptr [ebp - 0x11c]
            //   8955f8               | mov                 dword ptr [ebp - 8], edx
            //   e9????????           |                     
            //   33c0                 | xor                 eax, eax

        $sequence_4 = { 0f8537010000 8b55f0 8d441202 50 }
            // n = 4, score = 200
            //   0f8537010000         | jne                 0x13d
            //   8b55f0               | mov                 edx, dword ptr [ebp - 0x10]
            //   8d441202             | lea                 eax, [edx + edx + 2]
            //   50                   | push                eax

        $sequence_5 = { 884df7 0fb655f7 85d2 7507 b801000000 eb5f 0fb645f7 }
            // n = 7, score = 200
            //   884df7               | mov                 byte ptr [ebp - 9], cl
            //   0fb655f7             | movzx               edx, byte ptr [ebp - 9]
            //   85d2                 | test                edx, edx
            //   7507                 | jne                 9
            //   b801000000           | mov                 eax, 1
            //   eb5f                 | jmp                 0x61
            //   0fb645f7             | movzx               eax, byte ptr [ebp - 9]

        $sequence_6 = { a1???????? 8985f4feffff 8b0d???????? 898df8feffff eb04 }
            // n = 5, score = 200
            //   a1????????           |                     
            //   8985f4feffff         | mov                 dword ptr [ebp - 0x10c], eax
            //   8b0d????????         |                     
            //   898df8feffff         | mov                 dword ptr [ebp - 0x108], ecx
            //   eb04                 | jmp                 6

        $sequence_7 = { c7410800000000 8b5518 c70200000000 8b4518 }
            // n = 4, score = 200
            //   c7410800000000       | mov                 dword ptr [ecx + 8], 0
            //   8b5518               | mov                 edx, dword ptr [ebp + 0x18]
            //   c70200000000         | mov                 dword ptr [edx], 0
            //   8b4518               | mov                 eax, dword ptr [ebp + 0x18]

        $sequence_8 = { 50 e8???????? 33db 83c404 33c9 }
            // n = 5, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   33db                 | xor                 ebx, ebx
            //   83c404               | add                 esp, 4
            //   33c9                 | xor                 ecx, ecx

        $sequence_9 = { 83ec44 a1???????? 33c4 89442440 a1???????? 85c0 753f }
            // n = 7, score = 100
            //   83ec44               | sub                 esp, 0x44
            //   a1????????           |                     
            //   33c4                 | xor                 eax, esp
            //   89442440             | mov                 dword ptr [esp + 0x40], eax
            //   a1????????           |                     
            //   85c0                 | test                eax, eax
            //   753f                 | jne                 0x41

        $sequence_10 = { 6a04 8d542424 52 8d461c }
            // n = 4, score = 100
            //   6a04                 | push                4
            //   8d542424             | lea                 edx, [esp + 0x24]
            //   52                   | push                edx
            //   8d461c               | lea                 eax, [esi + 0x1c]

        $sequence_11 = { 8b8c241c010000 83c414 5e 33cc }
            // n = 4, score = 100
            //   8b8c241c010000       | mov                 ecx, dword ptr [esp + 0x11c]
            //   83c414               | add                 esp, 0x14
            //   5e                   | pop                 esi
            //   33cc                 | xor                 ecx, esp

        $sequence_12 = { 8b551c 3b5518 741e ff15???????? }
            // n = 4, score = 100
            //   8b551c               | mov                 edx, dword ptr [ebp + 0x1c]
            //   3b5518               | cmp                 edx, dword ptr [ebp + 0x18]
            //   741e                 | je                  0x20
            //   ff15????????         |                     

        $sequence_13 = { c6461eff c6461fd0 b820000000 5b 83c40c c3 }
            // n = 6, score = 100
            //   c6461eff             | mov                 byte ptr [esi + 0x1e], 0xff
            //   c6461fd0             | mov                 byte ptr [esi + 0x1f], 0xd0
            //   b820000000           | mov                 eax, 0x20
            //   5b                   | pop                 ebx
            //   83c40c               | add                 esp, 0xc
            //   c3                   | ret                 

        $sequence_14 = { 8d442404 50 6a00 ff15???????? 8d0c24 51 ff15???????? }
            // n = 7, score = 100
            //   8d442404             | lea                 eax, [esp + 4]
            //   50                   | push                eax
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   8d0c24               | lea                 ecx, [esp]
            //   51                   | push                ecx
            //   ff15????????         |                     

        $sequence_15 = { 50 83ec2c a1???????? 3145f8 33c5 894560 53 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   83ec2c               | sub                 esp, 0x2c
            //   a1????????           |                     
            //   3145f8               | xor                 dword ptr [ebp - 8], eax
            //   33c5                 | xor                 eax, ebp
            //   894560               | mov                 dword ptr [ebp + 0x60], eax
            //   53                   | push                ebx

    condition:
        7 of them and filesize < 303104
}