rule win_neutrino_pos_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.neutrino_pos."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.neutrino_pos"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 5b 6a72 66895d82 5b 6a73 66895d84 8bd8 }
            // n = 7, score = 200
            //   5b                   | pop                 ebx
            //   6a72                 | push                0x72
            //   66895d82             | mov                 word ptr [ebp - 0x7e], bx
            //   5b                   | pop                 ebx
            //   6a73                 | push                0x73
            //   66895d84             | mov                 word ptr [ebp - 0x7c], bx
            //   8bd8                 | mov                 ebx, eax

        $sequence_1 = { 6a69 6689bd74ffffff 5f 6a63 8bdf 66899d76ffffff }
            // n = 6, score = 200
            //   6a69                 | push                0x69
            //   6689bd74ffffff       | mov                 word ptr [ebp - 0x8c], di
            //   5f                   | pop                 edi
            //   6a63                 | push                0x63
            //   8bdf                 | mov                 ebx, edi
            //   66899d76ffffff       | mov                 word ptr [ebp - 0x8a], bx

        $sequence_2 = { ff7508 ffd0 85c0 7523 6840bbd2e3 53 e8???????? }
            // n = 7, score = 200
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ffd0                 | call                eax
            //   85c0                 | test                eax, eax
            //   7523                 | jne                 0x25
            //   6840bbd2e3           | push                0xe3d2bb40
            //   53                   | push                ebx
            //   e8????????           |                     

        $sequence_3 = { 66898564ffffff 58 6a65 66898566ffffff }
            // n = 4, score = 200
            //   66898564ffffff       | mov                 word ptr [ebp - 0x9c], ax
            //   58                   | pop                 eax
            //   6a65                 | push                0x65
            //   66898566ffffff       | mov                 word ptr [ebp - 0x9a], ax

        $sequence_4 = { 6689855cffffff 6689855effffff 58 6a64 66898560ffffff 58 6a73 }
            // n = 7, score = 200
            //   6689855cffffff       | mov                 word ptr [ebp - 0xa4], ax
            //   6689855effffff       | mov                 word ptr [ebp - 0xa2], ax
            //   58                   | pop                 eax
            //   6a64                 | push                0x64
            //   66898560ffffff       | mov                 word ptr [ebp - 0xa0], ax
            //   58                   | pop                 eax
            //   6a73                 | push                0x73

        $sequence_5 = { 83f84d 7707 ebe5 83f84d 760b 83f85a 7706 }
            // n = 7, score = 200
            //   83f84d               | cmp                 eax, 0x4d
            //   7707                 | ja                  9
            //   ebe5                 | jmp                 0xffffffe7
            //   83f84d               | cmp                 eax, 0x4d
            //   760b                 | jbe                 0xd
            //   83f85a               | cmp                 eax, 0x5a
            //   7706                 | ja                  8

        $sequence_6 = { 8d4df8 51 6a08 56 ffd0 85c0 0f84b7000000 }
            // n = 7, score = 200
            //   8d4df8               | lea                 ecx, [ebp - 8]
            //   51                   | push                ecx
            //   6a08                 | push                8
            //   56                   | push                esi
            //   ffd0                 | call                eax
            //   85c0                 | test                eax, eax
            //   0f84b7000000         | je                  0xbd

        $sequence_7 = { 56 ffd0 837dfc00 5e 0f95c0 c9 c3 }
            // n = 7, score = 200
            //   56                   | push                esi
            //   ffd0                 | call                eax
            //   837dfc00             | cmp                 dword ptr [ebp - 4], 0
            //   5e                   | pop                 esi
            //   0f95c0               | setne               al
            //   c9                   | leave               
            //   c3                   | ret                 

        $sequence_8 = { 6881874190 6a01 e8???????? 59 59 ff7508 ffd0 }
            // n = 7, score = 200
            //   6881874190           | push                0x90418781
            //   6a01                 | push                1
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ffd0                 | call                eax

        $sequence_9 = { 6a72 668945a0 58 6a07 668945a2 58 66894d9a }
            // n = 7, score = 200
            //   6a72                 | push                0x72
            //   668945a0             | mov                 word ptr [ebp - 0x60], ax
            //   58                   | pop                 eax
            //   6a07                 | push                7
            //   668945a2             | mov                 word ptr [ebp - 0x5e], ax
            //   58                   | pop                 eax
            //   66894d9a             | mov                 word ptr [ebp - 0x66], cx

    condition:
        7 of them and filesize < 188416
}