rule win_newcore_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.newcore_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.newcore_rat"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0f841b010000 8b4c2418 03c8 03f8 2bd8 3b4c241c }
            // n = 6, score = 100
            //   0f841b010000         | je                  0x121
            //   8b4c2418             | mov                 ecx, dword ptr [esp + 0x18]
            //   03c8                 | add                 ecx, eax
            //   03f8                 | add                 edi, eax
            //   2bd8                 | sub                 ebx, eax
            //   3b4c241c             | cmp                 ecx, dword ptr [esp + 0x1c]

        $sequence_1 = { 85c0 7534 8d442414 50 8d4c241c e8???????? }
            // n = 6, score = 100
            //   85c0                 | test                eax, eax
            //   7534                 | jne                 0x36
            //   8d442414             | lea                 eax, [esp + 0x14]
            //   50                   | push                eax
            //   8d4c241c             | lea                 ecx, [esp + 0x1c]
            //   e8????????           |                     

        $sequence_2 = { e8???????? 83c414 ebc9 8bc8 c1f905 8d1c8dc0cd0310 8bf0 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   ebc9                 | jmp                 0xffffffcb
            //   8bc8                 | mov                 ecx, eax
            //   c1f905               | sar                 ecx, 5
            //   8d1c8dc0cd0310       | lea                 ebx, [ecx*4 + 0x1003cdc0]
            //   8bf0                 | mov                 esi, eax

        $sequence_3 = { 68???????? 8d96f6010000 e8???????? 8b442434 8b4c2438 }
            // n = 5, score = 100
            //   68????????           |                     
            //   8d96f6010000         | lea                 edx, [esi + 0x1f6]
            //   e8????????           |                     
            //   8b442434             | mov                 eax, dword ptr [esp + 0x34]
            //   8b4c2438             | mov                 ecx, dword ptr [esp + 0x38]

        $sequence_4 = { 8d54242c 52 8d4c2418 8984245c020000 e8???????? 8d44242c }
            // n = 6, score = 100
            //   8d54242c             | lea                 edx, [esp + 0x2c]
            //   52                   | push                edx
            //   8d4c2418             | lea                 ecx, [esp + 0x18]
            //   8984245c020000       | mov                 dword ptr [esp + 0x25c], eax
            //   e8????????           |                     
            //   8d44242c             | lea                 eax, [esp + 0x2c]

        $sequence_5 = { 5d 5b c3 8b8e58300000 03c0 03c0 898678300000 }
            // n = 7, score = 100
            //   5d                   | pop                 ebp
            //   5b                   | pop                 ebx
            //   c3                   | ret                 
            //   8b8e58300000         | mov                 ecx, dword ptr [esi + 0x3058]
            //   03c0                 | add                 eax, eax
            //   03c0                 | add                 eax, eax
            //   898678300000         | mov                 dword ptr [esi + 0x3078], eax

        $sequence_6 = { 80c130 83e20f 884804 8bca 83f909 7e05 }
            // n = 6, score = 100
            //   80c130               | add                 cl, 0x30
            //   83e20f               | and                 edx, 0xf
            //   884804               | mov                 byte ptr [eax + 4], cl
            //   8bca                 | mov                 ecx, edx
            //   83f909               | cmp                 ecx, 9
            //   7e05                 | jle                 7

        $sequence_7 = { 8984245c020000 e8???????? 8d44242c 50 8d742444 e8???????? 8b00 }
            // n = 7, score = 100
            //   8984245c020000       | mov                 dword ptr [esp + 0x25c], eax
            //   e8????????           |                     
            //   8d44242c             | lea                 eax, [esp + 0x2c]
            //   50                   | push                eax
            //   8d742444             | lea                 esi, [esp + 0x44]
            //   e8????????           |                     
            //   8b00                 | mov                 eax, dword ptr [eax]

        $sequence_8 = { ff15???????? 57 8bf0 53 56 ff15???????? 56 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   57                   | push                edi
            //   8bf0                 | mov                 esi, eax
            //   53                   | push                ebx
            //   56                   | push                esi
            //   ff15????????         |                     
            //   56                   | push                esi

        $sequence_9 = { 8bb42450020000 8bd8 8b442418 50 6a32 8d7b34 b904010000 }
            // n = 7, score = 100
            //   8bb42450020000       | mov                 esi, dword ptr [esp + 0x250]
            //   8bd8                 | mov                 ebx, eax
            //   8b442418             | mov                 eax, dword ptr [esp + 0x18]
            //   50                   | push                eax
            //   6a32                 | push                0x32
            //   8d7b34               | lea                 edi, [ebx + 0x34]
            //   b904010000           | mov                 ecx, 0x104

    condition:
        7 of them and filesize < 581632
}