rule win_nighthawk_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.nighthawk."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nighthawk"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7405 e8???????? 4c8965b8 48c745c00f000000 448865a8 488d0d83250c00 ff15???????? }
            // n = 7, score = 100
            //   7405                 | dec                 eax
            //   e8????????           |                     
            //   4c8965b8             | lea                 ecx, [esp + 0xd8]
            //   48c745c00f000000     | nop                 
            //   448865a8             | dec                 eax
            //   488d0d83250c00       | lea                 ecx, [esp + 0x90]
            //   ff15????????         |                     

        $sequence_1 = { 8b442430 39442470 731f 488d8c24f8000000 e8???????? 8b4c2470 488b542450 }
            // n = 7, score = 100
            //   8b442430             | jbe                 0x86e
            //   39442470             | cmp                 eax, -5
            //   731f                 | jne                 0x995
            //   488d8c24f8000000     | mov                 edx, dword ptr [ebp - 0x61]
            //   e8????????           |                     
            //   8b4c2470             | dec                 eax
            //   488b542450           | lea                 ecx, [ebp - 0x79]

        $sequence_2 = { 488bf0 4c897560 4c89742470 4489742478 4c89742450 4c89742460 458d660f }
            // n = 7, score = 100
            //   488bf0               | lea                 ecx, [ebp - 0x68]
            //   4c897560             | dec                 eax
            //   4c89742470           | lea                 edx, [ebp - 0x68]
            //   4489742478           | dec                 eax
            //   4c89742450           | lea                 ecx, [ebp + 0x2f0]
            //   4c89742460           | inc                 ecx
            //   458d660f             | mov                 eax, 0x1e

        $sequence_3 = { 4c8d85a0000000 8d53a2 488b4008 ff15???????? 85c0 0f844a040000 448b4510 }
            // n = 7, score = 100
            //   4c8d85a0000000       | dec                 esp
            //   8d53a2               | lea                 ebx, [esp + 0x40]
            //   488b4008             | dec                 eax
            //   ff15????????         |                     
            //   85c0                 | mov                 ecx, dword ptr [ebx]
            //   0f844a040000         | dec                 ecx
            //   448b4510             | mov                 edx, esi

        $sequence_4 = { 57 4883ec30 488bd9 0f57c0 8b490c 488bfa 0f11442420 }
            // n = 7, score = 100
            //   57                   | mov                 ecx, dword ptr [ebp + 0x18]
            //   4883ec30             | dec                 eax
            //   488bd9               | test                ecx, ecx
            //   0f57c0               | je                  0x7d7
            //   8b490c               | mov                 eax, dword ptr [ebp + 0x10]
            //   488bfa               | mov                 dword ptr [ebx + 0xa8], eax
            //   0f11442420           | test                eax, eax

        $sequence_5 = { 83e00f 2bc2 4898 488b8c2448010000 0fb60401 8b8c24d4000000 03c8 }
            // n = 7, score = 100
            //   83e00f               | dec                 eax
            //   2bc2                 | lea                 ecx, [ebp + 0x30]
            //   4898                 | dec                 eax
            //   488b8c2448010000     | lea                 edx, [ebp + 0x30]
            //   0fb60401             | dec                 eax
            //   8b8c24d4000000       | lea                 ecx, [ebp + 0x2b0]
            //   03c8                 | dec                 eax

        $sequence_6 = { 4885c0 488bf8 742e 4c8bc3 498bd6 488bc8 e8???????? }
            // n = 7, score = 100
            //   4885c0               | jb                  0xc20
            //   488bf8               | dec                 eax
            //   742e                 | mov                 eax, dword ptr [eax]
            //   4c8bc3               | dec                 ecx
            //   498bd6               | or                  edi, 0xffffffff
            //   488bc8               | dec                 eax
            //   e8????????           |                     

        $sequence_7 = { 740a 4c8b7920 4c037918 eb03 4c8bfe 4c89bd20010000 e9???????? }
            // n = 7, score = 100
            //   740a                 | mov                 ecx, edi
            //   4c8b7920             | dec                 eax
            //   4c037918             | mov                 ecx, edi
            //   eb03                 | mov                 edx, 0x50
            //   4c8bfe               | dec                 eax
            //   4c89bd20010000       | mov                 ecx, dword ptr [edi]
            //   e9????????           |                     

        $sequence_8 = { 83ea01 7407 83fa01 752c eb11 48833d????????00 488d05e70a0300 }
            // n = 7, score = 100
            //   83ea01               | dec                 eax
            //   7407                 | lea                 ecx, [ebp + 0x3c0]
            //   83fa01               | dec                 eax
            //   752c                 | mov                 dword ptr [ebp + 0x1e0], esi
            //   eb11                 | dec                 eax
            //   48833d????????00     |                     
            //   488d05e70a0300       | lea                 edx, [0x7f36c]

        $sequence_9 = { 755b 488365df00 488365ef00 48c745f70f000000 458d4610 488d1577010600 }
            // n = 6, score = 100
            //   755b                 | inc                 eax
            //   488365df00           | inc                 si
            //   488365ef00           | cmp                 dword ptr [eax + eax*2], esp
            //   48c745f70f000000     | dec                 eax
            //   458d4610             | mov                 ecx, ebx
            //   488d1577010600       | dec                 eax

    condition:
        7 of them and filesize < 1949696
}