rule win_nimplant_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.nimplant."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nimplant"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 53 4883ec30 4889cb 4885c9 7417 488b01 6683781201 }
            // n = 7, score = 100
            //   53                   | cmp                 esi, 0xc
            //   4883ec30             | jg                  0xe31
            //   4889cb               | je                  0xacc
            //   4885c9               | dec                 ecx
            //   7417                 | add                 esi, 0xc
            //   488b01               | jo                  0x1049
            //   6683781201           | dec                 ebp

        $sequence_1 = { c644020800 4889842480000000 488b442440 803800 0f85e0faffff ba01000000 4c89f9 }
            // n = 7, score = 100
            //   c644020800           | mov                 edx, 0xc
            //   4889842480000000     | dec                 esp
            //   488b442440           | lea                 eax, [0x4f4b4]
            //   803800               | mov                 edx, 6
            //   0f85e0faffff         | dec                 esp
            //   ba01000000           | lea                 eax, [0x4f4b3]
            //   4c89f9               | mov                 edx, 0xa

        $sequence_2 = { e8???????? 803b00 0f842cceffff 0f1f8000000000 488b842428020000 48898424b0010000 48c744243000000000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   803b00               | mov                 edx, esp
            //   0f842cceffff         | dec                 eax
            //   0f1f8000000000       | mov                 ecx, ebx
            //   488b842428020000     | cmp                 byte ptr [eax], 0
            //   48898424b0010000     | dec                 eax
            //   48c744243000000000     | mov    esi, eax

        $sequence_3 = { 488b8c24b0010000 e8???????? 803b00 0f853c010000 488b942450010000 4885d2 7413 }
            // n = 7, score = 100
            //   488b8c24b0010000     | mov                 ebx, 0x20
            //   e8????????           |                     
            //   803b00               | dec                 esp
            //   0f853c010000         | add                 ecx, ecx
            //   488b942450010000     | dec                 eax
            //   4885d2               | shl                 edx, cl
            //   7413                 | inc                 esp

        $sequence_4 = { 660f1f440000 410fb63f 41c60700 4885f6 7413 48b80000000000000040 488506 }
            // n = 7, score = 100
            //   660f1f440000         | movups              xmmword ptr [esp + 0x50], xmm6
            //   410fb63f             | movdqu              xmm6, xmmword ptr [edx]
            //   41c60700             | dec                 eax
            //   4885f6               | mov                 dword ptr [esp + 0x48], 0
            //   7413                 | dec                 eax
            //   48b80000000000000040     | mov    ebx, ecx
            //   488506               | push                ebx

        $sequence_5 = { 4c8d0d69880500 4889c1 488b05???????? 4c8d056f880500 48895110 488901 488d05bf880500 }
            // n = 7, score = 100
            //   4c8d0d69880500       | dec                 esp
            //   4889c1               | mov                 ecx, edi
            //   488b05????????       |                     
            //   4c8d056f880500       | dec                 eax
            //   48895110             | add                 esp, 0x78
            //   488901               | pop                 ebx
            //   488d05bf880500       | pop                 esi

        $sequence_6 = { e8???????? 803b00 0f8515feffff 4885f6 7413 48b80000000000000040 488506 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   803b00               | movups              xmmword ptr [esp + 0x30], xmm1
            //   0f8515feffff         | cmp                 byte ptr [eax], 0
            //   4885f6               | jne                 0x10b
            //   7413                 | dec                 esp
            //   48b80000000000000040     | mov    edx, esp
            //   488506               | dec                 eax

        $sequence_7 = { e8???????? 803800 7561 488b03 488d0d2fde0900 480fbf7010 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   803800               | cmp                 byte ptr [eax], 0
            //   7561                 | dec                 eax
            //   488b03               | mov                 esi, eax
            //   488d0d2fde0900       | jne                 0x699
            //   480fbf7010           | dec                 eax
            //   e8????????           |                     

        $sequence_8 = { 4c8d7c2460 f3440f6f05???????? 4c8d742430 488b442478 4c89e6 4c89ea 4889e9 }
            // n = 7, score = 100
            //   4c8d7c2460           | movups              xmmword ptr [esp + 0xb0], xmm4
            //   f3440f6f05????????     |     
            //   4c8d742430           | movups              xmmword ptr [esp + 0x110], xmm4
            //   488b442478           | movups              xmmword ptr [esp + 0x100], xmm4
            //   4c89e6               | dec                 esp
            //   4c89ea               | mov                 eax, dword ptr [esp + 0x1c0]
            //   4889e9               | dec                 esp

        $sequence_9 = { 4c89f9 4c894c2420 e8???????? 803b00 4c8b4c2420 0f85bd010000 f30f6f15???????? }
            // n = 7, score = 100
            //   4c89f9               | dec                 eax
            //   4c894c2420           | mov                 eax, dword ptr [esp + 0x30]
            //   e8????????           |                     
            //   803b00               | dec                 eax
            //   4c8b4c2420           | mov                 dword ptr [esp + 0x70], eax
            //   0f85bd010000         | dec                 esp
            //   f30f6f15????????     |                     

    condition:
        7 of them and filesize < 1811456
}