rule win_ninerat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.ninerat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ninerat"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4c8b45e0 4c3b45f0 734d 483b3e }
            // n = 4, score = 400
            //   4c8b45e0             | inc                 esp
            //   4c3b45f0             | and                 al, 0x50
            //   734d                 | dec                 eax
            //   483b3e               | mov                 ecx, dword ptr [esp + 0x50]

        $sequence_1 = { 4c8b45e0 4c8945f0 4c8b4de8 4c894df8 4c8d45f0 }
            // n = 5, score = 400
            //   4c8b45e0             | mov                 dword ptr [esp + 0x80], ecx
            //   4c8945f0             | dec                 eax
            //   4c8b4de8             | mov                 eax, 0xd32acac8
            //   4c894df8             | das                 
            //   4c8d45f0             | mov                 esp, 0x89480d0c

        $sequence_2 = { 4c89b570ffffff 4c89bd78ffffff 48894d10 4889d3 4d89c4 4d89cd 4883ec08 }
            // n = 7, score = 400
            //   4c89b570ffffff       | dec                 eax
            //   4c89bd78ffffff       | mov                 dword ptr [esp + 0x88], ecx
            //   48894d10             | dec                 esp
            //   4889d3               | mov                 eax, dword ptr [ebp - 0x18]
            //   4d89c4               | dec                 eax
            //   4d89cd               | mov                 ecx, dword ptr [ebp - 8]
            //   4883ec08             | dec                 eax

        $sequence_3 = { 4c8b45e8 4889d9 e8???????? 488b5dd8 488b75e0 488be5 }
            // n = 6, score = 400
            //   4c8b45e8             | xor                 edx, edx
            //   4889d9               | dec                 ecx
            //   e8????????           |                     
            //   488b5dd8             | mov                 ecx, esi
            //   488b75e0             | inc                 ecx
            //   488be5               | mov                 eax, 0x800

        $sequence_4 = { 4c898dd0feffff 4c8bce 4c8b8500ffffff bac9090000 }
            // n = 4, score = 400
            //   4c898dd0feffff       | dec                 eax
            //   4c8bce               | mov                 dword ptr [esp + 0x130], eax
            //   4c8b8500ffffff       | dec                 eax
            //   bac9090000           | mov                 dword ptr [esp + 0x50], eax

        $sequence_5 = { 4c8b45e0 49c1e004 4c0345e8 4c39c6 72a8 31c0 488b5dc0 }
            // n = 7, score = 400
            //   4c8b45e0             | mov                 ebx, dword ptr [ebp - 0x28]
            //   49c1e004             | dec                 esp
            //   4c0345e8             | mov                 eax, dword ptr [ebp - 0x20]
            //   4c39c6               | dec                 esp
            //   72a8                 | mov                 dword ptr [ebp - 0x10], eax
            //   31c0                 | dec                 esp
            //   488b5dc0             | mov                 ecx, dword ptr [ebp - 0x18]

        $sequence_6 = { 4c8b45e0 488b55f0 488b4de8 e8???????? }
            // n = 4, score = 400
            //   4c8b45e0             | dec                 eax
            //   488b55f0             | mov                 dword ptr [ebp + 0x10], ecx
            //   488b4de8             | dec                 eax
            //   e8????????           |                     

        $sequence_7 = { 4c8b45e8 488b4df8 e8???????? 4889c1 e8???????? }
            // n = 5, score = 400
            //   4c8b45e8             | add                 eax, eax
            //   488b4df8             | mov                 eax, dword ptr [ecx + eax*8]
            //   e8????????           |                     
            //   4889c1               | jmp                 0x1a
            //   e8????????           |                     

        $sequence_8 = { 0f84ac000000 e9???????? 4d8bb4f670300100 33d2 498bce 41b800080000 ff15???????? }
            // n = 7, score = 100
            //   0f84ac000000         | inc                 ecx
            //   e9????????           |                     
            //   4d8bb4f670300100     | mov                 edx, edx
            //   33d2                 | dec                 ebp
            //   498bce               | mov                 ecx, dword ptr [edi + eax*8 + 0x1c6f0]
            //   41b800080000         | dec                 ecx
            //   ff15????????         |                     

        $sequence_9 = { 660fef8c24d0000000 66480f7ec8 69c895e9d15b 8bc1 c1e818 }
            // n = 5, score = 100
            //   660fef8c24d0000000     | pxor    xmm1, xmmword ptr [esp + 0xd0]
            //   66480f7ec8           | dec                 ax
            //   69c895e9d15b         | movd                eax, mm1
            //   8bc1                 | imul                ecx, eax, 0x5bd1e995
            //   c1e818               | mov                 eax, ecx

        $sequence_10 = { 4d8be1 498be8 4c8bea 498b84ff70c20100 4983ceff 493bc6 0f84f9000000 }
            // n = 7, score = 100
            //   4d8be1               | lea                 ecx, [esp + 0x80]
            //   498be8               | call                edx
            //   4c8bea               | dec                 esp
            //   498b84ff70c20100     | mov                 dword ptr [esp + 0x50], ebp
            //   4983ceff             | dec                 ebp
            //   493bc6               | mov                 esp, ecx
            //   0f84f9000000         | dec                 ecx

        $sequence_11 = { 488d0d85e80000 e8???????? 85c0 740a }
            // n = 4, score = 100
            //   488d0d85e80000       | shr                 eax, 0x18
            //   e8????????           |                     
            //   85c0                 | dec                 eax
            //   740a                 | lea                 ecx, [0xe885]

        $sequence_12 = { 81fae9fd0000 0f8582010000 4c8d3d0c21ffff 418bd2 4d8b8cc7f0c60100 498bfa 4b8d04f1 }
            // n = 7, score = 100
            //   81fae9fd0000         | mov                 ebp, eax
            //   0f8582010000         | dec                 esp
            //   4c8d3d0c21ffff       | mov                 ebp, edx
            //   418bd2               | dec                 ecx
            //   4d8b8cc7f0c60100     | mov                 eax, dword ptr [edi + edi*8 + 0x1c270]
            //   498bfa               | dec                 ecx
            //   4b8d04f1             | or                  esi, 0xffffffff

        $sequence_13 = { 660fef842420030000 660f7f842480000000 488d8c2480000000 ffd2 4c896c2450 }
            // n = 5, score = 100
            //   660fef842420030000     | test    eax, eax
            //   660f7f842480000000     | je    0xc
            //   488d8c2480000000     | pxor                xmm0, xmmword ptr [esp + 0x320]
            //   ffd2                 | movdqa              xmmword ptr [esp + 0x80], xmm0
            //   4c896c2450           | dec                 eax

        $sequence_14 = { 3de4000000 7311 4898 488d0d025b0000 4803c0 8b04c1 eb02 }
            // n = 7, score = 100
            //   3de4000000           | dec                 ecx
            //   7311                 | cmp                 eax, esi
            //   4898                 | je                  0x111
            //   488d0d025b0000       | cmp                 edx, 0xfde9
            //   4803c0               | jne                 0x18e
            //   8b04c1               | dec                 esp
            //   eb02                 | lea                 edi, [0xffff210c]

        $sequence_15 = { e8???????? 4c896c2450 488b442450 4889842430010000 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   4c896c2450           | mov                 edi, edx
            //   488b442450           | dec                 ebx
            //   4889842430010000     | lea                 eax, [ecx + esi*8]

    condition:
        7 of them and filesize < 7709696
}