rule win_noxplayer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.noxplayer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.noxplayer"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488b11 89449afc 483bdd 7cdd 488d5e28 41bc04000000 }
            // n = 6, score = 100
            //   488b11               | dec                 esp
            //   89449afc             | lea                 eax, [ebp + 0x30]
            //   483bdd               | dec                 eax
            //   7cdd                 | mov                 edx, ebx
            //   488d5e28             | mov                 byte ptr [ebx + 0x65], 0
            //   41bc04000000         | dec                 eax

        $sequence_1 = { 8b0cb8 41890b e8???????? 488b4e10 4c8bd8 442b1cf9 3b7e1c }
            // n = 7, score = 100
            //   8b0cb8               | inc                 esp
            //   41890b               | lea                 ecx, [ecx + 1]
            //   e8????????           |                     
            //   488b4e10             | dec                 ebp
            //   4c8bd8               | mov                 ebx, dword ptr [esp]
            //   442b1cf9             | inc                 ebp
            //   3b7e1c               | mov                 edx, dword ptr [ebx]

        $sequence_2 = { 48634810 488b00 486bc968 488d540198 48395318 7417 488b4318 }
            // n = 7, score = 100
            //   48634810             | mov                 edx, edi
            //   488b00               | inc                 dword ptr [edi + 0x1c8]
            //   486bc968             | dec                 esp
            //   488d540198           | mov                 esi, dword ptr [esp + 0xa0]
            //   48395318             | dec                 esp
            //   7417                 | lea                 eax, [ebp - 0x45]
            //   488b4318             | dec                 eax

        $sequence_3 = { 4889b180000000 4889b1d0000000 4889b188000000 4889b1d8000000 4889b1e0000000 4889b190000000 4889b1e8000000 }
            // n = 7, score = 100
            //   4889b180000000       | jl                  0x1c60
            //   4889b1d0000000       | jmp                 0x1c88
            //   4889b188000000       | seta                al
            //   4889b1d8000000       | test                al, al
            //   4889b1e0000000       | je                  0x1c88
            //   4889b190000000       | dec                 ebp
            //   4889b1e8000000       | mov                 edx, dword ptr [edx + 0x10]

        $sequence_4 = { 488bd8 482b1f 483b4710 750d ba01000000 488bcf e8???????? }
            // n = 7, score = 100
            //   488bd8               | je                  0x1280
            //   482b1f               | dec                 eax
            //   483b4710             | mov                 edx, dword ptr [ebp + 0x28]
            //   750d                 | mov                 ecx, 0x40
            //   ba01000000           | dec                 eax
            //   488bcf               | mov                 dword ptr [ebp + 0x58], eax
            //   e8????????           |                     

        $sequence_5 = { 8b4328 41894618 33c0 e9???????? 488b4740 488b4810 8b4760 }
            // n = 7, score = 100
            //   8b4328               | dec                 eax
            //   41894618             | mov                 edx, dword ptr [ebx]
            //   33c0                 | call                dword ptr [eax + 0x18]
            //   e9????????           |                     
            //   488b4740             | mov                 edi, eax
            //   488b4810             | or                  ecx, 0xffffffff
            //   8b4760               | lock xadd           dword ptr [ebx + 0x10], ecx

        $sequence_6 = { 488bc6 48894360 c6436800 488d442430 4889442428 89742420 4c8bcb }
            // n = 7, score = 100
            //   488bc6               | lea                 ecx, [eax + 1]
            //   48894360             | dec                 eax
            //   c6436800             | lea                 edx, [ebx + 0xb8]
            //   488d442430           | mov                 eax, dword ptr [edx]
            //   4889442428           | cmp                 ecx, eax
            //   89742420             | je                  0x13fb
            //   4c8bcb               | mov                 eax, dword ptr [ebx + 0xc0]

        $sequence_7 = { 488b1b 488bcf e8???????? 488bfb 807b2100 74e0 33d2 }
            // n = 7, score = 100
            //   488b1b               | cmp                 byte ptr [eax + 0x29], 0
            //   488bcf               | jne                 0x167e
            //   e8????????           |                     
            //   488bfb               | nop                 word ptr [eax + eax]
            //   807b2100             | dec                 eax
            //   74e0                 | mov                 ebx, eax
            //   33d2                 | dec                 eax

        $sequence_8 = { 80792900 7513 483b4110 750d 488bc1 488b4908 }
            // n = 6, score = 100
            //   80792900             | mov                 edi, eax
            //   7513                 | dec                 eax
            //   483b4110             | add                 ecx, 8
            //   750d                 | dec                 eax
            //   488bc1               | mov                 ecx, dword ptr [edx + 0x40]
            //   488b4908             | dec                 eax

        $sequence_9 = { 413bc9 7e04 ffc7 03c1 4883c204 49ffc8 75e7 }
            // n = 7, score = 100
            //   413bc9               | lea                 edx, [ebp + 0x200]
            //   7e04                 | dec                 eax
            //   ffc7                 | lea                 ecx, [ebx + 0x2c]
            //   03c1                 | inc                 ecx
            //   4883c204             | mov                 edi, esi
            //   49ffc8               | cmp                 dword ptr [ecx - 4], 1
            //   75e7                 | jle                 0x105

    condition:
        7 of them and filesize < 742400
}