rule win_oni_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.oni."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.oni"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c404 8b451c c745f80f000000 c745f400000000 c645e400 83f810 }
            // n = 6, score = 200
            //   83c404               | add                 esp, 4
            //   8b451c               | mov                 eax, dword ptr [ebp + 0x1c]
            //   c745f80f000000       | mov                 dword ptr [ebp - 8], 0xf
            //   c745f400000000       | mov                 dword ptr [ebp - 0xc], 0
            //   c645e400             | mov                 byte ptr [ebp - 0x1c], 0
            //   83f810               | cmp                 eax, 0x10

        $sequence_1 = { 8bfb 6aff 8d4701 c746140f000000 50 8d4508 }
            // n = 6, score = 200
            //   8bfb                 | mov                 edi, ebx
            //   6aff                 | push                -1
            //   8d4701               | lea                 eax, [edi + 1]
            //   c746140f000000       | mov                 dword ptr [esi + 0x14], 0xf
            //   50                   | push                eax
            //   8d4508               | lea                 eax, [ebp + 8]

        $sequence_2 = { 47 a1???????? 3bf8 7cc1 48 85c0 }
            // n = 6, score = 200
            //   47                   | inc                 edi
            //   a1????????           |                     
            //   3bf8                 | cmp                 edi, eax
            //   7cc1                 | jl                  0xffffffc3
            //   48                   | dec                 eax
            //   85c0                 | test                eax, eax

        $sequence_3 = { 83c404 c745bc0f000000 c745b800000000 c645a800 8d8d60ffffff }
            // n = 5, score = 200
            //   83c404               | add                 esp, 4
            //   c745bc0f000000       | mov                 dword ptr [ebp - 0x44], 0xf
            //   c745b800000000       | mov                 dword ptr [ebp - 0x48], 0
            //   c645a800             | mov                 byte ptr [ebp - 0x58], 0
            //   8d8d60ffffff         | lea                 ecx, [ebp - 0xa0]

        $sequence_4 = { c7411000000000 50 c60100 e8???????? 8d4d9c e8???????? 8b4594 }
            // n = 7, score = 200
            //   c7411000000000       | mov                 dword ptr [ecx + 0x10], 0
            //   50                   | push                eax
            //   c60100               | mov                 byte ptr [ecx], 0
            //   e8????????           |                     
            //   8d4d9c               | lea                 ecx, [ebp - 0x64]
            //   e8????????           |                     
            //   8b4594               | mov                 eax, dword ptr [ebp - 0x6c]

        $sequence_5 = { 0f1f4000 b9???????? 8d85e4f6ffff 0f1f440000 8a10 3a11 751a }
            // n = 7, score = 200
            //   0f1f4000             | nop                 dword ptr [eax]
            //   b9????????           |                     
            //   8d85e4f6ffff         | lea                 eax, [ebp - 0x91c]
            //   0f1f440000           | nop                 dword ptr [eax + eax]
            //   8a10                 | mov                 dl, byte ptr [eax]
            //   3a11                 | cmp                 dl, byte ptr [ecx]
            //   751a                 | jne                 0x1c

        $sequence_6 = { c1e81f 03c2 0f8431020000 33db 8b4518 8d8d00ffffff 40 }
            // n = 7, score = 200
            //   c1e81f               | shr                 eax, 0x1f
            //   03c2                 | add                 eax, edx
            //   0f8431020000         | je                  0x237
            //   33db                 | xor                 ebx, ebx
            //   8b4518               | mov                 eax, dword ptr [ebp + 0x18]
            //   8d8d00ffffff         | lea                 ecx, [ebp - 0x100]
            //   40                   | inc                 eax

        $sequence_7 = { c7411000000000 50 c60100 e8???????? 83ec18 8d4508 8bcc }
            // n = 7, score = 200
            //   c7411000000000       | mov                 dword ptr [ecx + 0x10], 0
            //   50                   | push                eax
            //   c60100               | mov                 byte ptr [ecx], 0
            //   e8????????           |                     
            //   83ec18               | sub                 esp, 0x18
            //   8d4508               | lea                 eax, [ebp + 8]
            //   8bcc                 | mov                 ecx, esp

        $sequence_8 = { 6a08 8d4c241c c74424300f000000 c744242c00000000 c644241c00 e8???????? 8b542428 }
            // n = 7, score = 200
            //   6a08                 | push                8
            //   8d4c241c             | lea                 ecx, [esp + 0x1c]
            //   c74424300f000000     | mov                 dword ptr [esp + 0x30], 0xf
            //   c744242c00000000     | mov                 dword ptr [esp + 0x2c], 0
            //   c644241c00           | mov                 byte ptr [esp + 0x1c], 0
            //   e8????????           |                     
            //   8b542428             | mov                 edx, dword ptr [esp + 0x28]

        $sequence_9 = { 83f810 7241 8b8d98fdffff 40 3d00100000 722a }
            // n = 6, score = 200
            //   83f810               | cmp                 eax, 0x10
            //   7241                 | jb                  0x43
            //   8b8d98fdffff         | mov                 ecx, dword ptr [ebp - 0x268]
            //   40                   | inc                 eax
            //   3d00100000           | cmp                 eax, 0x1000
            //   722a                 | jb                  0x2c

    condition:
        7 of them and filesize < 499712
}