rule win_op_blockbuster_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.op_blockbuster."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.op_blockbuster"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { f3ab 66ab aa 5f 85f6 5e }
            // n = 6, score = 800
            //   f3ab                 | test                eax, eax
            //   66ab                 | je                  0x4d
            //   aa                   | dec                 eax
            //   5f                   | lea                 eax, [esp + 0x48]
            //   85f6                 | dec                 esp
            //   5e                   | lea                 ecx, [esp + 0x50]

        $sequence_1 = { 56 57 683c400000 6a40 }
            // n = 4, score = 800
            //   56                   | dec                 ebp
            //   57                   | mov                 eax, ebp
            //   683c400000           | mov                 ecx, dword ptr [ecx + 0x7c]
            //   6a40                 | test                ecx, ecx

        $sequence_2 = { e8???????? 6800400000 6a00 ff15???????? }
            // n = 4, score = 800
            //   e8????????           |                     
            //   6800400000           | je                  9
            //   6a00                 | cmp                 eax, 2
            //   ff15????????         |                     

        $sequence_3 = { 8a08 80f920 7505 83c021 }
            // n = 4, score = 800
            //   8a08                 | je                  0xb
            //   80f920               | push                ecx
            //   7505                 | push                0
            //   83c021               | test                eax, eax

        $sequence_4 = { 8b497c 85c9 7407 51 }
            // n = 4, score = 800
            //   8b497c               | mov                 ecx, 0x7530
            //   85c9                 | je                  0x10
            //   7407                 | not                 edi
            //   51                   | and                 edi, eax

        $sequence_5 = { 6a00 e8???????? 85c0 7407 83f802 }
            // n = 5, score = 800
            //   6a00                 | mov                 ecx, 0x410
            //   e8????????           |                     
            //   85c0                 | dec                 eax
            //   7407                 | mov                 ebx, eax
            //   83f802               | dec                 eax

        $sequence_6 = { ff15???????? 6808400000 6a40 ff15???????? }
            // n = 4, score = 800
            //   ff15????????         |                     
            //   6808400000           | je                  0x8b
            //   6a40                 | cmp                 edi, 1
            //   ff15????????         |                     

        $sequence_7 = { 68???????? ff15???????? 85c0 7412 68???????? 50 e8???????? }
            // n = 7, score = 700
            //   68????????           |                     
            //   ff15????????         |                     
            //   85c0                 | pop                 edi
            //   7412                 | push                0
            //   68????????           |                     
            //   50                   | mov                 edi, eax
            //   e8????????           |                     

        $sequence_8 = { 68???????? 56 ff15???????? 68???????? 56 a3???????? e8???????? }
            // n = 7, score = 700
            //   68????????           |                     
            //   56                   | push                eax
            //   ff15????????         |                     
            //   68????????           |                     
            //   56                   | pop                 ecx
            //   a3????????           |                     
            //   e8????????           |                     

        $sequence_9 = { 56 50 8d45fc 6a04 50 }
            // n = 5, score = 700
            //   56                   | test                edi, edi
            //   50                   | jne                 0xa
            //   8d45fc               | pop                 edi
            //   6a04                 | and                 eax, 0x1f
            //   50                   | mov                 esi, dword ptr [esi*4 + 0x40a300]

        $sequence_10 = { 7f04 0409 eb06 3c72 }
            // n = 4, score = 500
            //   7f04                 | jg                  6
            //   0409                 | add                 al, 9
            //   eb06                 | jmp                 8
            //   3c72                 | cmp                 al, 0x72

        $sequence_11 = { 3c69 7c08 3c70 7f04 0409 }
            // n = 5, score = 500
            //   3c69                 | cmp                 al, 0x69
            //   7c08                 | jl                  0xa
            //   3c70                 | cmp                 al, 0x70
            //   7f04                 | jg                  6
            //   0409                 | add                 al, 9

        $sequence_12 = { ff15???????? 85c0 0f84aa000000 488b4c2448 488d442440 }
            // n = 5, score = 300
            //   ff15????????         |                     
            //   85c0                 | cmp                 eax, edx
            //   0f84aa000000         | jg                  0x1e
            //   488b4c2448           | mov                 word ptr [esp + 0x34], si
            //   488d442440           | inc                 eax

        $sequence_13 = { 6689742434 4088b42450010000 e8???????? 488d4c2441 }
            // n = 4, score = 300
            //   6689742434           | lea                 ecx, [esp + 0x48]
            //   4088b42450010000     | add                 edx, eax
            //   e8????????           |                     
            //   488d4c2441           | imul                eax, eax, 0x3c

        $sequence_14 = { 6a00 ff15???????? 8bf8 85ff 7504 5f 5e }
            // n = 7, score = 300
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   8bf8                 | cmp                 dword ptr [esp + 8], eax
            //   85ff                 | mov                 eax, esi
            //   7504                 | pop                 edi
            //   5f                   | pop                 esi
            //   5e                   | ret                 

        $sequence_15 = { 68???????? 56 e8???????? 56 e8???????? 83c438 }
            // n = 6, score = 300
            //   68????????           |                     
            //   56                   | push                edi
            //   e8????????           |                     
            //   56                   | mov                 eax, esi
            //   e8????????           |                     
            //   83c438               | pop                 edi

        $sequence_16 = { 03d0 8b05???????? 6bc03c 0305???????? 3bc2 7f17 8b05???????? }
            // n = 7, score = 300
            //   03d0                 | mov                 eax, 0x4000
            //   8b05????????         |                     
            //   6bc03c               | inc                 ebp
            //   0305????????         |                     
            //   3bc2                 | mov                 eax, ebp
            //   7f17                 | dec                 esp
            //   8b05????????         |                     

        $sequence_17 = { 53 6a01 57 e8???????? 56 e8???????? 83c414 }
            // n = 7, score = 300
            //   53                   | pop                 esi
            //   6a01                 | ret                 
            //   57                   | xor                 eax, eax
            //   e8????????           |                     
            //   56                   | xor                 eax, eax
            //   e8????????           |                     
            //   83c414               | jmp                 0xfffffffa

        $sequence_18 = { b910040000 ff15???????? 488bd8 4885c0 7445 488d442448 4c8d4c2450 }
            // n = 7, score = 300
            //   b910040000           | je                  0xb0
            //   ff15????????         |                     
            //   488bd8               | dec                 eax
            //   4885c0               | mov                 ecx, dword ptr [esp + 0x48]
            //   7445                 | dec                 eax
            //   488d442448           | lea                 eax, [esp + 0x40]
            //   4c8d4c2450           | mov                 ecx, 0x7530

        $sequence_19 = { b930750000 ff15???????? f605????????02 740e ff15???????? f7d7 23f8 }
            // n = 7, score = 300
            //   b930750000           | mov                 byte ptr [esp + 0x150], dh
            //   ff15????????         |                     
            //   f605????????02       |                     
            //   740e                 | dec                 eax
            //   ff15????????         |                     
            //   f7d7                 | lea                 ecx, [esp + 0x41]
            //   23f8                 | test                eax, eax

        $sequence_20 = { ff15???????? 85f6 7404 85c0 }
            // n = 4, score = 300
            //   ff15????????         |                     
            //   85f6                 | pop                 esi
            //   7404                 | ret                 
            //   85c0                 | xor                 eax, eax

        $sequence_21 = { c3 33c0 ebf8 53 33db 391d???????? 56 }
            // n = 7, score = 300
            //   c3                   | push                0
            //   33c0                 | mov                 cl, byte ptr [eax]
            //   ebf8                 | cmp                 cl, 0x20
            //   53                   | jne                 0xa
            //   33db                 | add                 eax, 0x21
            //   391d????????         |                     
            //   56                   | jmp                 0xf

        $sequence_22 = { 4c89b424e8030000 4c89bc24e0030000 448bf3 b800400000 458bc5 4c8d4c2448 }
            // n = 6, score = 300
            //   4c89b424e8030000     | dec                 esp
            //   4c89bc24e0030000     | mov                 dword ptr [esp + 0x3e8], esi
            //   448bf3               | dec                 esp
            //   b800400000           | mov                 dword ptr [esp + 0x3e0], edi
            //   458bc5               | inc                 esp
            //   4c8d4c2448           | mov                 esi, ebx

        $sequence_23 = { ff15???????? 8bc6 5f 5e c3 33c0 }
            // n = 6, score = 300
            //   ff15????????         |                     
            //   8bc6                 | rep stosd           dword ptr es:[edi], eax
            //   5f                   | stosw               word ptr es:[edi], ax
            //   5e                   | stosb               byte ptr es:[edi], al
            //   c3                   | pop                 edi
            //   33c0                 | test                esi, esi

        $sequence_24 = { 8816 eb3e c6060d 8b048dd8974400 8854382a eb2e }
            // n = 6, score = 200
            //   8816                 | jne                 6
            //   eb3e                 | pop                 edi
            //   c6060d               | ret                 
            //   8b048dd8974400       | push                esi
            //   8854382a             | push                ebx
            //   eb2e                 | push                1

        $sequence_25 = { 8bd1 d1f8 2b14c5a8324400 7413 85d2 7905 }
            // n = 6, score = 200
            //   8bd1                 | push                esi
            //   d1f8                 | add                 esp, 0x14
            //   2b14c5a8324400       | mov                 eax, 1
            //   7413                 | ret                 
            //   85d2                 | push                esi
            //   7905                 | push                ebx

        $sequence_26 = { 770f 0fb7c1 0fb680e0ff4300 83e00f eb02 33c0 }
            // n = 6, score = 200
            //   770f                 | push                edi
            //   0fb7c1               | push                esi
            //   0fb680e0ff4300       | test                esi, esi
            //   83e00f               | je                  6
            //   eb02                 | test                eax, eax
            //   33c0                 | push                edi

        $sequence_27 = { 8b4508 898850030000 8b4508 59 c7404840854400 8b4508 }
            // n = 6, score = 200
            //   8b4508               | push                1
            //   898850030000         | push                edi
            //   8b4508               | ret                 
            //   59                   | push                esi
            //   c7404840854400       | push                ebx
            //   8b4508               | push                1

        $sequence_28 = { 80f979 7f06 b3db 2ad9 }
            // n = 4, score = 100
            //   80f979               | push                eax
            //   7f06                 | pop                 ecx
            //   b3db                 | pop                 ecx
            //   2ad9                 | push                eax

        $sequence_29 = { 50 68???????? 50 68???????? 68???????? 8d8514f2ffff }
            // n = 6, score = 100
            //   50                   | push                eax
            //   68????????           |                     
            //   50                   | push                edi
            //   68????????           |                     
            //   68????????           |                     
            //   8d8514f2ffff         | je                  0x14

        $sequence_30 = { 6a00 ff15???????? 57 8bd8 ff15???????? 8b4c2414 68???????? }
            // n = 7, score = 100
            //   6a00                 | push                1
            //   ff15????????         |                     
            //   57                   | push                edi
            //   8bd8                 | push                esi
            //   ff15????????         |                     
            //   8b4c2414             | add                 esp, 0x14
            //   68????????           |                     

        $sequence_31 = { 83e01f 8b34b500a34000 8d04c0 8b0486 83f8ff }
            // n = 5, score = 100
            //   83e01f               | ret                 
            //   8b34b500a34000       | push                esi
            //   8d04c0               | push                ebx
            //   8b0486               | push                1
            //   83f8ff               | push                edi

        $sequence_32 = { 6800000080 53 ff15???????? 8bf8 83c8ff 3bf8 }
            // n = 6, score = 100
            //   6800000080           | lea                 eax, [ebp - 4]
            //   53                   | push                4
            //   ff15????????         |                     
            //   8bf8                 | push                eax
            //   83c8ff               | push                edi
            //   3bf8                 | push                esi

        $sequence_33 = { ff5108 6a01 5e ff15???????? 8bc6 5f }
            // n = 6, score = 100
            //   ff5108               | push                esi
            //   6a01                 | pop                 esi
            //   5e                   | ret                 
            //   ff15????????         |                     
            //   8bc6                 | test                eax, eax
            //   5f                   | je                  0x17

    condition:
        7 of them and filesize < 74309632
}