rule win_opachki_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.opachki."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.opachki"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33f6 56 6806000200 56 56 }
            // n = 5, score = 300
            //   33f6                 | xor                 esi, esi
            //   56                   | push                esi
            //   6806000200           | push                0x20006
            //   56                   | push                esi
            //   56                   | push                esi

        $sequence_1 = { 2b45f8 ebf2 55 8bec 8b4508 57 }
            // n = 6, score = 300
            //   2b45f8               | sub                 eax, dword ptr [ebp - 8]
            //   ebf2                 | jmp                 0xfffffff4
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   57                   | push                edi

        $sequence_2 = { 8b450c 56 8b7108 3bc6 7205 83c8ff }
            // n = 6, score = 300
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   56                   | push                esi
            //   8b7108               | mov                 esi, dword ptr [ecx + 8]
            //   3bc6                 | cmp                 eax, esi
            //   7205                 | jb                  7
            //   83c8ff               | or                  eax, 0xffffffff

        $sequence_3 = { 6a0d 68???????? 8d4ddc e8???????? 68ff000000 8d85d4feffff 50 }
            // n = 7, score = 300
            //   6a0d                 | push                0xd
            //   68????????           |                     
            //   8d4ddc               | lea                 ecx, [ebp - 0x24]
            //   e8????????           |                     
            //   68ff000000           | push                0xff
            //   8d85d4feffff         | lea                 eax, [ebp - 0x12c]
            //   50                   | push                eax

        $sequence_4 = { c3 55 8bec 81ec00010000 ff7508 }
            // n = 5, score = 300
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   81ec00010000         | sub                 esp, 0x100
            //   ff7508               | push                dword ptr [ebp + 8]

        $sequence_5 = { ff15???????? 83c40c 8b4f04 8d0433 }
            // n = 4, score = 300
            //   ff15????????         |                     
            //   83c40c               | add                 esp, 0xc
            //   8b4f04               | mov                 ecx, dword ptr [edi + 4]
            //   8d0433               | lea                 eax, [ebx + esi]

        $sequence_6 = { ff15???????? 8b35???????? 6a00 bf80000000 57 6a03 6a00 }
            // n = 7, score = 300
            //   ff15????????         |                     
            //   8b35????????         |                     
            //   6a00                 | push                0
            //   bf80000000           | mov                 edi, 0x80
            //   57                   | push                edi
            //   6a03                 | push                3
            //   6a00                 | push                0

        $sequence_7 = { 7413 8b4704 03c8 53 51 03c6 }
            // n = 6, score = 300
            //   7413                 | je                  0x15
            //   8b4704               | mov                 eax, dword ptr [edi + 4]
            //   03c8                 | add                 ecx, eax
            //   53                   | push                ebx
            //   51                   | push                ecx
            //   03c6                 | add                 eax, esi

        $sequence_8 = { 752b 46 88470c 88c4 c0ec06 88670d }
            // n = 6, score = 200
            //   752b                 | jne                 0x2d
            //   46                   | inc                 esi
            //   88470c               | mov                 byte ptr [edi + 0xc], al
            //   88c4                 | mov                 ah, al
            //   c0ec06               | shr                 ah, 6
            //   88670d               | mov                 byte ptr [edi + 0xd], ah

        $sequence_9 = { 7427 f6c140 7412 08d2 7408 66ad }
            // n = 6, score = 200
            //   7427                 | je                  0x29
            //   f6c140               | test                cl, 0x40
            //   7412                 | je                  0x14
            //   08d2                 | or                  dl, dl
            //   7408                 | je                  0xa
            //   66ad                 | lodsw               ax, word ptr [esi]

        $sequence_10 = { 3c65 7505 884703 ebcc }
            // n = 4, score = 200
            //   3c65                 | cmp                 al, 0x65
            //   7505                 | jne                 7
            //   884703               | mov                 byte ptr [edi + 3], al
            //   ebcc                 | jmp                 0xffffffce

        $sequence_11 = { ac 7710 80fff6 7503 }
            // n = 4, score = 200
            //   ac                   | lodsb               al, byte ptr [esi]
            //   7710                 | ja                  0x12
            //   80fff6               | cmp                 bh, 0xf6
            //   7503                 | jne                 5

        $sequence_12 = { 61 c3 898389838983 898389838983 898389838585 858585858585 }
            // n = 6, score = 200
            //   61                   | popal               
            //   c3                   | ret                 
            //   898389838983         | mov                 dword ptr [ebx - 0x7c767c77], eax
            //   898389838983         | mov                 dword ptr [ebx - 0x7c767c77], eax
            //   898389838585         | mov                 dword ptr [ebx - 0x7a7a7c77], eax
            //   858585858585         | test                dword ptr [ebp - 0x7a7a7a7b], eax

        $sequence_13 = { 99 b125 f3aa 83ef25 8b742424 ac }
            // n = 6, score = 200
            //   99                   | cdq                 
            //   b125                 | mov                 cl, 0x25
            //   f3aa                 | rep stosb           byte ptr es:[edi], al
            //   83ef25               | sub                 edi, 0x25
            //   8b742424             | mov                 esi, dword ptr [esp + 0x24]
            //   ac                   | lodsb               al, byte ptr [esi]

        $sequence_14 = { 3cf2 7505 884701 ebf2 3cf0 7505 884702 }
            // n = 7, score = 200
            //   3cf2                 | cmp                 al, 0xf2
            //   7505                 | jne                 7
            //   884701               | mov                 byte ptr [edi + 1], al
            //   ebf2                 | jmp                 0xfffffff4
            //   3cf0                 | cmp                 al, 0xf0
            //   7505                 | jne                 7
            //   884702               | mov                 byte ptr [edi + 2], al

    condition:
        7 of them and filesize < 122880
}