rule win_photofork_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.photofork."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.photofork"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 57 4154 4156 488bec 4883ec50 33ff }
            // n = 6, score = 400
            //   57                   | dec                 eax
            //   4154                 | inc                 ecx
            //   4156                 | nop                 dword ptr [eax]
            //   488bec               | nop                 word ptr [eax + eax]
            //   4883ec50             | mov                 eax, dword ptr [ebp + ecx*4 - 0x3c]
            //   33ff                 | xor                 eax, 0x60e9a7fc

        $sequence_1 = { 48ffc1 4883f903 72ea 458bcd }
            // n = 4, score = 400
            //   48ffc1               | movzx               eax, byte ptr [ebx]
            //   4883f903             | dec                 eax
            //   72ea                 | mov                 dword ptr [esp + 0x18], esi
            //   458bcd               | push                edi

        $sequence_2 = { 488981e0100000 eb12 ba01000000 33c9 }
            // n = 4, score = 400
            //   488981e0100000       | inc                 ebp
            //   eb12                 | cmove               eax, edx
            //   ba01000000           | inc                 esp
            //   33c9                 | lea                 edi, [edi + 0x10]

        $sequence_3 = { 8b4544 0fb64540 84c0 750b }
            // n = 4, score = 400
            //   8b4544               | lea                 edx, [ecx + 1]
            //   0fb64540             | xor                 ecx, ecx
            //   84c0                 | dec                 ebp
            //   750b                 | test                ecx, ecx

        $sequence_4 = { 4c8d45c4 eb72 488b05???????? 4885c0 742c 488b8080010000 }
            // n = 6, score = 400
            //   4c8d45c4             | pop                 edi
            //   eb72                 | pop                 esi
            //   488b05????????       |                     
            //   4885c0               | call                eax
            //   742c                 | mov                 esi, ebx
            //   488b8080010000       | mov                 byte ptr [ebp - 0x41], bl

        $sequence_5 = { 488b05???????? 4c895048 41b904000000 41b800300000 488bd6 33c9 41ffd2 }
            // n = 7, score = 400
            //   488b05????????       |                     
            //   4c895048             | dec                 eax
            //   41b904000000         | cwde                
            //   41b800300000         | inc                 ecx
            //   488bd6               | mov                 ecx, dword ptr [eax + eax*4 + 0x43e4]
            //   33c9                 | dec                 ecx
            //   41ffd2               | add                 ecx, eax

        $sequence_6 = { d3c8 ffc0 418900 488b7c2428 4c3b4c2430 }
            // n = 5, score = 400
            //   d3c8                 | dec                 esp
            //   ffc0                 | lea                 eax, [ebp + 0x1f0]
            //   418900               | dec                 esp
            //   488b7c2428           | mov                 esi, ecx
            //   4c3b4c2430           | dec                 ecx

        $sequence_7 = { c60100 488d4901 4883e801 75f3 488b15???????? 4885d2 }
            // n = 6, score = 400
            //   c60100               | inc                 eax
            //   488d4901             | mov                 byte ptr [ebp - 0x49], bh
            //   4883e801             | mov                 dword ptr [ebp - 0x45], 0x4f23b9a2
            //   75f3                 | mov                 dword ptr [ebp - 0x41], 0x4f25b9a2
            //   488b15????????       |                     
            //   4885d2               | mov                 dword ptr [ebp - 0x3d], 0x4f50b987

        $sequence_8 = { 8b44246c 0fb6442468 84c0 7520 }
            // n = 4, score = 400
            //   8b44246c             | dec                 esp
            //   0fb6442468           | mov                 esi, ecx
            //   84c0                 | dec                 eax
            //   7520                 | lea                 edx, [ebp - 0x50]

        $sequence_9 = { 4d8b00 488b09 4889442420 e8???????? 488b9c24b8000000 3dc8000000 }
            // n = 6, score = 400
            //   4d8b00               | xor                 eax, 0x4f50b987
            //   488b09               | mov                 dword ptr [esp + ecx*4 + 0x6c], eax
            //   4889442420           | dec                 eax
            //   e8????????           |                     
            //   488b9c24b8000000     | inc                 ecx
            //   3dc8000000           | dec                 eax

    condition:
        7 of them and filesize < 99328
}