rule win_pickpocket_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.pickpocket."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.pickpocket"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { eb0c b96ccb0000 eb05 b960cb0000 e8???????? }
            // n = 5, score = 400
            //   eb0c                 | mov                 ecx, dword ptr [ebp - 4]
            //   b96ccb0000           | dec                 eax
            //   eb05                 | mov                 byte ptr [eax + ecx], bl
            //   b960cb0000           | test                eax, eax
            //   e8????????           |                     

        $sequence_1 = { b97dcb0000 eb0c b96ccb0000 eb05 b960cb0000 e8???????? eb02 }
            // n = 7, score = 400
            //   b97dcb0000           | jne                 0x119e
            //   eb0c                 | mov                 al, byte ptr [edi + 0x42]
            //   b96ccb0000           | test                al, al
            //   eb05                 | pop                 ecx
            //   b960cb0000           | test                eax, eax
            //   e8????????           |                     
            //   eb02                 | jne                 0x12be

        $sequence_2 = { 750f b962890100 e8???????? e9???????? }
            // n = 4, score = 400
            //   750f                 | mov                 byte ptr [ecx + 0x23], al
            //   b962890100           | dec                 eax
            //   e8????????           |                     
            //   e9????????           |                     

        $sequence_3 = { 750f b93eaf0000 e8???????? e9???????? }
            // n = 4, score = 400
            //   750f                 | mov                 dword ptr [esp + 0x16], eax
            //   b93eaf0000           | inc                 ebp
            //   e8????????           |                     
            //   e9????????           |                     

        $sequence_4 = { eb05 b960cb0000 e8???????? eb02 33c0 }
            // n = 5, score = 400
            //   eb05                 | inc                 ebp
            //   b960cb0000           | mov                 dword ptr [esp + 0x4c], eax
            //   e8????????           |                     
            //   eb02                 | test                eax, eax
            //   33c0                 | jne                 0x84c

        $sequence_5 = { 750e b958de0100 e8???????? 8bc8 }
            // n = 4, score = 400
            //   750e                 | inc                 ecx
            //   b958de0100           | movups              xmm0, xmmword ptr [esp]
            //   e8????????           |                     
            //   8bc8                 | movdqu              xmmword ptr [ebx + 0x258], xmm0

        $sequence_6 = { 750f b91f220100 e8???????? e9???????? }
            // n = 4, score = 400
            //   750f                 | mov                 edx, esp
            //   b91f220100           | inc                 cx
            //   e8????????           |                     
            //   e9????????           |                     

        $sequence_7 = { 741a b97dcb0000 eb0c b96ccb0000 eb05 }
            // n = 5, score = 400
            //   741a                 | dec                 eax
            //   b97dcb0000           | mov                 dword ptr [ebp - 0x28], ecx
            //   eb0c                 | dec                 eax
            //   b96ccb0000           | mov                 esi, edx
            //   eb05                 | dec                 eax

        $sequence_8 = { 33c0 eb0a b952ca0000 e8???????? }
            // n = 4, score = 400
            //   33c0                 | and                 dword ptr [esp + 0x30], edi
            //   eb0a                 | dec                 eax
            //   b952ca0000           | lea                 ecx, [esp + 0x38]
            //   e8????????           |                     

        $sequence_9 = { 3bc7 760a b988d30000 e9???????? }
            // n = 4, score = 400
            //   3bc7                 | je                  0xb6
            //   760a                 | mov                 eax, dword ptr [ebp - 0xc]
            //   b988d30000           | add                 ecx, 2
            //   e9????????           |                     

    condition:
        7 of them and filesize < 1458176
}