rule win_ployx_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.ployx."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ployx"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 5d 5b c3 56 68???????? 6804010000 ff15???????? }
            // n = 7, score = 100
            //   5d                   | pop                 ebp
            //   5b                   | pop                 ebx
            //   c3                   | ret                 
            //   56                   | push                esi
            //   68????????           |                     
            //   6804010000           | push                0x104
            //   ff15????????         |                     

        $sequence_1 = { e8???????? 8b35???????? 59 59 8d45fc 50 ffd6 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b35????????         |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax
            //   ffd6                 | call                esi

        $sequence_2 = { ff7610 e8???????? 8bf8 8d4701 50 e8???????? 56 }
            // n = 7, score = 100
            //   ff7610               | push                dword ptr [esi + 0x10]
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   8d4701               | lea                 eax, [edi + 1]
            //   50                   | push                eax
            //   e8????????           |                     
            //   56                   | push                esi

        $sequence_3 = { e8???????? 8b0d???????? 56 ff75f0 c1e105 50 89840da8d5ffff }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b0d????????         |                     
            //   56                   | push                esi
            //   ff75f0               | push                dword ptr [ebp - 0x10]
            //   c1e105               | shl                 ecx, 5
            //   50                   | push                eax
            //   89840da8d5ffff       | mov                 dword ptr [ebp + ecx - 0x2a58], eax

        $sequence_4 = { 56 57 6a03 8b5d08 99 5e 33c9 }
            // n = 7, score = 100
            //   56                   | push                esi
            //   57                   | push                edi
            //   6a03                 | push                3
            //   8b5d08               | mov                 ebx, dword ptr [ebp + 8]
            //   99                   | cdq                 
            //   5e                   | pop                 esi
            //   33c9                 | xor                 ecx, ecx

        $sequence_5 = { 720a c1e818 0500040000 eb0a c1e810 25003f0000 0bc7 }
            // n = 7, score = 100
            //   720a                 | jb                  0xc
            //   c1e818               | shr                 eax, 0x18
            //   0500040000           | add                 eax, 0x400
            //   eb0a                 | jmp                 0xc
            //   c1e810               | shr                 eax, 0x10
            //   25003f0000           | and                 eax, 0x3f00
            //   0bc7                 | or                  eax, edi

        $sequence_6 = { e8???????? a1???????? c1e005 8b8405a8d5ffff 80243000 a1???????? }
            // n = 6, score = 100
            //   e8????????           |                     
            //   a1????????           |                     
            //   c1e005               | shl                 eax, 5
            //   8b8405a8d5ffff       | mov                 eax, dword ptr [ebp + eax - 0x2a58]
            //   80243000             | and                 byte ptr [eax + esi], 0
            //   a1????????           |                     

        $sequence_7 = { ff15???????? 6aff ff35???????? ff15???????? a1???????? 3bc6 5e }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   6aff                 | push                -1
            //   ff35????????         |                     
            //   ff15????????         |                     
            //   a1????????           |                     
            //   3bc6                 | cmp                 eax, esi
            //   5e                   | pop                 esi

        $sequence_8 = { 8b35???????? 83c434 8d85a4fdffff 50 ffd6 8d45dc }
            // n = 6, score = 100
            //   8b35????????         |                     
            //   83c434               | add                 esp, 0x34
            //   8d85a4fdffff         | lea                 eax, [ebp - 0x25c]
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   8d45dc               | lea                 eax, [ebp - 0x24]

        $sequence_9 = { 5b c3 56 68???????? 6804010000 ff15???????? 33f6 }
            // n = 7, score = 100
            //   5b                   | pop                 ebx
            //   c3                   | ret                 
            //   56                   | push                esi
            //   68????????           |                     
            //   6804010000           | push                0x104
            //   ff15????????         |                     
            //   33f6                 | xor                 esi, esi

    condition:
        7 of them and filesize < 229376
}