rule win_pngdowner_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.pngdowner."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.pngdowner"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { aa 8d9ec8dc4000 803b00 8bcb }
            // n = 4, score = 200
            //   aa                   | stosb               byte ptr es:[edi], al
            //   8d9ec8dc4000         | lea                 ebx, [esi + 0x40dcc8]
            //   803b00               | cmp                 byte ptr [ebx], 0
            //   8bcb                 | mov                 ecx, ebx

        $sequence_1 = { 83c404 83c8ff 5f 5e 5d 5b 81c45c010000 }
            // n = 7, score = 200
            //   83c404               | add                 esp, 4
            //   83c8ff               | or                  eax, 0xffffffff
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   5b                   | pop                 ebx
            //   81c45c010000         | add                 esp, 0x15c

        $sequence_2 = { 51 ff15???????? 8bf8 83ffff 751a }
            // n = 5, score = 200
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax
            //   83ffff               | cmp                 edi, -1
            //   751a                 | jne                 0x1c

        $sequence_3 = { 6a00 51 8d542438 50 52 }
            // n = 5, score = 200
            //   6a00                 | push                0
            //   51                   | push                ecx
            //   8d542438             | lea                 edx, [esp + 0x38]
            //   50                   | push                eax
            //   52                   | push                edx

        $sequence_4 = { 7419 0fb6da f68301e5400004 7406 }
            // n = 4, score = 200
            //   7419                 | je                  0x1b
            //   0fb6da               | movzx               ebx, dl
            //   f68301e5400004       | test                byte ptr [ebx + 0x40e501], 4
            //   7406                 | je                  8

        $sequence_5 = { f3a4 8b442410 8b4c2414 43 3bd9 0f82eefeffff 50 }
            // n = 7, score = 200
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   8b4c2414             | mov                 ecx, dword ptr [esp + 0x14]
            //   43                   | inc                 ebx
            //   3bd9                 | cmp                 ebx, ecx
            //   0f82eefeffff         | jb                  0xfffffef4
            //   50                   | push                eax

        $sequence_6 = { 83e01f c1f905 8d04c0 be00800000 8b0c8d40e64000 8d548104 8a4c8104 }
            // n = 7, score = 200
            //   83e01f               | and                 eax, 0x1f
            //   c1f905               | sar                 ecx, 5
            //   8d04c0               | lea                 eax, [eax + eax*8]
            //   be00800000           | mov                 esi, 0x8000
            //   8b0c8d40e64000       | mov                 ecx, dword ptr [ecx*4 + 0x40e640]
            //   8d548104             | lea                 edx, [ecx + eax*4 + 4]
            //   8a4c8104             | mov                 cl, byte ptr [ecx + eax*4 + 4]

        $sequence_7 = { 85c0 7556 b920000000 8dbc2498010000 f3ab b920000000 }
            // n = 6, score = 200
            //   85c0                 | test                eax, eax
            //   7556                 | jne                 0x58
            //   b920000000           | mov                 ecx, 0x20
            //   8dbc2498010000       | lea                 edi, [esp + 0x198]
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   b920000000           | mov                 ecx, 0x20

        $sequence_8 = { 83e00f 45 8a4c840c 884c2eff c6042e3d c6442e0100 5e }
            // n = 7, score = 200
            //   83e00f               | and                 eax, 0xf
            //   45                   | inc                 ebp
            //   8a4c840c             | mov                 cl, byte ptr [esp + eax*4 + 0xc]
            //   884c2eff             | mov                 byte ptr [esi + ebp - 1], cl
            //   c6042e3d             | mov                 byte ptr [esi + ebp], 0x3d
            //   c6442e0100           | mov                 byte ptr [esi + ebp + 1], 0
            //   5e                   | pop                 esi

        $sequence_9 = { 83651003 8bf0 750b c1e602 8b8640dc4000 }
            // n = 5, score = 200
            //   83651003             | and                 dword ptr [ebp + 0x10], 3
            //   8bf0                 | mov                 esi, eax
            //   750b                 | jne                 0xd
            //   c1e602               | shl                 esi, 2
            //   8b8640dc4000         | mov                 eax, dword ptr [esi + 0x40dc40]

    condition:
        7 of them and filesize < 131072
}