rule win_polyglot_ransom_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.polyglot_ransom."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.polyglot_ransom"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { b020 d0bdd0b5d0bc 20d1 81d0bbd0b5d0 b4d1 83d18e }
            // n = 6, score = 100
            //   b020                 | mov                 al, 0x20
            //   d0bdd0b5d0bc         | sar                 byte ptr [ebp - 0x432f4a30], 1
            //   20d1                 | and                 cl, dl
            //   81d0bbd0b5d0         | adc                 eax, 0xd0b5d0bb
            //   b4d1                 | mov                 ah, 0xd1
            //   83d18e               | adc                 ecx, -0x72

        $sequence_1 = { d0bed0b3d180 d0b0d0bcd0bc d1832e0d0a3c 61 20636c 61 7373 }
            // n = 7, score = 100
            //   d0bed0b3d180         | sar                 byte ptr [esi - 0x7f2e4c30], 1
            //   d0b0d0bcd0bc         | sal                 byte ptr [eax - 0x432f4330], 1
            //   d1832e0d0a3c         | rol                 dword ptr [ebx + 0x3c0a0d2e], 1
            //   61                   | popal               
            //   20636c               | and                 byte ptr [ebx + 0x6c], ah
            //   61                   | popal               
            //   7373                 | jae                 0x75

        $sequence_2 = { 334218 0fb655f5 8945f0 8b45f8 c1e810 23c6 8945e4 }
            // n = 7, score = 100
            //   334218               | xor                 eax, dword ptr [edx + 0x18]
            //   0fb655f5             | movzx               edx, byte ptr [ebp - 0xb]
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   c1e810               | shr                 eax, 0x10
            //   23c6                 | and                 eax, esi
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax

        $sequence_3 = { 3bf3 8b3f 7437 395e44 7532 83ff1f 742d }
            // n = 7, score = 100
            //   3bf3                 | cmp                 esi, ebx
            //   8b3f                 | mov                 edi, dword ptr [edi]
            //   7437                 | je                  0x39
            //   395e44               | cmp                 dword ptr [esi + 0x44], ebx
            //   7532                 | jne                 0x34
            //   83ff1f               | cmp                 edi, 0x1f
            //   742d                 | je                  0x2f

        $sequence_4 = { 8806 46 47 803f00 75ab 5f c60600 }
            // n = 7, score = 100
            //   8806                 | mov                 byte ptr [esi], al
            //   46                   | inc                 esi
            //   47                   | inc                 edi
            //   803f00               | cmp                 byte ptr [edi], 0
            //   75ab                 | jne                 0xffffffad
            //   5f                   | pop                 edi
            //   c60600               | mov                 byte ptr [esi], 0

        $sequence_5 = { 74b2 39750c 7514 8db364ffffff 8d7dd4 a5 a5 }
            // n = 7, score = 100
            //   74b2                 | je                  0xffffffb4
            //   39750c               | cmp                 dword ptr [ebp + 0xc], esi
            //   7514                 | jne                 0x16
            //   8db364ffffff         | lea                 esi, [ebx - 0x9c]
            //   8d7dd4               | lea                 edi, [ebp - 0x2c]
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]

        $sequence_6 = { 53 6880000000 6a02 53 6a02 6800000040 8d8500f0ffff }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   6880000000           | push                0x80
            //   6a02                 | push                2
            //   53                   | push                ebx
            //   6a02                 | push                2
            //   6800000040           | push                0x40000000
            //   8d8500f0ffff         | lea                 eax, [ebp - 0x1000]

        $sequence_7 = { 81c634ffffff 8d4dec e8???????? 8b4620 834dfcff 39706c 7514 }
            // n = 7, score = 100
            //   81c634ffffff         | add                 esi, 0xffffff34
            //   8d4dec               | lea                 ecx, [ebp - 0x14]
            //   e8????????           |                     
            //   8b4620               | mov                 eax, dword ptr [esi + 0x20]
            //   834dfcff             | or                  dword ptr [ebp - 4], 0xffffffff
            //   39706c               | cmp                 dword ptr [eax + 0x6c], esi
            //   7514                 | jne                 0x16

        $sequence_8 = { 3e51 7565 7374 65206973 7472 757a 696f6e6920736f }
            // n = 7, score = 100
            //   3e51                 | push                ecx
            //   7565                 | jne                 0x67
            //   7374                 | jae                 0x76
            //   65206973             | and                 byte ptr gs:[ecx + 0x73], ch
            //   7472                 | je                  0x74
            //   757a                 | jne                 0x7c
            //   696f6e6920736f       | imul                ebp, dword ptr [edi + 0x6e], 0x6f732069

        $sequence_9 = { 8bec 83ec20 56 ff7514 8d45e0 50 8bf1 }
            // n = 7, score = 100
            //   8bec                 | mov                 ebp, esp
            //   83ec20               | sub                 esp, 0x20
            //   56                   | push                esi
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   8d45e0               | lea                 eax, [ebp - 0x20]
            //   50                   | push                eax
            //   8bf1                 | mov                 esi, ecx

    condition:
        7 of them and filesize < 1392640
}