rule win_poscardstealer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.poscardstealer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.poscardstealer"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d85f4fdffff 50 57 e8???????? 33c9 8d85f4fdffff c785ecedffff07000000 }
            // n = 7, score = 200
            //   8d85f4fdffff         | lea                 eax, [ebp - 0x20c]
            //   50                   | push                eax
            //   57                   | push                edi
            //   e8????????           |                     
            //   33c9                 | xor                 ecx, ecx
            //   8d85f4fdffff         | lea                 eax, [ebp - 0x20c]
            //   c785ecedffff07000000     | mov    dword ptr [ebp - 0x1214], 7

        $sequence_1 = { 56 8d45d4 50 8d4db8 e8???????? 6a01 }
            // n = 6, score = 200
            //   56                   | push                esi
            //   8d45d4               | lea                 eax, [ebp - 0x2c]
            //   50                   | push                eax
            //   8d4db8               | lea                 ecx, [ebp - 0x48]
            //   e8????????           |                     
            //   6a01                 | push                1

        $sequence_2 = { c645fc00 3bf7 7409 56 e8???????? }
            // n = 5, score = 200
            //   c645fc00             | mov                 byte ptr [ebp - 4], 0
            //   3bf7                 | cmp                 esi, edi
            //   7409                 | je                  0xb
            //   56                   | push                esi
            //   e8????????           |                     

        $sequence_3 = { e8???????? 83c404 8b45d4 397de8 7303 8d45d4 8b4de4 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8b45d4               | mov                 eax, dword ptr [ebp - 0x2c]
            //   397de8               | cmp                 dword ptr [ebp - 0x18], edi
            //   7303                 | jae                 5
            //   8d45d4               | lea                 eax, [ebp - 0x2c]
            //   8b4de4               | mov                 ecx, dword ptr [ebp - 0x1c]

        $sequence_4 = { 8bb580edffff 2bb57cedffff c1fe02 3bfe 7426 8b857cedffff 8d14b500000000 }
            // n = 7, score = 200
            //   8bb580edffff         | mov                 esi, dword ptr [ebp - 0x1280]
            //   2bb57cedffff         | sub                 esi, dword ptr [ebp - 0x1284]
            //   c1fe02               | sar                 esi, 2
            //   3bfe                 | cmp                 edi, esi
            //   7426                 | je                  0x28
            //   8b857cedffff         | mov                 eax, dword ptr [ebp - 0x1284]
            //   8d14b500000000       | lea                 edx, [esi*4]

        $sequence_5 = { 837d1c10 c745e80f000000 c745e400000000 c645d400 720c 8b4d08 51 }
            // n = 7, score = 200
            //   837d1c10             | cmp                 dword ptr [ebp + 0x1c], 0x10
            //   c745e80f000000       | mov                 dword ptr [ebp - 0x18], 0xf
            //   c745e400000000       | mov                 dword ptr [ebp - 0x1c], 0
            //   c645d400             | mov                 byte ptr [ebp - 0x2c], 0
            //   720c                 | jb                  0xe
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   51                   | push                ecx

        $sequence_6 = { 89430c 8d4310 8d896c614200 5a 668b31 668930 }
            // n = 6, score = 200
            //   89430c               | mov                 dword ptr [ebx + 0xc], eax
            //   8d4310               | lea                 eax, [ebx + 0x10]
            //   8d896c614200         | lea                 ecx, [ecx + 0x42616c]
            //   5a                   | pop                 edx
            //   668b31               | mov                 si, word ptr [ecx]
            //   668930               | mov                 word ptr [eax], si

        $sequence_7 = { 8d8d48ffffff e8???????? 898544ffffff 83f8ff 746f 6aff 50 }
            // n = 7, score = 200
            //   8d8d48ffffff         | lea                 ecx, [ebp - 0xb8]
            //   e8????????           |                     
            //   898544ffffff         | mov                 dword ptr [ebp - 0xbc], eax
            //   83f8ff               | cmp                 eax, -1
            //   746f                 | je                  0x71
            //   6aff                 | push                -1
            //   50                   | push                eax

        $sequence_8 = { 66898dd8edffff 837e1408 731c 8b5610 }
            // n = 4, score = 200
            //   66898dd8edffff       | mov                 word ptr [ebp - 0x1228], cx
            //   837e1408             | cmp                 dword ptr [esi + 0x14], 8
            //   731c                 | jae                 0x1e
            //   8b5610               | mov                 edx, dword ptr [esi + 0x10]

        $sequence_9 = { e8???????? 6a01 53 68???????? 8d4d9c c645fc03 e8???????? }
            // n = 7, score = 200
            //   e8????????           |                     
            //   6a01                 | push                1
            //   53                   | push                ebx
            //   68????????           |                     
            //   8d4d9c               | lea                 ecx, [ebp - 0x64]
            //   c645fc03             | mov                 byte ptr [ebp - 4], 3
            //   e8????????           |                     

    condition:
        7 of them and filesize < 362496
}