rule win_powerloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.powerloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.powerloader"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33d2 ff15???????? 83f81f 7323 }
            // n = 4, score = 300
            //   33d2                 | dec                 eax
            //   ff15????????         |                     
            //   83f81f               | lea                 edx, [0x1ad7]
            //   7323                 | inc                 ebp

        $sequence_1 = { e8???????? eb22 33c9 66666666660f1f840000000000 }
            // n = 4, score = 300
            //   e8????????           |                     
            //   eb22                 | mov                 ebx, ecx
            //   33c9                 | dec                 eax
            //   66666666660f1f840000000000     | lea    edx, [0x2cc2]

        $sequence_2 = { 8bf2 32db e8???????? 3bc7 7349 }
            // n = 5, score = 300
            //   8bf2                 | mov                 dword ptr [esp + 0x28], eax
            //   32db                 | mov                 eax, dword ptr [ebx]
            //   e8????????           |                     
            //   3bc7                 | dec                 ecx
            //   7349                 | lea                 edx, [ebp - 1]

        $sequence_3 = { 7441 8b5c2430 85db 741d }
            // n = 4, score = 300
            //   7441                 | lea                 ecx, [esp + 0x130]
            //   8b5c2430             | test                al, al
            //   85db                 | je                  0x1e0
            //   741d                 | dec                 eax

        $sequence_4 = { 32db e8???????? 3bc7 7349 }
            // n = 4, score = 300
            //   32db                 | test                al, al
            //   e8????????           |                     
            //   3bc7                 | jne                 0x61
            //   7349                 | dec                 eax

        $sequence_5 = { e8???????? 0fb6d8 84c0 7514 }
            // n = 4, score = 300
            //   e8????????           |                     
            //   0fb6d8               | je                  0x52
            //   84c0                 | mov                 bl, al
            //   7514                 | test                bl, bl

        $sequence_6 = { ff15???????? 83f81f 7323 ff15???????? }
            // n = 4, score = 300
            //   ff15????????         |                     
            //   83f81f               | lea                 ecx, [esp + 0x40]
            //   7323                 | dec                 eax
            //   ff15????????         |                     

        $sequence_7 = { e8???????? 0fb6d8 85ff 740c }
            // n = 4, score = 300
            //   e8????????           |                     
            //   0fb6d8               | jne                 0x5e
            //   85ff                 | mov                 bl, al
            //   740c                 | test                bl, bl

        $sequence_8 = { e8???????? 0fb6d8 84c0 7514 ff15???????? }
            // n = 5, score = 300
            //   e8????????           |                     
            //   0fb6d8               | pop                 ebx
            //   84c0                 | mov                 esp, ebp
            //   7514                 | je                  0xc3
            //   ff15????????         |                     

        $sequence_9 = { 33d2 c605????????00 e8???????? 0fb6c3 }
            // n = 4, score = 300
            //   33d2                 | dec                 eax
            //   c605????????00       |                     
            //   e8????????           |                     
            //   0fb6c3               | mov                 dword ptr [esp + 0x30], eax

    condition:
        7 of them and filesize < 155648
}