rule win_prikormka_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.prikormka."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.prikormka"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d0446 50 e8???????? 83c40c 6a00 56 }
            // n = 6, score = 1600
            //   8d0446               | lea                 eax, [esi + eax*2]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   6a00                 | push                0
            //   56                   | push                esi

        $sequence_1 = { 8b2d???????? 85c0 7405 6a02 56 ffd5 }
            // n = 6, score = 1400
            //   8b2d????????         |                     
            //   85c0                 | test                eax, eax
            //   7405                 | je                  7
            //   6a02                 | push                2
            //   56                   | push                esi
            //   ffd5                 | call                ebp

        $sequence_2 = { 8d1446 52 e8???????? 83c40c }
            // n = 4, score = 1400
            //   8d1446               | lea                 edx, [esi + eax*2]
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_3 = { 7420 68???????? ffd7 03c0 50 }
            // n = 5, score = 1400
            //   7420                 | je                  0x22
            //   68????????           |                     
            //   ffd7                 | call                edi
            //   03c0                 | add                 eax, eax
            //   50                   | push                eax

        $sequence_4 = { e8???????? 8b1d???????? 83c40c 6a00 56 ffd3 }
            // n = 6, score = 1400
            //   e8????????           |                     
            //   8b1d????????         |                     
            //   83c40c               | add                 esp, 0xc
            //   6a00                 | push                0
            //   56                   | push                esi
            //   ffd3                 | call                ebx

        $sequence_5 = { 6800020000 ff15???????? 68???????? ffd7 }
            // n = 4, score = 1400
            //   6800020000           | push                0x200
            //   ff15????????         |                     
            //   68????????           |                     
            //   ffd7                 | call                edi

        $sequence_6 = { 56 ffd3 85c0 7405 6a02 }
            // n = 5, score = 1400
            //   56                   | push                esi
            //   ffd3                 | call                ebx
            //   85c0                 | test                eax, eax
            //   7405                 | je                  7
            //   6a02                 | push                2

        $sequence_7 = { 85c0 740e 68???????? 50 ff15???????? ffd0 }
            // n = 6, score = 1400
            //   85c0                 | test                eax, eax
            //   740e                 | je                  0x10
            //   68????????           |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   ffd0                 | call                eax

        $sequence_8 = { 6a00 ff15???????? 85c0 7502 59 }
            // n = 5, score = 1000
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7502                 | jne                 4
            //   59                   | pop                 ecx

        $sequence_9 = { 7502 59 c3 50 ff15???????? }
            // n = 5, score = 1000
            //   7502                 | jne                 4
            //   59                   | pop                 ecx
            //   c3                   | ret                 
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_10 = { 7408 41 42 3bce }
            // n = 4, score = 1000
            //   7408                 | je                  0xa
            //   41                   | inc                 ecx
            //   42                   | inc                 edx
            //   3bce                 | cmp                 ecx, esi

        $sequence_11 = { 83c40c 8d442404 50 ff15???????? 5e 85c0 }
            // n = 6, score = 1000
            //   83c40c               | add                 esp, 0xc
            //   8d442404             | lea                 eax, [esp + 4]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   5e                   | pop                 esi
            //   85c0                 | test                eax, eax

        $sequence_12 = { ff15???????? 0fb7c0 6683f805 7d09 b801000000 }
            // n = 5, score = 900
            //   ff15????????         |                     
            //   0fb7c0               | movzx               eax, ax
            //   6683f805             | cmp                 ax, 5
            //   7d09                 | jge                 0xb
            //   b801000000           | mov                 eax, 1

        $sequence_13 = { c3 57 6a00 6a00 6a00 6a02 }
            // n = 6, score = 900
            //   c3                   | ret                 
            //   57                   | push                edi
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a02                 | push                2

        $sequence_14 = { 83ec08 68???????? ff15???????? 0fb7c0 }
            // n = 4, score = 900
            //   83ec08               | sub                 esp, 8
            //   68????????           |                     
            //   ff15????????         |                     
            //   0fb7c0               | movzx               eax, ax

        $sequence_15 = { ff15???????? ffd0 c705????????01000000 c705????????01000000 }
            // n = 4, score = 900
            //   ff15????????         |                     
            //   ffd0                 | call                eax
            //   c705????????01000000     |     
            //   c705????????01000000     |     

        $sequence_16 = { 5e 85c0 7414 c705????????01000000 }
            // n = 4, score = 700
            //   5e                   | pop                 esi
            //   85c0                 | test                eax, eax
            //   7414                 | je                  0x16
            //   c705????????01000000     |     

        $sequence_17 = { 3db7000000 750e 56 ff15???????? 33c0 5e }
            // n = 6, score = 700
            //   3db7000000           | cmp                 eax, 0xb7
            //   750e                 | jne                 0x10
            //   56                   | push                esi
            //   ff15????????         |                     
            //   33c0                 | xor                 eax, eax
            //   5e                   | pop                 esi

        $sequence_18 = { 6a00 6a00 ff15???????? 8bf0 ff15???????? 3db7000000 750e }
            // n = 7, score = 700
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   ff15????????         |                     
            //   3db7000000           | cmp                 eax, 0xb7
            //   750e                 | jne                 0x10

        $sequence_19 = { 8b0d???????? 2bc2 8b15???????? d1f8 }
            // n = 4, score = 600
            //   8b0d????????         |                     
            //   2bc2                 | sub                 eax, edx
            //   8b15????????         |                     
            //   d1f8                 | sar                 eax, 1

        $sequence_20 = { 6685d2 75f5 2bce 8d1400 }
            // n = 4, score = 600
            //   6685d2               | test                dx, dx
            //   75f5                 | jne                 0xfffffff7
            //   2bce                 | sub                 ecx, esi
            //   8d1400               | lea                 edx, [eax + eax]

        $sequence_21 = { 2bce 8d1400 52 d1f9 }
            // n = 4, score = 600
            //   2bce                 | sub                 ecx, esi
            //   8d1400               | lea                 edx, [eax + eax]
            //   52                   | push                edx
            //   d1f9                 | sar                 ecx, 1

        $sequence_22 = { d1f8 8d7102 8da42400000000 668b11 83c102 6685d2 }
            // n = 6, score = 500
            //   d1f8                 | sar                 eax, 1
            //   8d7102               | lea                 esi, [ecx + 2]
            //   8da42400000000       | lea                 esp, [esp]
            //   668b11               | mov                 dx, word ptr [ecx]
            //   83c102               | add                 ecx, 2
            //   6685d2               | test                dx, dx

        $sequence_23 = { 8b35???????? 83c40c 68???????? ffd6 03c0 }
            // n = 5, score = 500
            //   8b35????????         |                     
            //   83c40c               | add                 esp, 0xc
            //   68????????           |                     
            //   ffd6                 | call                esi
            //   03c0                 | add                 eax, eax

        $sequence_24 = { 83c002 6685c9 75f5 2bc6 8d0c12 51 d1f8 }
            // n = 7, score = 500
            //   83c002               | add                 eax, 2
            //   6685c9               | test                cx, cx
            //   75f5                 | jne                 0xfffffff7
            //   2bc6                 | sub                 eax, esi
            //   8d0c12               | lea                 ecx, [edx + edx]
            //   51                   | push                ecx
            //   d1f8                 | sar                 eax, 1

        $sequence_25 = { 50 e8???????? b8???????? 83c40c 8d5002 }
            // n = 5, score = 500
            //   50                   | push                eax
            //   e8????????           |                     
            //   b8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8d5002               | lea                 edx, [eax + 2]

        $sequence_26 = { 85c0 7409 6a02 68???????? }
            // n = 4, score = 400
            //   85c0                 | test                eax, eax
            //   7409                 | je                  0xb
            //   6a02                 | push                2
            //   68????????           |                     

        $sequence_27 = { 83c40c 8d5002 668b08 83c002 6685c9 75f5 8b0d???????? }
            // n = 7, score = 400
            //   83c40c               | add                 esp, 0xc
            //   8d5002               | lea                 edx, [eax + 2]
            //   668b08               | mov                 cx, word ptr [eax]
            //   83c002               | add                 eax, 2
            //   6685c9               | test                cx, cx
            //   75f5                 | jne                 0xfffffff7
            //   8b0d????????         |                     

        $sequence_28 = { 75f5 2bc6 03d2 52 }
            // n = 4, score = 300
            //   75f5                 | jne                 0xfffffff7
            //   2bc6                 | sub                 eax, esi
            //   03d2                 | add                 edx, edx
            //   52                   | push                edx

        $sequence_29 = { 56 57 68???????? 33ff 57 57 ff15???????? }
            // n = 7, score = 300
            //   56                   | push                esi
            //   57                   | push                edi
            //   68????????           |                     
            //   33ff                 | xor                 edi, edi
            //   57                   | push                edi
            //   57                   | push                edi
            //   ff15????????         |                     

        $sequence_30 = { e8???????? 83c40c eb0d 6a00 6800020000 }
            // n = 5, score = 300
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   eb0d                 | jmp                 0xf
            //   6a00                 | push                0
            //   6800020000           | push                0x200

        $sequence_31 = { 50 68???????? 57 ffd6 03c7 50 }
            // n = 6, score = 300
            //   50                   | push                eax
            //   68????????           |                     
            //   57                   | push                edi
            //   ffd6                 | call                esi
            //   03c7                 | add                 eax, edi
            //   50                   | push                eax

        $sequence_32 = { 50 ff15???????? 0fb74c2416 0fb7542414 }
            // n = 4, score = 300
            //   50                   | push                eax
            //   ff15????????         |                     
            //   0fb74c2416           | movzx               ecx, word ptr [esp + 0x16]
            //   0fb7542414           | movzx               edx, word ptr [esp + 0x14]

        $sequence_33 = { 6685d2 75f5 8d1400 2bce 52 }
            // n = 5, score = 300
            //   6685d2               | test                dx, dx
            //   75f5                 | jne                 0xfffffff7
            //   8d1400               | lea                 edx, [eax + eax]
            //   2bce                 | sub                 ecx, esi
            //   52                   | push                edx

        $sequence_34 = { 6685c9 75f5 2bc2 d1f8 8bd0 b8???????? }
            // n = 6, score = 300
            //   6685c9               | test                cx, cx
            //   75f5                 | jne                 0xfffffff7
            //   2bc2                 | sub                 eax, edx
            //   d1f8                 | sar                 eax, 1
            //   8bd0                 | mov                 edx, eax
            //   b8????????           |                     

        $sequence_35 = { 6685c9 75f5 2bc2 b9???????? d1f8 8d7102 }
            // n = 6, score = 300
            //   6685c9               | test                cx, cx
            //   75f5                 | jne                 0xfffffff7
            //   2bc2                 | sub                 eax, edx
            //   b9????????           |                     
            //   d1f8                 | sar                 eax, 1
            //   8d7102               | lea                 esi, [ecx + 2]

        $sequence_36 = { b9???????? d1f8 8d7102 668b11 83c102 6685d2 75f5 }
            // n = 7, score = 300
            //   b9????????           |                     
            //   d1f8                 | sar                 eax, 1
            //   8d7102               | lea                 esi, [ecx + 2]
            //   668b11               | mov                 dx, word ptr [ecx]
            //   83c102               | add                 ecx, 2
            //   6685d2               | test                dx, dx
            //   75f5                 | jne                 0xfffffff7

        $sequence_37 = { 8b3d???????? 85f6 7420 68???????? }
            // n = 4, score = 300
            //   8b3d????????         |                     
            //   85f6                 | test                esi, esi
            //   7420                 | je                  0x22
            //   68????????           |                     

        $sequence_38 = { b8???????? 8d7002 8da42400000000 668b08 83c002 }
            // n = 5, score = 300
            //   b8????????           |                     
            //   8d7002               | lea                 esi, [eax + 2]
            //   8da42400000000       | lea                 esp, [esp]
            //   668b08               | mov                 cx, word ptr [eax]
            //   83c002               | add                 eax, 2

        $sequence_39 = { 8b1d???????? 83c40c 6a00 68???????? ffd3 8b3d???????? 85c0 }
            // n = 7, score = 200
            //   8b1d????????         |                     
            //   83c40c               | add                 esp, 0xc
            //   6a00                 | push                0
            //   68????????           |                     
            //   ffd3                 | call                ebx
            //   8b3d????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_40 = { 52 ff7504 57 50 }
            // n = 4, score = 100
            //   52                   | push                edx
            //   ff7504               | push                dword ptr [ebp + 4]
            //   57                   | push                edi
            //   50                   | push                eax

        $sequence_41 = { 68???????? 57 ff16 8bf0 3bf3 0f8c5a020000 }
            // n = 6, score = 100
            //   68????????           |                     
            //   57                   | push                edi
            //   ff16                 | call                dword ptr [esi]
            //   8bf0                 | mov                 esi, eax
            //   3bf3                 | cmp                 esi, ebx
            //   0f8c5a020000         | jl                  0x260

        $sequence_42 = { 8bc6 5e c3 56 6a5c ff74240c }
            // n = 6, score = 100
            //   8bc6                 | mov                 eax, esi
            //   5e                   | pop                 esi
            //   c3                   | ret                 
            //   56                   | push                esi
            //   6a5c                 | push                0x5c
            //   ff74240c             | push                dword ptr [esp + 0xc]

        $sequence_43 = { 395de8 7512 ff35???????? ff15???????? 891d???????? 8b4dfc 8b45e8 }
            // n = 7, score = 100
            //   395de8               | cmp                 dword ptr [ebp - 0x18], ebx
            //   7512                 | jne                 0x14
            //   ff35????????         |                     
            //   ff15????????         |                     
            //   891d????????         |                     
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]

        $sequence_44 = { 57 894594 894d98 3b450c 0f84ba000000 }
            // n = 5, score = 100
            //   57                   | push                edi
            //   894594               | mov                 dword ptr [ebp - 0x6c], eax
            //   894d98               | mov                 dword ptr [ebp - 0x68], ecx
            //   3b450c               | cmp                 eax, dword ptr [ebp + 0xc]
            //   0f84ba000000         | je                  0xc0

        $sequence_45 = { c1e606 03348520100210 c745e401000000 33db 395e08 7536 }
            // n = 6, score = 100
            //   c1e606               | shl                 esi, 6
            //   03348520100210       | add                 esi, dword ptr [eax*4 + 0x10021020]
            //   c745e401000000       | mov                 dword ptr [ebp - 0x1c], 1
            //   33db                 | xor                 ebx, ebx
            //   395e08               | cmp                 dword ptr [esi + 8], ebx
            //   7536                 | jne                 0x38

    condition:
        7 of them and filesize < 401408
}