rule win_privateloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.privateloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.privateloader"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8945e4 8b4d08 51 0fbe550c }
            // n = 4, score = 600
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   51                   | push                ecx
            //   0fbe550c             | movsx               edx, byte ptr [ebp + 0xc]

        $sequence_1 = { 66894c5002 eb19 33d2 8855ff 0fb74508 50 0fb64dff }
            // n = 7, score = 600
            //   66894c5002           | mov                 word ptr [eax + edx*2 + 2], cx
            //   eb19                 | jmp                 0x1b
            //   33d2                 | xor                 edx, edx
            //   8855ff               | mov                 byte ptr [ebp - 1], dl
            //   0fb74508             | movzx               eax, word ptr [ebp + 8]
            //   50                   | push                eax
            //   0fb64dff             | movzx               ecx, byte ptr [ebp - 1]

        $sequence_2 = { 8b4dfc c7417c50000000 eb3c 837d080b }
            // n = 4, score = 600
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   c7417c50000000       | mov                 dword ptr [ecx + 0x7c], 0x50
            //   eb3c                 | jmp                 0x3e
            //   837d080b             | cmp                 dword ptr [ebp + 8], 0xb

        $sequence_3 = { 894de0 8b45e0 8945e8 8b4de8 8b5110 8955ec 8b4de0 }
            // n = 7, score = 600
            //   894de0               | mov                 dword ptr [ebp - 0x20], ecx
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   8b4de8               | mov                 ecx, dword ptr [ebp - 0x18]
            //   8b5110               | mov                 edx, dword ptr [ecx + 0x10]
            //   8955ec               | mov                 dword ptr [ebp - 0x14], edx
            //   8b4de0               | mov                 ecx, dword ptr [ebp - 0x20]

        $sequence_4 = { 894de0 8b5508 8955fc 8b45fc }
            // n = 4, score = 600
            //   894de0               | mov                 dword ptr [ebp - 0x20], ecx
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   8955fc               | mov                 dword ptr [ebp - 4], edx
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]

        $sequence_5 = { 8b45d8 8b4ddc 8b55d0 8b75d4 }
            // n = 4, score = 600
            //   8b45d8               | mov                 eax, dword ptr [ebp - 0x28]
            //   8b4ddc               | mov                 ecx, dword ptr [ebp - 0x24]
            //   8b55d0               | mov                 edx, dword ptr [ebp - 0x30]
            //   8b75d4               | mov                 esi, dword ptr [ebp - 0x2c]

        $sequence_6 = { 894de0 8b55e0 8955dc 8b45f0 }
            // n = 4, score = 600
            //   894de0               | mov                 dword ptr [ebp - 0x20], ecx
            //   8b55e0               | mov                 edx, dword ptr [ebp - 0x20]
            //   8955dc               | mov                 dword ptr [ebp - 0x24], edx
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]

        $sequence_7 = { 8b4210 2b4508 8945f4 8b4df4 }
            // n = 4, score = 600
            //   8b4210               | mov                 eax, dword ptr [edx + 0x10]
            //   2b4508               | sub                 eax, dword ptr [ebp + 8]
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]

        $sequence_8 = { e8???????? 33d2 b93f000000 f7f1 }
            // n = 4, score = 500
            //   e8????????           |                     
            //   33d2                 | xor                 edx, edx
            //   b93f000000           | mov                 ecx, 0x3f
            //   f7f1                 | div                 ecx

        $sequence_9 = { 896c2404 8bec 81ec68010000 a1???????? 33c5 8945fc 56 }
            // n = 7, score = 400
            //   896c2404             | mov                 dword ptr [esp + 4], ebp
            //   8bec                 | mov                 ebp, esp
            //   81ec68010000         | sub                 esp, 0x168
            //   a1????????           |                     
            //   33c5                 | xor                 eax, ebp
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   56                   | push                esi

        $sequence_10 = { 8b4590 8b4d94 8b5588 8b758c }
            // n = 4, score = 400
            //   8b4590               | mov                 eax, dword ptr [ebp - 0x70]
            //   8b4d94               | mov                 ecx, dword ptr [ebp - 0x6c]
            //   8b5588               | mov                 edx, dword ptr [ebp - 0x78]
            //   8b758c               | mov                 esi, dword ptr [ebp - 0x74]

        $sequence_11 = { e8???????? 6bc007 33c9 41 c1e102 }
            // n = 5, score = 400
            //   e8????????           |                     
            //   6bc007               | imul                eax, eax, 7
            //   33c9                 | xor                 ecx, ecx
            //   41                   | inc                 ecx
            //   c1e102               | shl                 ecx, 2

        $sequence_12 = { 56 ff15???????? a3???????? 33c0 5e c3 3b0d???????? }
            // n = 7, score = 400
            //   56                   | push                esi
            //   ff15????????         |                     
            //   a3????????           |                     
            //   33c0                 | xor                 eax, eax
            //   5e                   | pop                 esi
            //   c3                   | ret                 
            //   3b0d????????         |                     

        $sequence_13 = { c9 b8ffffffff 99 c3 56 8b35???????? 8bce }
            // n = 7, score = 400
            //   c9                   | leave               
            //   b8ffffffff           | mov                 eax, 0xffffffff
            //   99                   | cdq                 
            //   c3                   | ret                 
            //   56                   | push                esi
            //   8b35????????         |                     
            //   8bce                 | mov                 ecx, esi

        $sequence_14 = { 83c201 8955e0 83d600 8975e4 }
            // n = 4, score = 300
            //   83c201               | add                 edx, 1
            //   8955e0               | mov                 dword ptr [ebp - 0x20], edx
            //   83d600               | adc                 esi, 0
            //   8975e4               | mov                 dword ptr [ebp - 0x1c], esi

        $sequence_15 = { 51 6a00 6813000020 50 }
            // n = 4, score = 300
            //   51                   | push                ecx
            //   6a00                 | push                0
            //   6813000020           | push                0x20000013
            //   50                   | push                eax

        $sequence_16 = { 8b45e4 50 51 52 }
            // n = 4, score = 300
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]
            //   50                   | push                eax
            //   51                   | push                ecx
            //   52                   | push                edx

        $sequence_17 = { 0bc8 56 57 7529 }
            // n = 4, score = 300
            //   0bc8                 | or                  ecx, eax
            //   56                   | push                esi
            //   57                   | push                edi
            //   7529                 | jne                 0x2b

        $sequence_18 = { 8bf0 e8???????? 8bc8 8bfa 8bc6 }
            // n = 5, score = 300
            //   8bf0                 | mov                 esi, eax
            //   e8????????           |                     
            //   8bc8                 | mov                 ecx, eax
            //   8bfa                 | mov                 edi, edx
            //   8bc6                 | mov                 eax, esi

    condition:
        7 of them and filesize < 3670016
}