rule win_proto8_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.proto8_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.proto8_rat"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4730 452bf7 412bc1 452bf4 443bf0 458bee 440f43e8 }
            // n = 7, score = 100
            //   8b4730               | dec                 eax
            //   452bf7               | mov                 dword ptr [eax + 0x3d0], edi
            //   412bc1               | mov                 dword ptr [eax + 0x3d8], edi
            //   452bf4               | mov                 dword ptr [eax + 0xb8], edi
            //   443bf0               | dec                 eax
            //   458bee               | mov                 dword ptr [eax + 0xc0], edi
            //   440f43e8             | mov                 dword ptr [eax + 0xc8], edi

        $sequence_1 = { 7454 488b0b 4885c9 742b 488b8100020000 48c70000000000 b801000000 }
            // n = 7, score = 100
            //   7454                 | mov                 edx, dword ptr [esi + 0x38]
            //   488b0b               | je                  0xc60
            //   4885c9               | dec                 eax
            //   742b                 | mov                 edx, dword ptr [esi + 0x18]
            //   488b8100020000       | dec                 edx
            //   48c70000000000       | mov                 eax, dword ptr [edx + esi*8 + 8]
            //   b801000000           | dec                 eax

        $sequence_2 = { 488d4c2458 493bfd 480f43cb 4c8bc6 4c3bf6 4d0f42c6 e8???????? }
            // n = 7, score = 100
            //   488d4c2458           | dec                 eax
            //   493bfd               | mov                 edx, dword ptr [esp + 0x20]
            //   480f43cb             | dec                 eax
            //   4c8bc6               | add                 edx, 0x20
            //   4c3bf6               | dec                 eax
            //   4d0f42c6             | lea                 ecx, [0x214fa]
            //   e8????????           |                     

        $sequence_3 = { c744243001000000 488b7308 488b2b 48c744242002000000 4c8d0de0db0500 488bd6 488bcd }
            // n = 7, score = 100
            //   c744243001000000     | mov                 ecx, 1
            //   488b7308             | inc                 ebp
            //   488b2b               | xor                 eax, eax
            //   48c744242002000000     | xor    edx, edx
            //   4c8d0de0db0500       | dec                 eax
            //   488bd6               | lea                 ecx, [ebp + 0x7f]
            //   488bcd               | test                eax, eax

        $sequence_4 = { 75b3 448b542430 4183f873 0f8400feffff 488b4c2470 ffc3 413bda }
            // n = 7, score = 100
            //   75b3                 | mov                 ecx, dword ptr [ebx + 8]
            //   448b542430           | dec                 eax
            //   4183f873             | lea                 edx, [esp + 0x30]
            //   0f8400feffff         | dec                 eax
            //   488b4c2470           | add                 ecx, 0x60
            //   ffc3                 | jne                 0x12d
            //   413bda               | dec                 eax

        $sequence_5 = { f6c314 7424 c1eb02 450fb6ce 80e301 4c8bc6 488bd7 }
            // n = 7, score = 100
            //   f6c314               | dec                 ecx
            //   7424                 | cmp                 edx, ebp
            //   c1eb02               | jb                  0x161
            //   450fb6ce             | dec                 eax
            //   80e301               | inc                 edx
            //   4c8bc6               | dec                 eax
            //   488bd7               | mov                 ecx, dword ptr [esp + 0x60]

        $sequence_6 = { 83f803 0f85cd000000 4584ed 751c 8d43ff 443bd8 7407 }
            // n = 7, score = 100
            //   83f803               | je                  0x61c
            //   0f85cd000000         | sub                 eax, 1
            //   4584ed               | je                  0x60a
            //   751c                 | sub                 eax, 1
            //   8d43ff               | je                  0x600
            //   443bd8               | xor                 al, al
            //   7407                 | sub                 eax, 1

        $sequence_7 = { 894310 4585f6 7510 418d7e01 448bfe 89bc24b8000000 eb12 }
            // n = 7, score = 100
            //   894310               | jmp                 0x4b3
            //   4585f6               | movzx               eax, byte ptr [ebx + 0x28]
            //   7510                 | mov                 byte ptr [edi], al
            //   418d7e01             | mov                 dword ptr [eax], ecx
            //   448bfe               | mov                 eax, dword ptr [ebx + 0x270]
            //   89bc24b8000000       | cmp                 eax, 1
            //   eb12                 | jle                 0x509

        $sequence_8 = { e8???????? 85c0 750a c744242804000000 eb14 89442420 c744242401000000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   85c0                 | dec                 esp
            //   750a                 | lea                 eax, [ebp - 0x28]
            //   c744242804000000     | dec                 eax
            //   eb14                 | lea                 edx, [0x3a91]
            //   89442420             | dec                 eax
            //   c744242401000000     | lea                 eax, [0x1f456]

        $sequence_9 = { 48c744243800000000 4c8bc8 48894c2430 4c8bc7 488d4c2460 48894c2428 33c9 }
            // n = 7, score = 100
            //   48c744243800000000     | dec    eax
            //   4c8bc8               | lea                 ecx, [ebp - 0x31]
            //   48894c2430           | inc                 esp
            //   4c8bc7               | mov                 eax, dword ptr [esi + 0xd0]
            //   488d4c2460           | dec                 eax
            //   48894c2428           | lea                 ecx, [ebp - 0x31]
            //   33c9                 | dec                 eax

    condition:
        7 of them and filesize < 2537472
}