rule win_protonbot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.protonbot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.protonbot"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bc6 8b8c24b4010000 5e 33cc }
            // n = 4, score = 400
            //   8bc6                 | mov                 eax, esi
            //   8b8c24b4010000       | mov                 ecx, dword ptr [esp + 0x1b4]
            //   5e                   | pop                 esi
            //   33cc                 | xor                 ecx, esp

        $sequence_1 = { 8b00 a3???????? 8d4520 0f434520 50 e8???????? 83c404 }
            // n = 7, score = 400
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   a3????????           |                     
            //   8d4520               | lea                 eax, [ebp + 0x20]
            //   0f434520             | cmovae              eax, dword ptr [ebp + 0x20]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

        $sequence_2 = { 83c404 8b07 ffd0 e8???????? 6a04 57 }
            // n = 6, score = 400
            //   83c404               | add                 esp, 4
            //   8b07                 | mov                 eax, dword ptr [edi]
            //   ffd0                 | call                eax
            //   e8????????           |                     
            //   6a04                 | push                4
            //   57                   | push                edi

        $sequence_3 = { 0f434520 50 e8???????? 83c404 50 }
            // n = 5, score = 400
            //   0f434520             | cmovae              eax, dword ptr [ebp + 0x20]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   50                   | push                eax

        $sequence_4 = { 8d85d8feffff 0f4385d8feffff 50 8d85f0feffff }
            // n = 4, score = 400
            //   8d85d8feffff         | lea                 eax, [ebp - 0x128]
            //   0f4385d8feffff       | cmovae              eax, dword ptr [ebp - 0x128]
            //   50                   | push                eax
            //   8d85f0feffff         | lea                 eax, [ebp - 0x110]

        $sequence_5 = { 6804010000 8d85ecfeffff c645fc02 50 6a00 ff15???????? 8d8decfeffff }
            // n = 7, score = 400
            //   6804010000           | push                0x104
            //   8d85ecfeffff         | lea                 eax, [ebp - 0x114]
            //   c645fc02             | mov                 byte ptr [ebp - 4], 2
            //   50                   | push                eax
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   8d8decfeffff         | lea                 ecx, [ebp - 0x114]

        $sequence_6 = { 899df8fffeff e8???????? 83c410 8bf8 89bdf4fffeff }
            // n = 5, score = 400
            //   899df8fffeff         | mov                 dword ptr [ebp - 0x10008], ebx
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   8bf8                 | mov                 edi, eax
            //   89bdf4fffeff         | mov                 dword ptr [ebp - 0x1000c], edi

        $sequence_7 = { 8d85bcfeffff 83bdd0feffff10 8d8da4feffff 0f4385bcfeffff }
            // n = 4, score = 400
            //   8d85bcfeffff         | lea                 eax, [ebp - 0x144]
            //   83bdd0feffff10       | cmp                 dword ptr [ebp - 0x130], 0x10
            //   8d8da4feffff         | lea                 ecx, [ebp - 0x15c]
            //   0f4385bcfeffff       | cmovae              eax, dword ptr [ebp - 0x144]

        $sequence_8 = { a1???????? 33c4 898424b0010000 56 6a00 8d44240c }
            // n = 6, score = 400
            //   a1????????           |                     
            //   33c4                 | xor                 eax, esp
            //   898424b0010000       | mov                 dword ptr [esp + 0x1b0], eax
            //   56                   | push                esi
            //   6a00                 | push                0
            //   8d44240c             | lea                 eax, [esp + 0xc]

        $sequence_9 = { 56 8b35???????? ffd6 ffb5c0f7ffff ffd6 }
            // n = 5, score = 400
            //   56                   | push                esi
            //   8b35????????         |                     
            //   ffd6                 | call                esi
            //   ffb5c0f7ffff         | push                dword ptr [ebp - 0x840]
            //   ffd6                 | call                esi

    condition:
        7 of them and filesize < 1073152
}