rule win_pushdo_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.pushdo."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.pushdo"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 ff15???????? 33d2 b9ffff0000 }
            // n = 4, score = 1300
            //   50                   | push                eax
            //   ff15????????         |                     
            //   33d2                 | xor                 edx, edx
            //   b9ffff0000           | mov                 ecx, 0xffff

        $sequence_1 = { f7f9 33c9 ba88020000 f7e2 0f90c1 f7d9 }
            // n = 6, score = 1300
            //   f7f9                 | idiv                ecx
            //   33c9                 | xor                 ecx, ecx
            //   ba88020000           | mov                 edx, 0x288
            //   f7e2                 | mul                 edx
            //   0f90c1               | seto                cl
            //   f7d9                 | neg                 ecx

        $sequence_2 = { 8b45fc b10b d3c0 61 }
            // n = 4, score = 1200
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   b10b                 | mov                 cl, 0xb
            //   d3c0                 | rol                 eax, cl
            //   61                   | popal               

        $sequence_3 = { 2bd0 8b4df8 83c101 894df8 81faff000000 }
            // n = 5, score = 800
            //   2bd0                 | sub                 edx, eax
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   83c101               | add                 ecx, 1
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   81faff000000         | cmp                 edx, 0xff

        $sequence_4 = { 0fbe8c0df0feffff 33d1 8b450c 0345fc }
            // n = 4, score = 800
            //   0fbe8c0df0feffff     | movsx               ecx, byte ptr [ebp + ecx - 0x110]
            //   33d1                 | xor                 edx, ecx
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   0345fc               | add                 eax, dword ptr [ebp - 4]

        $sequence_5 = { 6800010000 6a00 8d85f0feffff 50 e8???????? 83c40c 8d8df0feffff }
            // n = 7, score = 800
            //   6800010000           | push                0x100
            //   6a00                 | push                0
            //   8d85f0feffff         | lea                 eax, [ebp - 0x110]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8d8df0feffff         | lea                 ecx, [ebp - 0x110]

        $sequence_6 = { 888c15f0feffff 8b55fc 8a85effeffff 888415f0feffff eb84 c785e8feffff00000000 }
            // n = 6, score = 800
            //   888c15f0feffff       | mov                 byte ptr [ebp + edx - 0x110], cl
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   8a85effeffff         | mov                 al, byte ptr [ebp - 0x111]
            //   888415f0feffff       | mov                 byte ptr [ebp + edx - 0x110], al
            //   eb84                 | jmp                 0xffffff86
            //   c785e8feffff00000000     | mov    dword ptr [ebp - 0x118], 0

        $sequence_7 = { 8d8df0feffff 894df8 c685effeffff00 8b55f8 8d85f0feffff 2bd0 }
            // n = 6, score = 800
            //   8d8df0feffff         | lea                 ecx, [ebp - 0x110]
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   c685effeffff00       | mov                 byte ptr [ebp - 0x111], 0
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   8d85f0feffff         | lea                 eax, [ebp - 0x110]
            //   2bd0                 | sub                 edx, eax

        $sequence_8 = { 50 53 889dfcfeffff ff15???????? 48 3d02010000 7719 }
            // n = 7, score = 600
            //   50                   | push                eax
            //   53                   | push                ebx
            //   889dfcfeffff         | mov                 byte ptr [ebp - 0x104], bl
            //   ff15????????         |                     
            //   48                   | dec                 eax
            //   3d02010000           | cmp                 eax, 0x102
            //   7719                 | ja                  0x1b

        $sequence_9 = { 8d8588f8ffff 52 68???????? 50 ff15???????? }
            // n = 5, score = 600
            //   8d8588f8ffff         | lea                 eax, [ebp - 0x778]
            //   52                   | push                edx
            //   68????????           |                     
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_10 = { 5b ff75fc ff15???????? 5e 8b45f8 5f }
            // n = 6, score = 600
            //   5b                   | pop                 ebx
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   ff15????????         |                     
            //   5e                   | pop                 esi
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   5f                   | pop                 edi

        $sequence_11 = { 8b1d???????? ff7634 ff75ec ffd3 8945e8 3bc7 }
            // n = 6, score = 600
            //   8b1d????????         |                     
            //   ff7634               | push                dword ptr [esi + 0x34]
            //   ff75ec               | push                dword ptr [ebp - 0x14]
            //   ffd3                 | call                ebx
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   3bc7                 | cmp                 eax, edi

        $sequence_12 = { 7d02 33ff 8b45f0 c1e006 }
            // n = 4, score = 600
            //   7d02                 | jge                 4
            //   33ff                 | xor                 edi, edi
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   c1e006               | shl                 eax, 6

        $sequence_13 = { 52 8d8588fbffff 50 e8???????? }
            // n = 4, score = 500
            //   52                   | push                edx
            //   8d8588fbffff         | lea                 eax, [ebp - 0x478]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_14 = { 8b5508 0fb7444a02 85c0 750b }
            // n = 4, score = 200
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   0fb7444a02           | movzx               eax, word ptr [edx + ecx*2 + 2]
            //   85c0                 | test                eax, eax
            //   750b                 | jne                 0xd

        $sequence_15 = { 6a20 8d55b8 52 6a00 }
            // n = 4, score = 200
            //   6a20                 | push                0x20
            //   8d55b8               | lea                 edx, [ebp - 0x48]
            //   52                   | push                edx
            //   6a00                 | push                0

        $sequence_16 = { 8bec 8b4508 83781800 7408 8b4d08 8b4118 }
            // n = 6, score = 200
            //   8bec                 | mov                 ebp, esp
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   83781800             | cmp                 dword ptr [eax + 0x18], 0
            //   7408                 | je                  0xa
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8b4118               | mov                 eax, dword ptr [ecx + 0x18]

        $sequence_17 = { c745ec00000000 837de400 0f8e06010000 8b550c 0fbe02 }
            // n = 5, score = 200
            //   c745ec00000000       | mov                 dword ptr [ebp - 0x14], 0
            //   837de400             | cmp                 dword ptr [ebp - 0x1c], 0
            //   0f8e06010000         | jle                 0x10c
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   0fbe02               | movsx               eax, byte ptr [edx]

        $sequence_18 = { 8945d0 8b4dd0 51 ff55e8 }
            // n = 4, score = 200
            //   8945d0               | mov                 dword ptr [ebp - 0x30], eax
            //   8b4dd0               | mov                 ecx, dword ptr [ebp - 0x30]
            //   51                   | push                ecx
            //   ff55e8               | call                dword ptr [ebp - 0x18]

        $sequence_19 = { 894dfc eb83 8b5508 8b02 8945f4 }
            // n = 5, score = 200
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   eb83                 | jmp                 0xffffff85
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   8b02                 | mov                 eax, dword ptr [edx]
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax

        $sequence_20 = { 2b45fc 83f805 7307 33c0 e9???????? }
            // n = 5, score = 200
            //   2b45fc               | sub                 eax, dword ptr [ebp - 4]
            //   83f805               | cmp                 eax, 5
            //   7307                 | jae                 9
            //   33c0                 | xor                 eax, eax
            //   e9????????           |                     

    condition:
        7 of them and filesize < 163840
}