rule win_pwndlocker_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.pwndlocker."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.pwndlocker"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 75e0 5a 8b7224 01de 31c0 668b044e 8b721c }
            // n = 7, score = 300
            //   75e0                 | jne                 0xffffffe2
            //   5a                   | pop                 edx
            //   8b7224               | mov                 esi, dword ptr [edx + 0x24]
            //   01de                 | add                 esi, ebx
            //   31c0                 | xor                 eax, eax
            //   668b044e             | mov                 ax, word ptr [esi + ecx*2]
            //   8b721c               | mov                 esi, dword ptr [edx + 0x1c]

        $sequence_1 = { 8b4e18 8b5620 01da 56 e334 49 8d348a }
            // n = 7, score = 300
            //   8b4e18               | mov                 ecx, dword ptr [esi + 0x18]
            //   8b5620               | mov                 edx, dword ptr [esi + 0x20]
            //   01da                 | add                 edx, ebx
            //   56                   | push                esi
            //   e334                 | jecxz               0x36
            //   49                   | dec                 ecx
            //   8d348a               | lea                 esi, [edx + ecx*4]

        $sequence_2 = { e334 49 8d348a 8b36 }
            // n = 4, score = 300
            //   e334                 | jecxz               0x36
            //   49                   | dec                 ecx
            //   8d348a               | lea                 esi, [edx + ecx*4]
            //   8b36                 | mov                 esi, dword ptr [esi]

        $sequence_3 = { ebf4 3b7df0 75e0 5a 8b7224 }
            // n = 5, score = 300
            //   ebf4                 | jmp                 0xfffffff6
            //   3b7df0               | cmp                 edi, dword ptr [ebp - 0x10]
            //   75e0                 | jne                 0xffffffe2
            //   5a                   | pop                 edx
            //   8b7224               | mov                 esi, dword ptr [edx + 0x24]

        $sequence_4 = { 8d348a 8b36 01de 31ff 31c0 fc }
            // n = 6, score = 300
            //   8d348a               | lea                 esi, [edx + ecx*4]
            //   8b36                 | mov                 esi, dword ptr [esi]
            //   01de                 | add                 esi, ebx
            //   31ff                 | xor                 edi, edi
            //   31c0                 | xor                 eax, eax
            //   fc                   | cld                 

        $sequence_5 = { c1cf0d 01c7 ebf4 3b7df0 75e0 5a }
            // n = 6, score = 300
            //   c1cf0d               | ror                 edi, 0xd
            //   01c7                 | add                 edi, eax
            //   ebf4                 | jmp                 0xfffffff6
            //   3b7df0               | cmp                 edi, dword ptr [ebp - 0x10]
            //   75e0                 | jne                 0xffffffe2
            //   5a                   | pop                 edx

        $sequence_6 = { 7407 c1cf0d 01c7 ebf4 3b7df0 75e0 }
            // n = 6, score = 300
            //   7407                 | je                  9
            //   c1cf0d               | ror                 edi, 0xd
            //   01c7                 | add                 edi, eax
            //   ebf4                 | jmp                 0xfffffff6
            //   3b7df0               | cmp                 edi, dword ptr [ebp - 0x10]
            //   75e0                 | jne                 0xffffffe2

        $sequence_7 = { fc ac 84c0 7407 c1cf0d 01c7 ebf4 }
            // n = 7, score = 300
            //   fc                   | cld                 
            //   ac                   | lodsb               al, byte ptr [esi]
            //   84c0                 | test                al, al
            //   7407                 | je                  9
            //   c1cf0d               | ror                 edi, 0xd
            //   01c7                 | add                 edi, eax
            //   ebf4                 | jmp                 0xfffffff6

        $sequence_8 = { fc ac 84c0 7407 c1cf0d 01c7 }
            // n = 6, score = 300
            //   fc                   | cld                 
            //   ac                   | lodsb               al, byte ptr [esi]
            //   84c0                 | test                al, al
            //   7407                 | je                  9
            //   c1cf0d               | ror                 edi, 0xd
            //   01c7                 | add                 edi, eax

        $sequence_9 = { 8b7224 01de 31c0 668b044e }
            // n = 4, score = 300
            //   8b7224               | mov                 esi, dword ptr [edx + 0x24]
            //   01de                 | add                 esi, ebx
            //   31c0                 | xor                 eax, eax
            //   668b044e             | mov                 ax, word ptr [esi + ecx*2]

    condition:
        7 of them and filesize < 65536
}