rule win_qtbot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.qtbot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.qtbot"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 e8???????? 3b4508 740b }
            // n = 4, score = 200
            //   50                   | push                eax
            //   e8????????           |                     
            //   3b4508               | cmp                 eax, dword ptr [ebp + 8]
            //   740b                 | je                  0xd

        $sequence_1 = { 33c0 53 8a1a 6bc80d }
            // n = 4, score = 200
            //   33c0                 | xor                 eax, eax
            //   53                   | push                ebx
            //   8a1a                 | mov                 bl, byte ptr [edx]
            //   6bc80d               | imul                ecx, eax, 0xd

        $sequence_2 = { 85c0 742a 8b049a 03c6 }
            // n = 4, score = 200
            //   85c0                 | test                eax, eax
            //   742a                 | je                  0x2c
            //   8b049a               | mov                 eax, dword ptr [edx + ebx*4]
            //   03c6                 | add                 eax, esi

        $sequence_3 = { 8b400c 8b7014 ad 8b00 }
            // n = 4, score = 200
            //   8b400c               | mov                 eax, dword ptr [eax + 0xc]
            //   8b7014               | mov                 esi, dword ptr [eax + 0x14]
            //   ad                   | lodsd               eax, dword ptr [esi]
            //   8b00                 | mov                 eax, dword ptr [eax]

        $sequence_4 = { 8b049a 03c6 50 e8???????? }
            // n = 4, score = 200
            //   8b049a               | mov                 eax, dword ptr [edx + ebx*4]
            //   03c6                 | add                 eax, esi
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_5 = { 33f6 8bde 85ff 7455 8b4510 89450c 8d4301 }
            // n = 7, score = 200
            //   33f6                 | xor                 esi, esi
            //   8bde                 | mov                 ebx, esi
            //   85ff                 | test                edi, edi
            //   7455                 | je                  0x57
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   89450c               | mov                 dword ptr [ebp + 0xc], eax
            //   8d4301               | lea                 eax, [ebx + 1]

        $sequence_6 = { 89450c 8d4301 0fb6d8 8a941dfcfeffff 0fb6c2 }
            // n = 5, score = 200
            //   89450c               | mov                 dword ptr [ebp + 0xc], eax
            //   8d4301               | lea                 eax, [ebx + 1]
            //   0fb6d8               | movzx               ebx, al
            //   8a941dfcfeffff       | mov                 dl, byte ptr [ebp + ebx - 0x104]
            //   0fb6c2               | movzx               eax, dl

        $sequence_7 = { 84db 75e9 5b 5d c20400 }
            // n = 5, score = 200
            //   84db                 | test                bl, bl
            //   75e9                 | jne                 0xffffffeb
            //   5b                   | pop                 ebx
            //   5d                   | pop                 ebp
            //   c20400               | ret                 4

        $sequence_8 = { 53 ff15???????? 837c241000 7423 8b442418 8b4c2410 }
            // n = 6, score = 100
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   837c241000           | cmp                 dword ptr [esp + 0x10], 0
            //   7423                 | je                  0x25
            //   8b442418             | mov                 eax, dword ptr [esp + 0x18]
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]

        $sequence_9 = { 837e04ff 8bd8 8d7e08 7504 8b2f eb02 8bef }
            // n = 7, score = 100
            //   837e04ff             | cmp                 dword ptr [esi + 4], -1
            //   8bd8                 | mov                 ebx, eax
            //   8d7e08               | lea                 edi, [esi + 8]
            //   7504                 | jne                 6
            //   8b2f                 | mov                 ebp, dword ptr [edi]
            //   eb02                 | jmp                 4
            //   8bef                 | mov                 ebp, edi

        $sequence_10 = { 833e05 7521 6a10 6a40 ff15???????? }
            // n = 5, score = 100
            //   833e05               | cmp                 dword ptr [esi], 5
            //   7521                 | jne                 0x23
            //   6a10                 | push                0x10
            //   6a40                 | push                0x40
            //   ff15????????         |                     

        $sequence_11 = { 8b0c855c300010 c1e705 33d2 03fe 42 837dfcff 8955dc }
            // n = 7, score = 100
            //   8b0c855c300010       | mov                 ecx, dword ptr [eax*4 + 0x1000305c]
            //   c1e705               | shl                 edi, 5
            //   33d2                 | xor                 edx, edx
            //   03fe                 | add                 edi, esi
            //   42                   | inc                 edx
            //   837dfcff             | cmp                 dword ptr [ebp - 4], -1
            //   8955dc               | mov                 dword ptr [ebp - 0x24], edx

        $sequence_12 = { 837efcff 7518 8b46f8 8b04855c300010 }
            // n = 4, score = 100
            //   837efcff             | cmp                 dword ptr [esi - 4], -1
            //   7518                 | jne                 0x1a
            //   8b46f8               | mov                 eax, dword ptr [esi - 8]
            //   8b04855c300010       | mov                 eax, dword ptr [eax*4 + 0x1000305c]

        $sequence_13 = { 8b4ef8 83f907 0f8781000000 ff248dfb240010 881f eb76 ff30 }
            // n = 7, score = 100
            //   8b4ef8               | mov                 ecx, dword ptr [esi - 8]
            //   83f907               | cmp                 ecx, 7
            //   0f8781000000         | ja                  0x87
            //   ff248dfb240010       | jmp                 dword ptr [ecx*4 + 0x100024fb]
            //   881f                 | mov                 byte ptr [edi], bl
            //   eb76                 | jmp                 0x78
            //   ff30                 | push                dword ptr [eax]

        $sequence_14 = { 8b55fc 8d0c8a 894dfc eb0e 8b14957c300010 }
            // n = 5, score = 100
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   8d0c8a               | lea                 ecx, [edx + ecx*4]
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   eb0e                 | jmp                 0x10
            //   8b14957c300010       | mov                 edx, dword ptr [edx*4 + 0x1000307c]

        $sequence_15 = { 0fb6805a210010 ff2485f6200010 8b8614080000 3b45f4 7e03 }
            // n = 5, score = 100
            //   0fb6805a210010       | movzx               eax, byte ptr [eax + 0x1000215a]
            //   ff2485f6200010       | jmp                 dword ptr [eax*4 + 0x100020f6]
            //   8b8614080000         | mov                 eax, dword ptr [esi + 0x814]
            //   3b45f4               | cmp                 eax, dword ptr [ebp - 0xc]
            //   7e03                 | jle                 5

    condition:
        7 of them and filesize < 57344
}