rule win_quarterrig_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.quarterrig."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.quarterrig"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e9???????? 488b8a38000000 e9???????? 488b8a40000000 4883c118 e9???????? 488b8a38000000 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   488b8a38000000       | mov                 dword ptr [ebp - 0x10], eax
            //   e9????????           |                     
            //   488b8a40000000       | dec                 esp
            //   4883c118             | mov                 dword ptr [esp + 0x20], esi
            //   e9????????           |                     
            //   488b8a38000000       | dec                 esp

        $sequence_1 = { 488d4c2428 e8???????? 4c8b00 8ad3 488bc8 41ff5040 }
            // n = 6, score = 100
            //   488d4c2428           | ret                 
            //   e8????????           |                     
            //   4c8b00               | dec                 eax
            //   8ad3                 | lea                 ecx, [0x5f227]
            //   488bc8               | jne                 0xe73
            //   41ff5040             | dec                 eax

        $sequence_2 = { 65488b042558000000 ba04000000 488b0cc8 8b040a 3905???????? 7f19 488d0580080600 }
            // n = 7, score = 100
            //   65488b042558000000     | dec    eax
            //   ba04000000           | mov                 dword ptr [ebx], eax
            //   488b0cc8             | dec                 eax
            //   8b040a               | mov                 ecx, dword ptr [ebp - 0x60]
            //   3905????????         |                     
            //   7f19                 | dec                 esp
            //   488d0580080600       | mov                 dword ptr [ebp - 0x50], esp

        $sequence_3 = { 4a8d0c37 eb0b 0fb607 48ffc7 c644042001 483bf9 75f0 }
            // n = 7, score = 100
            //   4a8d0c37             | jb                  0x3b5
            //   eb0b                 | dec                 eax
            //   0fb607               | inc                 edx
            //   48ffc7               | dec                 eax
            //   c644042001           | mov                 ecx, dword ptr [ebx]
            //   483bf9               | dec                 eax
            //   75f0                 | mov                 dword ptr [ebp + 0x18], esi

        $sequence_4 = { 488b0cc8 8b040a 3905???????? 7f1e 488d0576ef0500 488b4c2440 }
            // n = 6, score = 100
            //   488b0cc8             | cmp                 eax, 0x3d
            //   8b040a               | jb                  0x39a
            //   3905????????         |                     
            //   7f1e                 | inc                 esp
            //   488d0576ef0500       | mov                 byte ptr [ebx + 0x3d], ch
            //   488b4c2440           | inc                 ecx

        $sequence_5 = { 41b840000000 458d78d0 418bd7 488d4d28 e8???????? 448bc0 488d55e0 }
            // n = 7, score = 100
            //   41b840000000         | lea                 eax, [0x5dc0a]
            //   458d78d0             | dec                 eax
            //   418bd7               | mov                 ecx, dword ptr [ebp + 0x17]
            //   488d4d28             | dec                 eax
            //   e8????????           |                     
            //   448bc0               | xor                 ecx, esp
            //   488d55e0             | mov                 eax, dword ptr [edx + ecx]

        $sequence_6 = { e8???????? 488bd0 4438700a 7429 498bfe 408acf }
            // n = 6, score = 100
            //   e8????????           |                     
            //   488bd0               | mov                 dword ptr [ecx + 8], esp
            //   4438700a             | dec                 esp
            //   7429                 | mov                 dword ptr [ebp - 0x21], eax
            //   498bfe               | dec                 esp
            //   408acf               | mov                 esp, esi

        $sequence_7 = { 488d15fad00200 488d0dd32c0500 e8???????? 84c0 7543 448b0d???????? 4c8d05bc2c0500 }
            // n = 7, score = 100
            //   488d15fad00200       | mov                 dword ptr [ecx + 0x18], 0x201
            //   488d0dd32c0500       | dec                 eax
            //   e8????????           |                     
            //   84c0                 | mov                 dword ptr [ecx + 0x20], 6
            //   7543                 | mov                 ecx, 0x10
            //   448b0d????????       |                     
            //   4c8d05bc2c0500       | dec                 eax

        $sequence_8 = { 488bd6 488d4c2460 e8???????? 90 488b5808 48897808 488b4c2468 }
            // n = 7, score = 100
            //   488bd6               | dec                 esp
            //   488d4c2460           | mov                 dword ptr [ebp + 0x10], esi
            //   e8????????           |                     
            //   90                   | dec                 esp
            //   488b5808             | mov                 dword ptr [ebp + 0x18], esi
            //   48897808             | inc                 edx
            //   488b4c2468           | xor                 byte ptr [edx + eax], al

        $sequence_9 = { 4c8d2518470300 895c2420 81fb80000000 0f8dd7000000 4863fb 498b34fc 4885f6 }
            // n = 7, score = 100
            //   4c8d2518470300       | mov                 edx, dword ptr [ebx + 0x10]
            //   895c2420             | dec                 eax
            //   81fb80000000         | mov                 ecx, dword ptr [ebx]
            //   0f8dd7000000         | dec                 eax
            //   4863fb               | inc                 edx
            //   498b34fc             | dec                 eax
            //   4885f6               | and                 dword ptr [ebx + 0x10], 0

    condition:
        7 of them and filesize < 971776
}