rule win_quickmute_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.quickmute."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.quickmute"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 8b7c2428 57 56 8bc3 e8???????? 6a04 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b7c2428             | mov                 edi, dword ptr [esp + 0x28]
            //   57                   | push                edi
            //   56                   | push                esi
            //   8bc3                 | mov                 eax, ebx
            //   e8????????           |                     
            //   6a04                 | push                4

        $sequence_1 = { ff15???????? 8b4b54 6a04 6800100000 51 57 }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   8b4b54               | mov                 ecx, dword ptr [ebx + 0x54]
            //   6a04                 | push                4
            //   6800100000           | push                0x1000
            //   51                   | push                ecx
            //   57                   | push                edi

        $sequence_2 = { 8d853cfdffff 56 50 ff15???????? 83c414 }
            // n = 5, score = 100
            //   8d853cfdffff         | lea                 eax, [ebp - 0x2c4]
            //   56                   | push                esi
            //   50                   | push                eax
            //   ff15????????         |                     
            //   83c414               | add                 esp, 0x14

        $sequence_3 = { 56 8d85f0feffff 33db 50 c785f0feffff6d737663 c785f4feffff72742e64 }
            // n = 6, score = 100
            //   56                   | push                esi
            //   8d85f0feffff         | lea                 eax, [ebp - 0x110]
            //   33db                 | xor                 ebx, ebx
            //   50                   | push                eax
            //   c785f0feffff6d737663     | mov    dword ptr [ebp - 0x110], 0x6376736d
            //   c785f4feffff72742e64     | mov    dword ptr [ebp - 0x10c], 0x642e7472

        $sequence_4 = { c645fa6c 885dfb 66c745fc5700 750c }
            // n = 4, score = 100
            //   c645fa6c             | mov                 byte ptr [ebp - 6], 0x6c
            //   885dfb               | mov                 byte ptr [ebp - 5], bl
            //   66c745fc5700         | mov                 word ptr [ebp - 4], 0x57
            //   750c                 | jne                 0xe

        $sequence_5 = { 66833c7731 57 0f94c1 888c353cffffff 46 }
            // n = 5, score = 100
            //   66833c7731           | cmp                 word ptr [edi + esi*2], 0x31
            //   57                   | push                edi
            //   0f94c1               | sete                cl
            //   888c353cffffff       | mov                 byte ptr [ebp + esi - 0xc4], cl
            //   46                   | inc                 esi

        $sequence_6 = { 46 ff15???????? 83c404 3bf0 72e2 8d55e4 52 }
            // n = 7, score = 100
            //   46                   | inc                 esi
            //   ff15????????         |                     
            //   83c404               | add                 esp, 4
            //   3bf0                 | cmp                 esi, eax
            //   72e2                 | jb                  0xffffffe4
            //   8d55e4               | lea                 edx, [ebp - 0x1c]
            //   52                   | push                edx

        $sequence_7 = { 51 8d9424e2030000 52 8d842466020000 }
            // n = 4, score = 100
            //   51                   | push                ecx
            //   8d9424e2030000       | lea                 edx, [esp + 0x3e2]
            //   52                   | push                edx
            //   8d842466020000       | lea                 eax, [esp + 0x266]

        $sequence_8 = { 7402 ffd0 8345e404 ebe6 c745e084914000 817de088914000 }
            // n = 6, score = 100
            //   7402                 | je                  4
            //   ffd0                 | call                eax
            //   8345e404             | add                 dword ptr [ebp - 0x1c], 4
            //   ebe6                 | jmp                 0xffffffe8
            //   c745e084914000       | mov                 dword ptr [ebp - 0x20], 0x409184
            //   817de088914000       | cmp                 dword ptr [ebp - 0x20], 0x409188

        $sequence_9 = { c78542ffffff63746f72 66c78546ffffff7957 c68548ffffff00 750f }
            // n = 4, score = 100
            //   c78542ffffff63746f72     | mov    dword ptr [ebp - 0xbe], 0x726f7463
            //   66c78546ffffff7957     | mov    word ptr [ebp - 0xba], 0x5779
            //   c68548ffffff00       | mov                 byte ptr [ebp - 0xb8], 0
            //   750f                 | jne                 0x11

    condition:
        7 of them and filesize < 146432
}