rule win_radamant_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.radamant."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.radamant"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 89c8 0fb68428e8feffff c1e010 3185d0fdffff 8b85d0fdffff }
            // n = 5, score = 100
            //   89c8                 | mov                 eax, ecx
            //   0fb68428e8feffff     | movzx               eax, byte ptr [eax + ebp - 0x118]
            //   c1e010               | shl                 eax, 0x10
            //   3185d0fdffff         | xor                 dword ptr [ebp - 0x230], eax
            //   8b85d0fdffff         | mov                 eax, dword ptr [ebp - 0x230]

        $sequence_1 = { 8b45f4 83c01c 8b00 c1e818 0fb6c0 0fb680b0094100 31d0 }
            // n = 7, score = 100
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   83c01c               | add                 eax, 0x1c
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   c1e818               | shr                 eax, 0x18
            //   0fb6c0               | movzx               eax, al
            //   0fb680b0094100       | movzx               eax, byte ptr [eax + 0x4109b0]
            //   31d0                 | xor                 eax, edx

        $sequence_2 = { 31c2 8b45e4 0fb6c0 0fb680b01a4100 }
            // n = 4, score = 100
            //   31c2                 | xor                 edx, eax
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]
            //   0fb6c0               | movzx               eax, al
            //   0fb680b01a4100       | movzx               eax, byte ptr [eax + 0x411ab0]

        $sequence_3 = { 29c1 89c8 83c061 8945ac e8???????? 89c1 }
            // n = 6, score = 100
            //   29c1                 | sub                 ecx, eax
            //   89c8                 | mov                 eax, ecx
            //   83c061               | add                 eax, 0x61
            //   8945ac               | mov                 dword ptr [ebp - 0x54], eax
            //   e8????????           |                     
            //   89c1                 | mov                 ecx, eax

        $sequence_4 = { 8945e0 8b4508 89442408 c7442404???????? 8b45e0 }
            // n = 5, score = 100
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   89442408             | mov                 dword ptr [esp + 8], eax
            //   c7442404????????     |                     
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]

        $sequence_5 = { 8d148500000000 01d0 29c1 89c8 83c061 8945ac }
            // n = 6, score = 100
            //   8d148500000000       | lea                 edx, [eax*4]
            //   01d0                 | add                 eax, edx
            //   29c1                 | sub                 ecx, eax
            //   89c8                 | mov                 eax, ecx
            //   83c061               | add                 eax, 0x61
            //   8945ac               | mov                 dword ptr [ebp - 0x54], eax

        $sequence_6 = { 8d85e4feffff 89442414 8d85e8feffff 89442410 }
            // n = 4, score = 100
            //   8d85e4feffff         | lea                 eax, [ebp - 0x11c]
            //   89442414             | mov                 dword ptr [esp + 0x14], eax
            //   8d85e8feffff         | lea                 eax, [ebp - 0x118]
            //   89442410             | mov                 dword ptr [esp + 0x10], eax

        $sequence_7 = { 8944240c 8b4510 89442408 8b45f8 03450c 83c018 }
            // n = 6, score = 100
            //   8944240c             | mov                 dword ptr [esp + 0xc], eax
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   89442408             | mov                 dword ptr [esp + 8], eax
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   03450c               | add                 eax, dword ptr [ebp + 0xc]
            //   83c018               | add                 eax, 0x18

        $sequence_8 = { 83ec04 89850cfeffff c744240810000000 8d8508feffff 89442404 8b8520feffff 890424 }
            // n = 7, score = 100
            //   83ec04               | sub                 esp, 4
            //   89850cfeffff         | mov                 dword ptr [ebp - 0x1f4], eax
            //   c744240810000000     | mov                 dword ptr [esp + 8], 0x10
            //   8d8508feffff         | lea                 eax, [ebp - 0x1f8]
            //   89442404             | mov                 dword ptr [esp + 4], eax
            //   8b8520feffff         | mov                 eax, dword ptr [ebp - 0x1e0]
            //   890424               | mov                 dword ptr [esp], eax

        $sequence_9 = { e9???????? c745f800000000 837df806 0f8f8d010000 }
            // n = 4, score = 100
            //   e9????????           |                     
            //   c745f800000000       | mov                 dword ptr [ebp - 8], 0
            //   837df806             | cmp                 dword ptr [ebp - 8], 6
            //   0f8f8d010000         | jg                  0x193

    condition:
        7 of them and filesize < 204800
}