rule win_ramsay_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.ramsay."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ramsay"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 85c0 7502 eb02 ebb1 }
            // n = 5, score = 600
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7502                 | jne                 4
            //   eb02                 | jmp                 4
            //   ebb1                 | jmp                 0xffffffb3

        $sequence_1 = { 7514 ff15???????? 83f820 7502 eb07 33c0 }
            // n = 6, score = 600
            //   7514                 | jne                 0x16
            //   ff15????????         |                     
            //   83f820               | cmp                 eax, 0x20
            //   7502                 | jne                 4
            //   eb07                 | jmp                 9
            //   33c0                 | xor                 eax, eax

        $sequence_2 = { 8b4de8 83b9a001000006 753f c745f401000000 c745f800000000 eb09 }
            // n = 6, score = 500
            //   8b4de8               | mov                 ecx, dword ptr [ebp - 0x18]
            //   83b9a001000006       | cmp                 dword ptr [ecx + 0x1a0], 6
            //   753f                 | jne                 0x41
            //   c745f401000000       | mov                 dword ptr [ebp - 0xc], 1
            //   c745f800000000       | mov                 dword ptr [ebp - 8], 0
            //   eb09                 | jmp                 0xb

        $sequence_3 = { 732c e8???????? 33d2 b93e000000 f7f1 8955f4 }
            // n = 6, score = 500
            //   732c                 | jae                 0x2e
            //   e8????????           |                     
            //   33d2                 | xor                 edx, edx
            //   b93e000000           | mov                 ecx, 0x3e
            //   f7f1                 | div                 ecx
            //   8955f4               | mov                 dword ptr [ebp - 0xc], edx

        $sequence_4 = { 8b4508 8a481e 884a03 8b5508 8b4508 8a4815 884a1e }
            // n = 7, score = 500
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8a481e               | mov                 cl, byte ptr [eax + 0x1e]
            //   884a03               | mov                 byte ptr [edx + 3], cl
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8a4815               | mov                 cl, byte ptr [eax + 0x15]
            //   884a1e               | mov                 byte ptr [edx + 0x1e], cl

        $sequence_5 = { c745e800000000 c745ec00000000 c745f088020000 c745f400000000 6888020000 }
            // n = 5, score = 500
            //   c745e800000000       | mov                 dword ptr [ebp - 0x18], 0
            //   c745ec00000000       | mov                 dword ptr [ebp - 0x14], 0
            //   c745f088020000       | mov                 dword ptr [ebp - 0x10], 0x288
            //   c745f400000000       | mov                 dword ptr [ebp - 0xc], 0
            //   6888020000           | push                0x288

        $sequence_6 = { 8945fc 6a00 6a00 8b55f8 52 8b45fc 50 }
            // n = 7, score = 500
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   52                   | push                edx
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   50                   | push                eax

        $sequence_7 = { 6a00 8d55f4 52 8b450c 8b08 }
            // n = 5, score = 500
            //   6a00                 | push                0
            //   8d55f4               | lea                 edx, [ebp - 0xc]
            //   52                   | push                edx
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8b08                 | mov                 ecx, dword ptr [eax]

        $sequence_8 = { 8b55e8 0355f8 8a8294010000 8801 ebd3 eb0a 8b4de8 }
            // n = 7, score = 500
            //   8b55e8               | mov                 edx, dword ptr [ebp - 0x18]
            //   0355f8               | add                 edx, dword ptr [ebp - 8]
            //   8a8294010000         | mov                 al, byte ptr [edx + 0x194]
            //   8801                 | mov                 byte ptr [ecx], al
            //   ebd3                 | jmp                 0xffffffd5
            //   eb0a                 | jmp                 0xc
            //   8b4de8               | mov                 ecx, dword ptr [ebp - 0x18]

        $sequence_9 = { 8a45ff 884207 c645f000 33c9 894df1 }
            // n = 5, score = 500
            //   8a45ff               | mov                 al, byte ptr [ebp - 1]
            //   884207               | mov                 byte ptr [edx + 7], al
            //   c645f000             | mov                 byte ptr [ebp - 0x10], 0
            //   33c9                 | xor                 ecx, ecx
            //   894df1               | mov                 dword ptr [ebp - 0xf], ecx

        $sequence_10 = { ff15???????? 33c0 e9???????? e8???????? 85c0 7507 33c0 }
            // n = 7, score = 400
            //   ff15????????         |                     
            //   33c0                 | xor                 eax, eax
            //   e9????????           |                     
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7507                 | jne                 9
            //   33c0                 | xor                 eax, eax

        $sequence_11 = { e9???????? 41b908000000 4c8d057b560200 8b9424e8010000 }
            // n = 4, score = 200
            //   e9????????           |                     
            //   41b908000000         | mov                 eax, 0xa28
            //   4c8d057b560200       | xor                 edx, edx
            //   8b9424e8010000       | dec                 eax

        $sequence_12 = { e9???????? 41b80e000000 488d542450 488b8c2408050000 }
            // n = 4, score = 200
            //   e9????????           |                     
            //   41b80e000000         | inc                 ecx
            //   488d542450           | mov                 eax, 0xe
            //   488b8c2408050000     | dec                 eax

        $sequence_13 = { e9???????? 41b868000000 33d2 488d8c2400070000 }
            // n = 4, score = 200
            //   e9????????           |                     
            //   41b868000000         | dec                 eax
            //   33d2                 | lea                 ecx, [esp + 0x60]
            //   488d8c2400070000     | inc                 ecx

        $sequence_14 = { e9???????? 41b8280a0000 33d2 488d4c2460 }
            // n = 4, score = 200
            //   e9????????           |                     
            //   41b8280a0000         | lea                 edx, [esp + 0x50]
            //   33d2                 | dec                 eax
            //   488d4c2460           | mov                 ecx, dword ptr [esp + 0x508]

        $sequence_15 = { e9???????? 41b908000000 4c8d05929b0200 8b542420 }
            // n = 4, score = 200
            //   e9????????           |                     
            //   41b908000000         | dec                 eax
            //   4c8d05929b0200       | lea                 ecx, [esp + 0x700]
            //   8b542420             | inc                 ecx

    condition:
        7 of them and filesize < 2031616
}