rule win_rc2fm_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.rc2fm."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rc2fm"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4d8bce 4c2b4e08 4533c0 33d2 488bcb 4c03c8 897c2428 }
            // n = 7, score = 100
            //   4d8bce               | jne                 0x18a7
            //   4c2b4e08             | dec                 eax
            //   4533c0               | lea                 eax, [ebp - 0x19]
            //   33d2                 | mov                 byte ptr [esp + 0x30], 0
            //   488bcb               | dec                 eax
            //   4c03c8               | lea                 edx, [0x16ef2]
            //   897c2428             | dec                 eax

        $sequence_1 = { 48b8bd427ae5d594bfd6 48034c2450 41b903000000 4533c0 c744242808000000 48895c2420 48f7e1 }
            // n = 7, score = 100
            //   48b8bd427ae5d594bfd6     | dec    eax
            //   48034c2450           | mov                 ebx, ecx
            //   41b903000000         | sub                 edi, dword ptr [ecx + 0x18]
            //   4533c0               | push                edi
            //   c744242808000000     | dec                 eax
            //   48895c2420           | sub                 esp, 0x30
            //   48f7e1               | mov                 esi, ecx

        $sequence_2 = { 488d451f 48899c24c0000000 33db 41b93f000f00 4533c0 4c89a42488000000 4889442420 }
            // n = 7, score = 100
            //   488d451f             | test                ecx, ecx
            //   48899c24c0000000     | je                  0x3ef
            //   33db                 | dec                 esp
            //   41b93f000f00         | lea                 eax, [ebx + 0x1c]
            //   4533c0               | dec                 esp
            //   4c89a42488000000     | sub                 edx, ebx
            //   4889442420           | inc                 ebx

        $sequence_3 = { 03c1 46011c08 4883c202 49ffca 75c3 418b4004 4c03c0 }
            // n = 7, score = 100
            //   03c1                 | dec                 esp
            //   46011c08             | mov                 eax, edi
            //   4883c202             | xor                 ecx, ecx
            //   49ffca               | dec                 eax
            //   75c3                 | mov                 dword ptr [esp + 0x20], eax
            //   418b4004             | test                al, al
            //   4c03c0               | inc                 ebp

        $sequence_4 = { 488bcb e8???????? eb62 488d151bf9ffff 4c8bc3 e8???????? 84c0 }
            // n = 7, score = 100
            //   488bcb               | dec                 eax
            //   e8????????           |                     
            //   eb62                 | mov                 ebx, dword ptr [esp + 0xc8]
            //   488d151bf9ffff       | dec                 eax
            //   4c8bc3               | add                 esp, 0x80
            //   e8????????           |                     
            //   84c0                 | inc                 ecx

        $sequence_5 = { 66894503 0fb64500 4c897c2420 66894501 0fb645ff 668945ff ff15???????? }
            // n = 7, score = 100
            //   66894503             | test                al, al
            //   0fb64500             | jne                 0x4f2
            //   4c897c2420           | mov                 edx, 0x40002
            //   66894501             | mov                 ecx, 0x10001
            //   0fb645ff             | dec                 eax
            //   668945ff             | lea                 edx, [0xffffeecc]
            //   ff15????????         |                     

        $sequence_6 = { 894158 488b4168 66893c50 8b5174 488b4968 8d1455feffffff e8???????? }
            // n = 7, score = 100
            //   894158               | mov                 ecx, 0x10013
            //   488b4168             | inc                 eax
            //   66893c50             | mov                 bh, 0xe
            //   8b5174               | mov                 edx, 0x40000
            //   488b4968             | inc                 esp
            //   8d1455feffffff       | mov                 eax, eax
            //   e8????????           |                     

        $sequence_7 = { 41b808020000 4889b42488000000 ff15???????? 488bf0 4885c0 0f84b6010000 }
            // n = 6, score = 100
            //   41b808020000         | test                al, al
            //   4889b42488000000     | dec                 esp
            //   ff15????????         |                     
            //   488bf0               | lea                 ecx, [0x19792]
            //   4885c0               | inc                 esp
            //   0f84b6010000         | lea                 eax, [edx + 1]

        $sequence_8 = { ba0a000500 b900000100 448bc0 e8???????? 488b4c2450 488b01 ff5010 }
            // n = 7, score = 100
            //   ba0a000500           | mov                 edx, 0x30003
            //   b900000100           | inc                 esp
            //   448bc0               | mov                 ecx, eax
            //   e8????????           |                     
            //   488b4c2450           | mov                 ecx, 0x10010
            //   488b01               | jmp                 0x1faf
            //   ff5010               | mov                 edx, 0x10000

        $sequence_9 = { ff15???????? 488bd8 4883f8ff 742d 33d2 488bc8 ff15???????? }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   488bd8               | jb                  0xe3
            //   4883f8ff             | dec                 eax
            //   742d                 | mov                 ecx, dword ptr [ebx + 0x50]
            //   33d2                 | inc                 esp
            //   488bc8               | mov                 eax, edi
            //   ff15????????         |                     

    condition:
        7 of them and filesize < 410624
}