rule win_rcs_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.rcs."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rcs"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 5f 5e 5d 5b 33c0 }
            // n = 6, score = 200
            //   ff15????????         |                     
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   5b                   | pop                 ebx
            //   33c0                 | xor                 eax, eax

        $sequence_1 = { 89442456 8944245a 8944245e 89442462 89442466 8944246a }
            // n = 6, score = 200
            //   89442456             | mov                 dword ptr [esp + 0x56], eax
            //   8944245a             | mov                 dword ptr [esp + 0x5a], eax
            //   8944245e             | mov                 dword ptr [esp + 0x5e], eax
            //   89442462             | mov                 dword ptr [esp + 0x62], eax
            //   89442466             | mov                 dword ptr [esp + 0x66], eax
            //   8944246a             | mov                 dword ptr [esp + 0x6a], eax

        $sequence_2 = { 85ff 0f84d4000000 57 e8???????? }
            // n = 4, score = 200
            //   85ff                 | test                edi, edi
            //   0f84d4000000         | je                  0xda
            //   57                   | push                edi
            //   e8????????           |                     

        $sequence_3 = { e8???????? 83c430 6aff 68???????? }
            // n = 4, score = 200
            //   e8????????           |                     
            //   83c430               | add                 esp, 0x30
            //   6aff                 | push                -1
            //   68????????           |                     

        $sequence_4 = { 40 68???????? 50 e8???????? 83c40c eb0d }
            // n = 6, score = 200
            //   40                   | inc                 eax
            //   68????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   eb0d                 | jmp                 0xf

        $sequence_5 = { 6a01 6a00 6a05 6800000040 }
            // n = 4, score = 200
            //   6a01                 | push                1
            //   6a00                 | push                0
            //   6a05                 | push                5
            //   6800000040           | push                0x40000000

        $sequence_6 = { 81f1ff2fe523 85cd f9 33d9 }
            // n = 4, score = 100
            //   81f1ff2fe523         | xor                 ecx, 0x23e52fff
            //   85cd                 | test                ebp, ecx
            //   f9                   | stc                 
            //   33d9                 | xor                 ebx, ecx

        $sequence_7 = { 83e001 48 83e004 83c004 }
            // n = 4, score = 100
            //   83e001               | and                 eax, 1
            //   48                   | dec                 eax
            //   83e004               | and                 eax, 4
            //   83c004               | add                 eax, 4

        $sequence_8 = { 6a6e ff5760 8bb7dc000000 898610120000 5f 5e c9 }
            // n = 7, score = 100
            //   6a6e                 | push                0x6e
            //   ff5760               | call                dword ptr [edi + 0x60]
            //   8bb7dc000000         | mov                 esi, dword ptr [edi + 0xdc]
            //   898610120000         | mov                 dword ptr [esi + 0x1210], eax
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   c9                   | leave               

        $sequence_9 = { 3b5d0c 7506 8b7d08 897dfc 8b7d08 89fe }
            // n = 6, score = 100
            //   3b5d0c               | cmp                 ebx, dword ptr [ebp + 0xc]
            //   7506                 | jne                 8
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   897dfc               | mov                 dword ptr [ebp - 4], edi
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   89fe                 | mov                 esi, edi

        $sequence_10 = { c78578fffbff06000000 c7857cfffbff00000100 c78588fffbff00028004 8365ec00 8d8518fffbff }
            // n = 5, score = 100
            //   c78578fffbff06000000     | mov    dword ptr [ebp - 0x40088], 6
            //   c7857cfffbff00000100     | mov    dword ptr [ebp - 0x40084], 0x10000
            //   c78588fffbff00028004     | mov    dword ptr [ebp - 0x40078], 0x4800200
            //   8365ec00             | and                 dword ptr [ebp - 0x14], 0
            //   8d8518fffbff         | lea                 eax, [ebp - 0x400e8]

        $sequence_11 = { 0508070000 50 ff96b8000000 43 83fb0f 72dd }
            // n = 6, score = 100
            //   0508070000           | add                 eax, 0x708
            //   50                   | push                eax
            //   ff96b8000000         | call                dword ptr [esi + 0xb8]
            //   43                   | inc                 ebx
            //   83fb0f               | cmp                 ebx, 0xf
            //   72dd                 | jb                  0xffffffdf

        $sequence_12 = { 81f20c055354 66f7c54b45 f5 6681fca14f }
            // n = 4, score = 100
            //   81f20c055354         | xor                 edx, 0x5453050c
            //   66f7c54b45           | test                bp, 0x454b
            //   f5                   | cmc                 
            //   6681fca14f           | cmp                 sp, 0x4fa1

        $sequence_13 = { 83fb01 741d 83fb02 7418 83fb03 7413 }
            // n = 6, score = 100
            //   83fb01               | cmp                 ebx, 1
            //   741d                 | je                  0x1f
            //   83fb02               | cmp                 ebx, 2
            //   7418                 | je                  0x1a
            //   83fb03               | cmp                 ebx, 3
            //   7413                 | je                  0x15

        $sequence_14 = { 740c c785a0f9fbff00e0ffff eb0a c785a0f9fbff80faffff ffb5a0f9fbff }
            // n = 5, score = 100
            //   740c                 | je                  0xe
            //   c785a0f9fbff00e0ffff     | mov    dword ptr [ebp - 0x40660], 0xffffe000
            //   eb0a                 | jmp                 0xc
            //   c785a0f9fbff80faffff     | mov    dword ptr [ebp - 0x40660], 0xfffffa80
            //   ffb5a0f9fbff         | push                dword ptr [ebp - 0x40660]

        $sequence_15 = { ffb5a0f9fbff 8b86dc000000 8b5020 8b805c020000 }
            // n = 4, score = 100
            //   ffb5a0f9fbff         | push                dword ptr [ebp - 0x40660]
            //   8b86dc000000         | mov                 eax, dword ptr [esi + 0xdc]
            //   8b5020               | mov                 edx, dword ptr [eax + 0x20]
            //   8b805c020000         | mov                 eax, dword ptr [eax + 0x25c]

        $sequence_16 = { 8b7d08 8b37 81c608020000 56 ff75fc ff5704 894764 }
            // n = 7, score = 100
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   8b37                 | mov                 esi, dword ptr [edi]
            //   81c608020000         | add                 esi, 0x208
            //   56                   | push                esi
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   ff5704               | call                dword ptr [edi + 4]
            //   894764               | mov                 dword ptr [edi + 0x64], eax

        $sequence_17 = { 83fb01 750e 8b463c 8d5640 }
            // n = 4, score = 100
            //   83fb01               | cmp                 ebx, 1
            //   750e                 | jne                 0x10
            //   8b463c               | mov                 eax, dword ptr [esi + 0x3c]
            //   8d5640               | lea                 edx, [esi + 0x40]

    condition:
        7 of them and filesize < 11501568
}